/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform;

import com.github.weisj.darklaf.platform.NativeUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLibrary {
    protected final Logger logger;
    private final String path;
    private final String libraryName;
    private boolean loaded;
    private boolean attemptedLoad;

    public AbstractLibrary(String path, String libraryName) {
        this(path, libraryName, Logger.getLogger(libraryName));
    }

    public AbstractLibrary(String path, String libraryName, Logger logger) {
        this.path = path;
        this.libraryName = libraryName;
        this.logger = logger;
    }

    public void updateLibrary() {
        if (!this.isLoaded() && !this.attemptedLoad) {
            this.loadLibrary();
        }
    }

    private void loadLibrary() {
        this.attemptedLoad = true;
        if (!this.canLoad() || this.isLoaded()) {
            return;
        }
        try {
            String path = this.getLibraryPath();
            if (path != null && !path.isEmpty()) {
                NativeUtil.loadLibraryFromJarWithExtraResources(this.getLibraryPath(), this.getResourcePaths());
                this.loaded = true;
                this.info("Loaded " + this.getLibraryName() + ".");
            }
        }
        catch (Throwable e) {
            this.error("Could not load library " + this.getLibraryName() + ".", e);
        }
    }

    protected List<NativeUtil.Resource> getResourcePaths() {
        return Collections.emptyList();
    }

    public String getLibraryPath() {
        return this.getPath() + this.getLibraryName();
    }

    protected String getPath() {
        return this.path;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    protected abstract boolean canLoad();

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void info(String message) {
        if (this.logger != null) {
            this.logger.info(message);
        }
    }

    protected void warning(String message) {
        if (this.logger != null) {
            this.logger.warning(message);
        }
    }

    protected void error(String message, Throwable e) {
        if (this.logger != null) {
            this.logger.log(Level.SEVERE, message, e);
        }
    }
}

