/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apache.jorphan.gui.ui.AddUndoableEditListenerPropertyChangeListener;
import org.apache.jorphan.gui.ui.DefaultUndoManager;
import org.apiguardian.api.API;

@API(since="5.3", status=API.Status.INTERNAL)
public class TextComponentUI {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_MAC = Pattern.compile("mac os x|darwin|osx", 2).matcher(OS_NAME).find();
    private static final int COMMAND_KEY = IS_MAC ? 256 : 128;
    @API(since="5.3", status=API.Status.INTERNAL)
    public static final TextComponentUI INSTANCE = new TextComponentUI();
    private final AtomicInteger undoEpoch = new AtomicInteger();

    @API(since="5.3", status=API.Status.INTERNAL)
    public void resetUndoHistory() {
        this.undoEpoch.getAndIncrement();
    }

    @API(since="5.3", status=API.Status.INTERNAL)
    public void installUndo(JTextComponent component) {
        final DefaultUndoManager manager = new DefaultUndoManager(this.undoEpoch);
        manager.setLimit(200);
        component.addPropertyChangeListener("document", new AddUndoableEditListenerPropertyChangeListener(manager));
        component.getActionMap().put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (manager.canUndo()) {
                    manager.undo();
                }
            }
        });
        component.getActionMap().put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (manager.canRedo()) {
                    manager.redo();
                }
            }
        });
        KeyStroke commandZ = KeyStroke.getKeyStroke(90, COMMAND_KEY);
        component.getInputMap().put(commandZ, "undo");
        KeyStroke shiftCommandZ = KeyStroke.getKeyStroke(90, COMMAND_KEY | 0x40);
        component.getInputMap().put(shiftCommandZ, "redo");
    }

    @API(since="5.5", status=API.Status.INTERNAL)
    public static void uninstallUndo(JTextComponent component) {
        ArrayList<AddUndoableEditListenerPropertyChangeListener> listenersToRemove = new ArrayList<AddUndoableEditListenerPropertyChangeListener>();
        for (PropertyChangeListener listener : component.getPropertyChangeListeners("document")) {
            if (!(listener instanceof AddUndoableEditListenerPropertyChangeListener)) continue;
            AddUndoableEditListenerPropertyChangeListener v = (AddUndoableEditListenerPropertyChangeListener)listener;
            listenersToRemove.add(v);
            UndoManager undoManager = v.getUndoManager();
            undoManager.discardAllEdits();
            Document document = component.getDocument();
            if (document == null) continue;
            document.removeUndoableEditListener(undoManager);
        }
        for (PropertyChangeListener propertyChangeListener : listenersToRemove) {
            component.removePropertyChangeListener("document", propertyChangeListener);
        }
    }
}

