﻿using Lucene.Net.QueryParsers.Flexible.Core.Builders;
using Lucene.Net.QueryParsers.Flexible.Core.Nodes;
using Lucene.Net.Search;

namespace Lucene.Net.QueryParsers.Flexible.Standard.Builders
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// This builder basically reads the <see cref="Query"/> object set on the
    /// <see cref="SlopQueryNode"/> child using
    /// <see cref="QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID"/> and applies the slop value
    /// defined in the <see cref="SlopQueryNode"/>.
    /// </summary>
    public class SlopQueryNodeBuilder : IStandardQueryBuilder
    {
        public SlopQueryNodeBuilder()
        {
            // empty constructor
        }

        public virtual Query Build(IQueryNode queryNode)
        {
            SlopQueryNode phraseSlopNode = (SlopQueryNode)queryNode;

            Query query = (Query)phraseSlopNode.GetChild().GetTag(
                QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);

            if (query is PhraseQuery)
            {
                ((PhraseQuery)query).Slop = phraseSlopNode.Value;
            }
            else
            {
                ((MultiPhraseQuery)query).Slop = phraseSlopNode.Value;
            }

            return query;
        }
    }
}
