/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.conversation;

public class DummyBean implements ConversationBindingListener
{
    private String data;

    public static ConversationBindingListener callback;

    public DummyBean()
    {
    }

    public void touch()
    {
    }

    public String getData()
    {
        return data;
    }

    public void setData(String data)
    {
        this.data = data;
    }

    public Conversation checkCurrentConversation()
    {
        return Conversation.getCurrentInstance();
    }

    public void invalidateSelf()
    {
        Conversation.getCurrentInstance().invalidate();
    }

    public void invalidateAndRestartSelf()
    {
        Conversation.getCurrentInstance().invalidateAndRestart();
    }

    public DummyBean getRaw()
    {
        return this;
    }

    public void valueBound(ConversationBindingEvent event)
    {
        callback.valueBound(event);
    }

    public void valueUnbound(ConversationBindingEvent event)
    {
        callback.valueUnbound(event);
    }
}
