/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StyleClasses
implements Serializable {
    private static final long serialVersionUID = 3738052927067803517L;
    private static final Logger LOG = LoggerFactory.getLogger(StyleClasses.class);
    public static final char SEPARATOR = '-';
    public static final String PREFIX = "tobago-";
    public static final String MARKUP = "-markup-";
    private ListOrderedSet classes = new ListOrderedSet();

    public StyleClasses() {
    }

    public StyleClasses(UIComponent component, String sub) {
        this();
        this.addClass(StringUtils.uncapitalize((String)component.getRendererType()), sub);
    }

    private StyleClasses(StyleClasses base) {
        this();
        this.classes.addAll((Collection)base.classes);
    }

    public static StyleClasses ensureStyleClasses(UIComponent component) {
        Map attributes = component.getAttributes();
        StyleClasses classes = (StyleClasses)attributes.get("styleClass");
        if (classes == null) {
            classes = new StyleClasses();
            attributes.put("styleClass", classes);
        }
        return classes;
    }

    public static StyleClasses ensureStyleClassesCopy(UIComponent component) {
        return new StyleClasses(StyleClasses.ensureStyleClasses(component));
    }

    @Deprecated
    public void addFullQualifiedClass(String clazz) {
        this.classes.add((Object)clazz);
    }

    @Deprecated
    public void removeFullQualifiedClass(String clazz) {
        this.classes.remove((Object)clazz);
    }

    public void addClass(String renderer, String sub) {
        this.classes.add((Object)this.nameOfClass(renderer, sub));
    }

    public void removeClass(String renderer, String sub) {
        this.classes.remove((Object)this.nameOfClass(renderer, sub));
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    private String nameOfClass(String renderer, String sub) {
        StringBuilder builder = new StringBuilder(PREFIX);
        builder.append(renderer);
        builder.append('-');
        builder.append(sub);
        return builder.toString();
    }

    public void addMarkupClass(String renderer, String markup) {
        this.addMarkupClass(renderer, null, markup);
    }

    public void removeMarkupClass(String renderer, String markup) {
        this.removeMarkupClass(renderer, null, markup);
    }

    public void addMarkupClass(String renderer, String sub, String markup) {
        this.classes.add((Object)this.nameOfMarkupClass(renderer, sub, markup));
    }

    public void removeMarkupClass(String renderer, String sub, String markup) {
        this.classes.remove((Object)this.nameOfMarkupClass(renderer, sub, markup));
    }

    private String nameOfMarkupClass(String renderer, String sub, String markup) {
        StringBuilder builder = new StringBuilder(PREFIX);
        builder.append(renderer);
        if (sub != null) {
            builder.append('-');
            builder.append(sub);
        }
        builder.append(MARKUP);
        builder.append(markup);
        return builder.toString();
    }

    public void addMarkupClass(UIComponent component, String rendererName) {
        if (component instanceof SupportsMarkup) {
            this.addMarkupClass((SupportsMarkup)component, rendererName, null);
        }
    }

    public void addMarkupClass(SupportsMarkup supportsMarkup, String rendererName, String sub) {
        Markup m = supportsMarkup.getCurrentMarkup();
        if (m != null) {
            for (String markup : m) {
                Theme theme = ClientProperties.getInstance((FacesContext)FacesContext.getCurrentInstance()).getTheme();
                if (theme.getRenderersConfig().isMarkupSupported(rendererName, markup)) {
                    this.addMarkupClass(rendererName, sub, markup);
                    continue;
                }
                if ("none".equals(markup)) {
                    Deprecation.LOG.warn("Markup 'none' is deprecated, please use a NULL pointer instead.");
                    continue;
                }
                LOG.warn("Unknown markup='" + markup + "'");
            }
        }
    }

    public void addAspectClass(String renderer, Aspect aspect) {
        this.classes.add((Object)this.nameOfAspectClass(renderer, aspect));
    }

    public void removeAspectClass(String renderer, Aspect aspect) {
        this.classes.remove((Object)this.nameOfAspectClass(renderer, aspect));
    }

    private String nameOfAspectClass(String renderer, Aspect aspect) {
        StringBuilder builder = new StringBuilder(PREFIX);
        builder.append(renderer);
        builder.append((Object)aspect);
        return builder.toString();
    }

    public void addAspectClass(String renderer, String sub, Aspect aspect) {
        this.classes.add((Object)this.nameOfAspectClass(renderer, sub, aspect));
    }

    public void removeAspectClass(String renderer, String sub, Aspect aspect) {
        this.classes.remove((Object)this.nameOfAspectClass(renderer, sub, aspect));
    }

    private String nameOfAspectClass(String renderer, String sub, Aspect aspect) {
        StringBuilder builder = new StringBuilder(PREFIX);
        builder.append(renderer);
        builder.append('-');
        builder.append(sub);
        builder.append((Object)aspect);
        return builder.toString();
    }

    public void addClasses(StyleClasses styleClasses) {
        for (String clazz : styleClasses.classes) {
            this.classes.add((Object)clazz);
        }
    }

    public void removeClass(String clazz) {
        this.classes.remove((Object)clazz);
    }

    public void removeTobagoClasses(String rendererName) {
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            String clazz = (String)i.next();
            if (!clazz.startsWith(PREFIX + rendererName)) continue;
            i.remove();
        }
    }

    public void updateClassAttributeAndMarkup(UIComponent component, String rendererName) {
        this.updateClassAttribute(component, rendererName);
        this.addMarkupClass(component, rendererName);
    }

    public void updateClassAttribute(UIComponent component, String rendererName) {
        this.removeTobagoClasses(rendererName);
        this.addAspectClass(rendererName, Aspect.DEFAULT);
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"disabled")) {
            this.addAspectClass(rendererName, Aspect.DISABLED);
        }
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"readonly")) {
            this.addAspectClass(rendererName, Aspect.READONLY);
        }
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"inline")) {
            this.addAspectClass(rendererName, Aspect.INLINE);
        }
        if (component instanceof UIInput) {
            UIInput input = (UIInput)component;
            if (ComponentUtils.isError((UIInput)input)) {
                this.addAspectClass(rendererName, Aspect.ERROR);
            }
            if (input.isRequired()) {
                this.addAspectClass(rendererName, Aspect.REQUIRED);
            }
        }
    }

    public String toString() {
        if (this.classes.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(16 * this.classes.size());
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            String clazz = (String)i.next();
            buffer.append(clazz);
            if (!i.hasNext()) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    @Deprecated
    public static enum Aspect {
        DEFAULT,
        DISABLED,
        READONLY,
        INLINE,
        ERROR,
        REQUIRED;

        private String aspect = this.name().equals("DEFAULT") ? "" : '-' + this.name().toLowerCase(Locale.ENGLISH);

        public String toString() {
            return this.aspect;
        }
    }
}

