/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import org.apache.myfaces.tobago.layout.Dimension;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Position;

public class Box {
    private Position position;
    private Dimension dimension;

    public Box(Position position, Dimension dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    public Box(String string) {
        int comma = string.indexOf(44);
        if (comma >= 0 && (comma = string.indexOf(44, comma + 1)) >= 0) {
            this.position = new Position(string.substring(0, comma));
            this.dimension = new Dimension(string.substring(comma + 1));
            return;
        }
        throw new IllegalArgumentException("Can't parse to a box: '" + string + "'");
    }

    public Measure getRight() {
        return this.position.getLeft().add(this.dimension.getWidth());
    }

    public Measure getBottom() {
        return this.position.getTop().add(this.dimension.getHeight());
    }

    public Measure getLeft() {
        return this.position.getLeft();
    }

    public void setLeft(Measure left) {
        this.position.setLeft(left);
    }

    public Measure getTop() {
        return this.position.getTop();
    }

    public void setTop(Measure top) {
        this.position.setTop(top);
    }

    public Measure getWidth() {
        return this.dimension.getWidth();
    }

    public void setWidth(Measure width) {
        this.dimension.setWidth(width);
    }

    public Measure getHeight() {
        return this.dimension.getHeight();
    }

    public void setHeight(Measure height) {
        this.dimension.setHeight(height);
    }

    public String toString() {
        return "" + this.position + ',' + this.dimension;
    }
}

