/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecodingCommandRendererBase
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(DecodingCommandRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly(component)) {
            return;
        }
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sourceId = '" + sourceId + "'");
            LOG.debug("clientId = '" + clientId + "'");
        }
        if (clientId.equals(sourceId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("queueEvent = '" + clientId + "'");
            }
            this.commandActivated(component);
        }
        RenderUtils.decodeClientBehaviors(facesContext, component);
    }

    protected void commandActivated(UIComponent component) {
        component.queueEvent((FacesEvent)new ActionEvent(component));
    }
}

