/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.style.ParsedPropertyKey;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStyle
implements Style,
Serializable {
    private Object[] _properties;
    private transient Object[] _parsedProperties;
    private static final int _PARSED_PROPERTIES_COUNT = 7;
    private static final Object _NULL_VALUE = new Object();

    public BaseStyle() {
    }

    public BaseStyle(Map<String, String> properties) {
        if (properties != null && properties.size() > 0) {
            int length = properties.size() * 2;
            this._properties = new String[length];
            int i = 0;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this._properties[i * 2] = key.toLowerCase();
                this._properties[i * 2 + 1] = value;
                ++i;
            }
        }
    }

    public BaseStyle(Style style) {
        if (style != null) {
            int propertyCount = 0;
            Iterator<Object> e = style.getPropertyNames();
            while (e.hasNext()) {
                e.next();
                ++propertyCount;
            }
            if (propertyCount == 0) {
                return;
            }
            Object[] properties = new Object[propertyCount * 2];
            int i = 0;
            Iterator<Object> names = style.getPropertyNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = style.getProperty(name);
                properties[i * 2] = name.toLowerCase();
                properties[i * 2 + 1] = value;
                ++i;
            }
            this._properties = properties;
        }
    }

    @Override
    public Iterator<Object> getPropertyNames() {
        return ArrayMap.getKeys((Object[])this._properties);
    }

    @Override
    public String getProperty(String name) {
        return (String)ArrayMap.get((Object[])this._properties, (Object)name.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getParsedProperty(ParsedPropertyKey key) throws PropertyParseException {
        Object value = null;
        int index = key.getKeyIndex();
        if (this._parsedProperties != null) {
            value = this._parsedProperties[index];
            if (value != null) {
                if (value == _NULL_VALUE) {
                    value = null;
                }
                return value;
            }
        } else {
            BaseStyle baseStyle = this;
            synchronized (baseStyle) {
                if (this._parsedProperties == null) {
                    this._parsedProperties = new Object[7];
                }
            }
        }
        try {
            value = this.parseProperty(key);
        }
        catch (PropertyParseException e) {
            this._parsedProperties[index] = _NULL_VALUE;
            throw e;
        }
        this._parsedProperties[index] = value == null ? _NULL_VALUE : value;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        name = name.toLowerCase();
        BaseStyle baseStyle = this;
        synchronized (baseStyle) {
            this._properties = ArrayMap.remove((Object[])this._properties, (Object)name);
            if (value != null) {
                this._properties = ArrayMap.put((Object[])this._properties, (Object)name, (Object)value);
            }
            this._parsedProperties = null;
        }
    }

    @Override
    public abstract String toInlineString();

    protected abstract Object parseProperty(Object var1) throws PropertyParseException;
}

