/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.AgentNameUtil;
import org.apache.myfaces.trinidadinternal.agent.DefaultAgent;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentUtil {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AgentUtil.class);

    public static TrinidadAgent getAgent(int type, int browser, String agentVersion, int platform) {
        final int fType = type;
        final int fBrowser = browser;
        final String fAgentVersion = agentVersion;
        final int fPlatform = platform;
        DefaultAgent agent = new DefaultAgent(){

            public Object getType() {
                return AgentNameUtil.getAgentName(fType);
            }

            public String getAgentName() {
                return AgentNameUtil.getAgentName(fBrowser);
            }

            public String getAgentVersion() {
                return fAgentVersion;
            }

            public String getPlatformName() {
                return AgentNameUtil.getPlatformName(fPlatform);
            }
        };
        return new TrinidadAgentImpl(agent);
    }

    public static TrinidadAgent getUnknownAgent() {
        DefaultAgent adfAgent = new DefaultAgent();
        return new TrinidadAgentImpl(adfAgent);
    }

    public static TrinidadAgent getAgent(FacesContext context) {
        Agent agent = RequestContext.getCurrentInstance().getAgent();
        if (agent instanceof TrinidadAgent) {
            return (TrinidadAgent)agent;
        }
        return new TrinidadAgentImpl(context, agent);
    }

    public static TrinidadAgent mergeCapabilities(TrinidadAgent agent, Map<Object, Object> capabilities) {
        if (!(agent instanceof TrinidadAgentImpl)) {
            throw new IllegalArgumentException(_LOG.getMessage("MERGECAPABILITIES_ONLY_USED_WITH_AGENTS_CREATED_BY_THIS_CLASS"));
        }
        agent = (TrinidadAgent)agent.clone();
        ((TrinidadAgentImpl)agent).__mergeCapabilities(capabilities);
        return agent;
    }
}

