/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.style.StyleConstants;
import org.apache.myfaces.trinidadinternal.style.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.style.xml.parse.ColorValidater;
import org.apache.myfaces.trinidadinternal.style.xml.parse.FontSizeValidater;
import org.apache.myfaces.trinidadinternal.style.xml.parse.FontStyleValidater;
import org.apache.myfaces.trinidadinternal.style.xml.parse.FontWeightValidater;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyValidater;
import org.apache.myfaces.trinidadinternal.style.xml.parse.TextAntialiasValidater;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class PropertyNodeParser
extends BaseNodeParser
implements XMLConstants,
StyleConstants {
    private String _name;
    private String _value;
    private String _whitespace;
    private static final Object[] _VALIDATERS = new Object[]{"color", ColorValidater.getInstance(), "background-color", ColorValidater.getInstance(), "font-size", new FontSizeValidater(), "font-weight", new FontWeightValidater(), "font-style", new FontStyleValidater(), "text-antialias", new TextAntialiasValidater()};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PropertyNodeParser.class);

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._name = this.getRequiredAttribute(context, attrs, "name");
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._name == null) {
            return null;
        }
        if (localName.equals("property")) {
            String error = PropertyNodeParser._validateValue(this._name, this._value);
            if (error != null) {
                _LOG.warning(error);
                return null;
            }
            return new PropertyNode(this._name, this._value);
        }
        return null;
    }

    public void addText(ParseContext context, char[] text, int start, int length) {
        String moreText = new String(text, start, length);
        if (this._whitespace != null) {
            moreText = this._whitespace + moreText;
            this._whitespace = null;
        }
        this._value = this._value == null ? moreText : this._value + moreText;
    }

    public void addWhitespace(ParseContext context, char[] text, int start, int length) throws SAXParseException {
        String whitespace = new String(text, start, length);
        this._whitespace = this._whitespace == null ? whitespace : this._whitespace + whitespace;
    }

    private static String _validateValue(String name, String value) {
        assert (name != null);
        PropertyValidater validater = (PropertyValidater)ArrayMap.get((Object[])_VALIDATERS, (Object)name.toLowerCase());
        if (validater != null) {
            return validater.validateValue(name, value);
        }
        return null;
    }
}

