/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.icon;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.style.Style;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;

public abstract class BaseImageIcon
extends Icon {
    private String _uri;
    private String _rtlURI;
    private Integer _width;
    private Integer _height;
    private String _styleClass;
    private Style _inlineStyle;

    public BaseImageIcon(String uri, String rtlURI, Integer width, Integer height, String styleClass, Style inlineStyle) {
        this._width = width;
        this._height = height;
        this._uri = uri;
        this._rtlURI = rtlURI;
        this._styleClass = styleClass;
        this._inlineStyle = inlineStyle;
    }

    public Object getImageURI(FacesContext context, RenderingContext arc) {
        String baseURI = this._getBaseURI(context, arc);
        String uri = this.getRelativeURI(context, arc);
        if (baseURI == null) {
            return uri;
        }
        return baseURI + uri;
    }

    public Integer getImageWidth(RenderingContext arc) {
        return this._width;
    }

    public Integer getImageHeight(RenderingContext arc) {
        return this._height;
    }

    public void renderIcon(FacesContext context, RenderingContext arc, Map<String, ? extends Object> attrs) throws IOException {
        Object height;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", null);
        Object id = this._getId(attrs);
        if (id != null) {
            writer.writeAttribute("id", id, null);
        }
        String baseURI = this._getBaseURI(context, arc);
        String uri = this.getRelativeURI(context, arc);
        if (baseURI == null) {
            writer.writeURIAttribute("src", (Object)context.getExternalContext().encodeResourceURL(uri), null);
        } else {
            writer.writeURIAttribute("src", (Object)context.getExternalContext().encodeResourceURL(baseURI + uri), null);
        }
        Object width = this._getWidth(arc, attrs);
        if (width != null) {
            writer.writeAttribute("width", width, null);
        }
        if ((height = this._getHeight(arc, attrs)) != null) {
            writer.writeAttribute("height", height, null);
        }
        writer.writeAttribute("border", (Object)"0", null);
        String styleClass = null;
        if (this._styleClass != null) {
            styleClass = this._styleClass;
        } else if (attrs != null) {
            styleClass = (String)attrs.get("styleClass");
        }
        if (styleClass != null) {
            String convertedStyleClass = StyleUtils.convertToValidSelector(arc.getStyleClass(styleClass));
            writer.writeAttribute("class", (Object)convertedStyleClass, null);
        }
        String inlineStyle = null;
        if (this._inlineStyle != null) {
            inlineStyle = this._inlineStyle.toInlineString();
        } else if (attrs != null) {
            inlineStyle = (String)attrs.get("inlineStyle");
        }
        if (inlineStyle != null && !"".equals(inlineStyle)) {
            writer.writeAttribute("style", (Object)inlineStyle, null);
        }
        Object altText = this._getAltText(attrs);
        OutputUtils.renderAltAndTooltipForImage(context, arc, altText);
        this._writeVerticalAlignment(writer, attrs);
        writer.endElement("img");
    }

    protected abstract String getBaseURI(FacesContext var1, RenderingContext var2);

    protected String getRelativeURI(FacesContext context, RenderingContext arc) {
        if (this._rtlURI != null && arc.isRightToLeft()) {
            return this._rtlURI;
        }
        return this._uri;
    }

    private String _getBaseURI(FacesContext context, RenderingContext arc) {
        String baseURI = this.getBaseURI(context, arc);
        assert (baseURI == null || baseURI.charAt(baseURI.length() - 1) == '/');
        return baseURI;
    }

    private Object _getAltText(Map<String, ? extends Object> attrs) {
        if (attrs == null) {
            return null;
        }
        return attrs.get("shortDesc");
    }

    private Object _getId(Map<String, ? extends Object> attrs) {
        if (attrs == null) {
            return null;
        }
        return attrs.get("id");
    }

    private Object _getWidth(RenderingContext arc, Map<String, ? extends Object> attrs) {
        Object width = null;
        if (attrs != null) {
            width = attrs.get("width");
        }
        if (width == null) {
            width = this.getImageWidth(arc);
        }
        return width;
    }

    private Object _getHeight(RenderingContext arc, Map<String, ? extends Object> attrs) {
        Object height = null;
        if (attrs != null) {
            height = attrs.get("height");
        }
        if (height == null) {
            height = this.getImageHeight(arc);
        }
        return height;
    }

    private void _writeVerticalAlignment(ResponseWriter writer, Map<String, ? extends Object> attrs) throws IOException {
        Object align;
        if (attrs != null && (align = attrs.get("align")) != null) {
            writer.writeAttribute("align", align, null);
        }
    }
}

