/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXSingleStep;
import org.apache.myfaces.trinidad.component.core.nav.CoreSingleStepButtonBar;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.XhtmlConstants;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CommandButtonRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SelectRangeChoiceBarRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.util.nls.StringUtils;

public class SingleStepButtonBarRenderer
extends XhtmlRenderer {
    private PropertyKey _selectedStepKey;
    private PropertyKey _maxStepKey;
    private PropertyKey _textKey;
    private Button _nextButton;
    private Button _backButton;
    private static final String _SINGLE_BACK_TEXT_KEY = "af_singleStepButtonBar.BACK";
    private static final String _SINGLE_NEXT_TEXT_KEY = "af_singleStepButtonBar.NEXT";
    private static final String _SINGLE_CONTINUE_TEXT_KEY = "af_singleStepButtonBar.CONTINUE";
    private static final String _SINGLE_RANGE_FORMAT_TOTAL_STRING = "af_singleStepButtonBar.FORMAT_TOTAL";
    private static final String _SINGLE_RANGE_FORMAT_NO_TOTAL_STRING = "af_singleStepButtonBar.FORMAT_NO_TOTAL";
    private static final String _STEP_TEXT_KEY = "af_singleStepButtonBar.STEP";
    private static final String _NEXT_ID_SUFFIX = "::next";
    private static final String _BACK_ID_SUFFIX = "::back";
    private static final long _MAX_VALUE_UNKNOWN = ((Number)UIXSingleStep.MAX_STEP_KEY.getDefault()).longValue();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SingleStepButtonBarRenderer.class);

    public SingleStepButtonBarRenderer() {
        super(CoreSingleStepButtonBar.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._selectedStepKey = type.findKey("selectedStep");
        this._maxStepKey = type.findKey("maxStep");
        this._textKey = type.findKey("text");
        this._backButton = new Button(type, false);
        this._nextButton = new Button(type, true);
    }

    public void decode(FacesContext context, UIComponent component) {
        Map parameters = context.getExternalContext().getRequestParameterMap();
        String source = (String)parameters.get("source");
        String id = this.getClientId(context, component);
        if (source != null && source.startsWith(id)) {
            String suffix = source.substring(id.length());
            UIXSingleStep singleStep = (UIXSingleStep)component;
            if (suffix.equals(_NEXT_ID_SUFFIX)) {
                singleStep.setActionType(UIXSingleStep.NEXT_ACTION_TYPE);
            } else if (suffix.equals(_BACK_ID_SUFFIX)) {
                singleStep.setActionType(UIXSingleStep.PREVIOUS_ACTION_TYPE);
            } else {
                return;
            }
            new ActionEvent(component).queue();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getDefaultStyleClass(FacesBean bean) {
        return "af|singleStepButtonBar";
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        boolean showNextButton;
        if (this.canSkipRendering(context, arc, component)) {
            return;
        }
        long currentValue = this.getSelectedStep(bean);
        long totalItems = this.getMaxStep(bean);
        boolean showBackButton = currentValue > 1L;
        boolean bl = showNextButton = totalItems == _MAX_VALUE_UNKNOWN || currentValue < totalItems;
        if (!showBackButton && !showNextButton || currentValue > totalItems && totalItems != _MAX_VALUE_UNKNOWN || currentValue < _MAX_VALUE_UNKNOWN) {
            return;
        }
        String formName = arc.getFormData().getName();
        if (formName == null) {
            _LOG.warning("SINGLE_STEP_MUST_INSIDE_FORM");
            return;
        }
        if (!SingleStepButtonBarRenderer.supportsNavigation(arc)) {
            return;
        }
        boolean renderAsTable = SelectRangeChoiceBarRenderer.__renderAsTable(component);
        ResponseWriter writer = context.getResponseWriter();
        if (renderAsTable) {
            writer.startElement("table", component);
            this.renderAllAttributes(context, arc, bean);
            this.renderId(context, component);
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
            writer.startElement("tr", null);
        }
        writer.startElement("td", null);
        if (showBackButton) {
            this.delegateRenderer(context, arc, component, bean, this._backButton);
            writer.endElement("td");
            this._renderSpacerCell(context, arc);
            writer.startElement("td", null);
        }
        writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        if (totalItems > 2L) {
            String rangeString = this._getRangeString(arc, bean, currentValue, totalItems);
            writer.startElement("span", null);
            SingleStepButtonBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|singleStepButtonBar::label");
            writer.writeText((Object)rangeString, "text");
            writer.endElement("span");
        }
        if (showNextButton) {
            writer.endElement("td");
            this._renderSpacerCell(context, arc);
            writer.startElement("td", null);
            this.delegateRenderer(context, arc, component, bean, this._nextButton);
        }
        writer.endElement("td");
        if (renderAsTable) {
            writer.endElement("tr");
            writer.endElement("table");
        }
    }

    protected long getSelectedStep(FacesBean bean) {
        Object o = bean.getProperty(this._selectedStepKey);
        if (o == null) {
            o = this._selectedStepKey.getDefault();
        }
        return SingleStepButtonBarRenderer.toLong((Object)o);
    }

    protected long getMaxStep(FacesBean bean) {
        Object o = bean.getProperty(this._maxStepKey);
        if (o == null) {
            o = this._maxStepKey.getDefault();
        }
        return SingleStepButtonBarRenderer.toLong((Object)o);
    }

    protected String getText(FacesBean bean) {
        return SingleStepButtonBarRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    protected void renderItemSpacer(FacesContext context, RenderingContext arc) throws IOException {
        if (SingleStepButtonBarRenderer.isPDA((RenderingContext)arc)) {
            context.getResponseWriter().writeText((Object)XhtmlConstants.NBSP_STRING, null);
        } else {
            this.renderSpacer(context, arc, "5", "1");
        }
    }

    private void _renderSpacerCell(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        this.renderItemSpacer(context, arc);
        writer.endElement("td");
    }

    private String _getRangeString(RenderingContext arc, FacesBean bean, long start, long total) {
        String[] parameters;
        String pattern;
        String text = this.getText(bean);
        if (text == null) {
            text = arc.getTranslatedString(_STEP_TEXT_KEY);
        }
        if (total == _MAX_VALUE_UNKNOWN) {
            pattern = arc.getTranslatedString(_SINGLE_RANGE_FORMAT_NO_TOTAL_STRING);
            parameters = new String[]{text, IntegerUtils.getString((long)start)};
        } else {
            pattern = arc.getTranslatedString(_SINGLE_RANGE_FORMAT_TOTAL_STRING);
            parameters = new String[]{text, IntegerUtils.getString((long)start), IntegerUtils.getString((long)total)};
        }
        return XhtmlUtils.getFormattedString(pattern, parameters);
    }

    private static class Button
    extends CommandButtonRenderer {
        private boolean _next;

        public Button(FacesBean.Type type, boolean next) {
            super(type);
            this._next = next;
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            String clientId = super.getClientId(context, component);
            return clientId + (this._next ? SingleStepButtonBarRenderer._NEXT_ID_SUFFIX : SingleStepButtonBarRenderer._BACK_ID_SUFFIX);
        }

        protected String getShortDesc(FacesBean bean) {
            return null;
        }

        protected String getStyleClass(FacesBean bean) {
            return null;
        }

        protected String getInlineStyle(FacesBean bean) {
            return null;
        }

        protected String getText(FacesBean bean) {
            String textAndAccessKey = this._getTextAndAccessKey();
            return StringUtils.stripMnemonic(textAndAccessKey);
        }

        protected char getAccessKey(FacesBean bean) {
            String textAndAccessKey = this._getTextAndAccessKey();
            int index = StringUtils.getMnemonicIndex(textAndAccessKey);
            if (index < 0) {
                return '\u0000';
            }
            return textAndAccessKey.charAt(index + 1);
        }

        protected void renderEventHandlers(FacesContext context, FacesBean bean) throws IOException {
            context.getResponseWriter().writeAttribute("onclick", (Object)this.getOnclick(bean), null);
        }

        protected String getComponentOnclick(FacesBean bean) {
            return null;
        }

        protected boolean getImmediate(FacesBean bean) {
            return !this._next;
        }

        protected boolean getPartialSubmit(FacesBean bean) {
            return false;
        }

        protected boolean getDisabled(FacesBean bean) {
            return false;
        }

        protected String getIcon(FacesBean bean) {
            return null;
        }

        private String _getTextAndAccessKey() {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            return rc.getTranslatedString(this._next ? SingleStepButtonBarRenderer._SINGLE_NEXT_TEXT_KEY : SingleStepButtonBarRenderer._SINGLE_BACK_TEXT_KEY);
        }
    }
}

