/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXForm;
import org.apache.myfaces.trinidad.component.core.CoreForm;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestType;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CoreFormData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ProcessUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.uix.SubformRenderer;

public class FormRenderer
extends XhtmlRenderer {
    public static final Object USES_UPLOAD_KEY = new Object();
    private PropertyKey _usesUploadKey;
    private PropertyKey _autoCompleteKey;
    private PropertyKey _defaultCommandKey;
    private PropertyKey _onsubmitKey;
    private PropertyKey _targetFrameKey;
    private static final String _GLOBAL_FORMAT_KEY = "af_messages.GLOBAL_MESSAGE_FORMAT";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FormRenderer.class);

    public FormRenderer() {
        super(CoreForm.TYPE);
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        Object formName = paramMap.get("org.apache.myfaces.trinidad.faces.FORM");
        boolean submitted = false;
        if (formName != null) {
            if (clientId == null) {
                clientId = this.getClientId(facesContext, component);
            }
            submitted = formName.equals(clientId);
        }
        if (component instanceof UIForm) {
            ((UIForm)component).setSubmitted(submitted);
        } else {
            ((UIXForm)component).setSubmitted(submitted);
        }
    }

    public boolean getRendersChildren() {
        return false;
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._usesUploadKey = type.findKey("usesUpload");
        this._autoCompleteKey = type.findKey("autoComplete");
        this._defaultCommandKey = type.findKey("defaultCommand");
        this._onsubmitKey = type.findKey("onsubmit");
        this._targetFrameKey = type.findKey("targetFrame");
    }

    public void setupEncodingContext(FacesContext context, RenderingContext rc, UIComponent component) {
        String formName = this.getClientId(context, component);
        CoreFormData fData = new CoreFormData(formName);
        rc.setFormData((FormData)fData);
        if (formName != null) {
            rc.getProperties().put("formName", formName);
        }
        String postscriptId = FormRenderer._getPostscriptId(rc, formName);
        PartialPageContext pprContext = rc.getPartialPageContext();
        if (pprContext != null && !pprContext.isInsidePartialTarget()) {
            pprContext.addPartialTarget(postscriptId);
            if (PartialPageUtils.isOptimizedPPREnabled(context, false)) {
                try {
                    this._renderPostscriptElement(context, rc, context.getResponseWriter(), postscriptId);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        String autocomplete;
        ResponseWriter rw = context.getResponseWriter();
        ExternalContext ec = context.getExternalContext();
        String formName = rc.getFormData().getName();
        if (FormRenderer.supportsScripting(rc)) {
            XhtmlUtils.addLib(context, rc, "submitForm()");
            XhtmlUtils.addLib(context, rc, "_submitOnEnter()");
            String onsubmit = this.getOnsubmit(comp, bean);
            if (onsubmit != null) {
                rw.startElement("script", null);
                FormRenderer.renderScriptDeferAttribute(context, rc);
                FormRenderer.renderScriptTypeAttribute(context, rc);
                rw.write("var _");
                rw.write(XhtmlUtils.getJSIdentifier(formName));
                rw.write("_Submit=\"");
                rw.writeText((Object)onsubmit, null);
                rw.write(34);
                rw.endElement("script");
            }
        }
        rw.startElement("form", comp);
        this.renderId(context, comp);
        this.renderAllAttributes(context, rc, comp, bean);
        if (this.getUsesUpload(comp, bean)) {
            rw.writeAttribute("enctype", (Object)"multipart/form-data", "usesUpload");
        }
        rw.writeAttribute("method", (Object)"POST", null);
        if (FormRenderer.supportsScripting(rc)) {
            rw.writeAttribute("onkeypress", (Object)this.getFullOnkeypress(context, comp, bean, formName), "onkeypress");
        }
        if (FormRenderer.supportsAutoCompleteFormElements(rc) && (autocomplete = this.getAutoComplete(comp, bean)).equalsIgnoreCase("off")) {
            rw.writeAttribute("autocomplete", (Object)"off", "autoComplete");
        }
        String viewId = context.getViewRoot().getViewId();
        String action = context.getApplication().getViewHandler().getActionURL(context, viewId);
        this.renderEncodedActionURI(context, "action", action);
        RequestType type = ExternalContextUtils.getRequestType((ExternalContext)ec);
        if (type.isPortlet()) {
            this.renderEncodedResourceURI(context, "_trinPPRAction", action);
        }
        if (FormRenderer.supportsTarget(rc)) {
            rw.writeAttribute("target", (Object)this.getTargetFrame(comp, bean), "targetFrame");
        }
    }

    protected void encodeEnd(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        String noJavaScriptSupport = "false";
        ResponseWriter writer = context.getResponseWriter();
        String formName = rc.getFormData().getName();
        PartialPageContext pprContext = rc.getPartialPageContext();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)"org.apache.myfaces.trinidad.faces.FORM", null);
        writer.writeAttribute("value", (Object)formName, null);
        writer.endElement("input");
        if (!FormRenderer.supportsScripting(rc)) {
            noJavaScriptSupport = "true";
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)"_noJavaScript", null);
        writer.writeAttribute("value", (Object)noJavaScriptSupport, null);
        writer.endElement("input");
        String postscriptId = FormRenderer._getPostscriptId(rc, formName);
        this._renderPostscriptElement(context, rc, writer, postscriptId);
        if (FormRenderer.isPDA((RenderingContext)rc) && pprContext == null) {
            FormData formData;
            Object domLevel = rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_DOM);
            if ((domLevel == null || domLevel == TrinidadAgent.DOM_CAP_NONE || domLevel == TrinidadAgent.DOM_CAP_FORM) && (formData = rc.getFormData()) != null) {
                boolean isPIE = "ppc".equalsIgnoreCase(rc.getAgent().getPlatformName());
                if (isPIE) {
                    formData.addNeededValue("source");
                    formData.addNeededValue("event");
                    formData.addNeededValue("partialTargets");
                    formData.addNeededValue("partial");
                    Map headerMap = context.getExternalContext().getRequestHeaderMap();
                    FormRenderer._renderHiddenField(writer, "uapixels", headerMap.get("UA-pixels"));
                } else {
                    formData.addNeededValue("source");
                    formData.addNeededValue("event");
                }
            }
            FormRenderer._renderNeededValues(context, rc);
        }
        if ("ppc".equalsIgnoreCase(rc.getAgent().getPlatformName()) && Boolean.TRUE.equals(rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_PARTIAL_RENDERING))) {
            this._renderOtherComponentScripts(context, rc, writer);
        }
        if (pprContext == null) {
            FormRenderer._renderSubmitFormCheck(context, rc);
        }
        this.encodeComponentResources(context, "form");
        writer.endElement("form");
    }

    private void _renderPostscriptElement(FacesContext context, RenderingContext rc, ResponseWriter rw, final String postscriptId) throws IOException {
        if (postscriptId != null) {
            rw.startElement("span", (UIComponent)new CoreForm(){

                public String getClientId(FacesContext context) {
                    return postscriptId;
                }
            });
            rw.writeAttribute("id", (Object)postscriptId, null);
        }
        if (FormRenderer.isPDA((RenderingContext)rc) && RequestContext.getCurrentInstance().isPartialRequest(context)) {
            String state = context.getApplication().getStateManager().getViewState(context);
            rw.startElement("input", null);
            rw.writeAttribute("type", (Object)"hidden", null);
            rw.writeAttribute("name", (Object)"javax.faces.ViewState", null);
            rw.writeAttribute("value", (Object)state, null);
            rw.endElement("input");
        } else {
            context.getApplication().getViewHandler().writeState(context);
        }
        RequestContext.getCurrentInstance().getWindowManager().writeState(context);
        if (!FormRenderer.isPDA((RenderingContext)rc)) {
            FormRenderer._renderNeededValues(context, rc);
        }
        FormRenderer._renderValidationScripts(context, rc);
        FormRenderer._renderResetCalls(context, rc);
        if (postscriptId != null) {
            rw.endElement("span");
        }
    }

    public void tearDownEncodingContext(FacesContext context, RenderingContext rc, UIComponent component) {
        rc.getProperties().remove("formName");
        rc.clearFormData();
    }

    @Override
    protected String getInlineStyle(UIComponent component, FacesBean bean) {
        String inlineStyle = super.getInlineStyle(component, bean);
        if (inlineStyle == null) {
            return "margin:0px";
        }
        return inlineStyle + ";margin:0px";
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        String clientId = this.getClientId(context, component);
        context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
        context.getResponseWriter().writeAttribute("name", (Object)clientId, "id");
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    private static void _renderResetCalls(FacesContext context, RenderingContext rc) throws IOException {
        int resetCallCount;
        if (!FormRenderer.supportsScripting(rc)) {
            return;
        }
        CoreFormData fData = (CoreFormData)rc.getFormData();
        Map<String, String> resetCallMap = fData.getResetCalls(false);
        int n = resetCallCount = resetCallMap != null ? resetCallMap.size() : 0;
        if (resetCallCount != 0) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            FormRenderer.renderScriptDeferAttribute(context, rc);
            FormRenderer.renderScriptTypeAttribute(context, rc);
            writer.writeText((Object)"TrPage.getInstance()._addResetCalls('", null);
            writer.writeText((Object)fData.getName(), null);
            writer.writeText((Object)"',{", null);
            boolean firstCall = true;
            for (Map.Entry<String, String> entry : resetCallMap.entrySet()) {
                String clientId = entry.getKey();
                String currCall = entry.getValue();
                if (firstCall) {
                    firstCall = false;
                } else {
                    writer.writeText((Object)",", null);
                }
                writer.writeText((Object)"'", null);
                writer.writeText((Object)clientId, null);
                writer.writeText((Object)"':'", null);
                writer.writeText((Object)XhtmlUtils.escapeJS(currCall), null);
                writer.writeText((Object)"'", null);
            }
            writer.writeText((Object)"});", null);
            writer.endElement("script");
        }
    }

    private static void _renderValidationScripts(FacesContext context, RenderingContext rc) throws IOException {
        RequestContext requestContext;
        boolean isClientValidationDisabled;
        if (!FormRenderer.supportsScripting(rc)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        CoreFormData fData = (CoreFormData)rc.getFormData();
        String jsID = XhtmlUtils.getJSIdentifier(fData.getName());
        writer.startElement("script", null);
        FormRenderer.renderScriptDeferAttribute(context, rc);
        FormRenderer.renderScriptTypeAttribute(context, rc);
        List<String> clientDependencies = fData.getClientDependencies(false);
        if (clientDependencies != null) {
            for (int d = 0; d < clientDependencies.size(); ++d) {
                writer.writeText((Object)clientDependencies.get(d), null);
            }
        }
        boolean bl = isClientValidationDisabled = (requestContext = RequestContext.getCurrentInstance()).getClientValidation() == RequestContext.ClientValidation.DISABLED;
        if (rc.getPartialPageContext() == null) {
            boolean isInline = requestContext.getClientValidation() == RequestContext.ClientValidation.INLINE;
            writer.writeText((Object)"function _", null);
            writer.writeText((Object)jsID, null);
            writer.writeText((Object)"Validator(f,s){return ", null);
            if (isClientValidationDisabled) {
                writer.writeText((Object)"true", null);
            } else if (isInline) {
                writer.writeText((Object)"_validateInline(f,s)", null);
            } else {
                writer.writeText((Object)"_validateAlert(f,s,null,\"", null);
                writer.writeText((Object)XhtmlUtils.escapeJS(rc.getTranslatedString(_GLOBAL_FORMAT_KEY)), null);
                writer.writeText((Object)"\",\"", null);
                writer.writeText((Object)XhtmlUtils.escapeJS(rc.getTranslatedString("af_form.SUBMIT_ERRORS")), null);
                writer.writeText((Object)"\")", null);
            }
            writer.writeText((Object)";}", null);
        }
        if (isClientValidationDisabled) {
            writer.endElement("script");
            return;
        }
        Map<String, List<CoreFormData.ConvertValidate>> validatorInfoMap = fData.getFormValidatorsInfo(false);
        if (validatorInfoMap != null) {
            Map<String, String> labelMap;
            int inputCount;
            writer.writeText((Object)"_addValidators(\"", null);
            writer.writeText((Object)fData.getName(), null);
            writer.writeText((Object)"\",[", null);
            boolean firstFormInfo = true;
            for (Map.Entry<String, List<CoreFormData.ConvertValidate>> validatorEntry : validatorInfoMap.entrySet()) {
                String clientId = validatorEntry.getKey();
                List<CoreFormData.ConvertValidate> validatorInfoList = validatorEntry.getValue();
                for (CoreFormData.ConvertValidate convertValidate : validatorInfoList) {
                    if (firstFormInfo) {
                        firstFormInfo = false;
                    } else {
                        writer.writeText((Object)"],", null);
                    }
                    writer.writeText((Object)"\"", null);
                    writer.writeText((Object)clientId, null);
                    writer.writeText((Object)"\",", null);
                    writer.writeText((Object)(convertValidate.required ? "1" : "0"), null);
                    writer.writeText((Object)",", null);
                    if (convertValidate.requiredFormatIndex != null) {
                        writer.writeText((Object)convertValidate.requiredFormatIndex, null);
                    }
                    writer.writeText((Object)",", null);
                    Object converterInfo = convertValidate.converter;
                    if (converterInfo != null) {
                        writer.writeText(converterInfo, null);
                    } else {
                        writer.writeText((Object)"(void 0)", null);
                    }
                    writer.writeText((Object)",[", null);
                    ArrayList<Integer> validatorInfo = convertValidate.validators;
                    if (validatorInfo == null) continue;
                    boolean firstValidator = true;
                    for (int i = 0; i < validatorInfo.size(); ++i) {
                        if (firstValidator) {
                            firstValidator = false;
                        } else {
                            writer.writeText((Object)",", null);
                        }
                        writer.writeText((Object)validatorInfo.get(i).toString(), null);
                    }
                }
            }
            writer.writeText((Object)"]],[", null);
            Iterator<String> validationIterator = fData.getValidationIterator();
            if (validationIterator != null) {
                boolean firstValidation = true;
                while (validationIterator.hasNext()) {
                    String currValidation = validationIterator.next();
                    if (firstValidation) {
                        firstValidation = false;
                    } else {
                        writer.writeText((Object)",", null);
                    }
                    writer.writeText((Object)"'", null);
                    writer.writeText((Object)XhtmlUtils.escapeJS(currValidation), null);
                    writer.writeText((Object)"'", null);
                }
            }
            writer.writeText((Object)"],{", null);
            List<String> inputList = fData.getValidatedInputList(false);
            int n = inputCount = inputList != null ? inputList.size() : 0;
            if (inputCount > 0 && (labelMap = fData.getLabelMap(false)) != null) {
                boolean firstLabel = true;
                for (int i = 0; i < inputCount; ++i) {
                    String currID = inputList.get(i);
                    String currLabel = labelMap.remove(currID);
                    if (currLabel == null) continue;
                    if (firstLabel) {
                        firstLabel = false;
                    } else {
                        writer.writeText((Object)",", null);
                    }
                    writer.writeText((Object)"'", null);
                    writer.writeText((Object)currID, null);
                    writer.writeText((Object)"':'", null);
                    writer.writeText((Object)XhtmlUtils.escapeJS(currLabel), null);
                    writer.writeText((Object)"'", null);
                }
            }
            writer.writeText((Object)"},[", null);
            Iterator<String> errorFormatIterator = fData.getErrorFormatIterator();
            if (errorFormatIterator != null) {
                boolean firstFormat = true;
                while (errorFormatIterator.hasNext()) {
                    String currErrorFormat = errorFormatIterator.next();
                    if (firstFormat) {
                        firstFormat = false;
                    } else {
                        writer.writeText((Object)",", null);
                    }
                    writer.writeText((Object)"'", null);
                    writer.writeText((Object)XhtmlUtils.escapeJS(currErrorFormat), null);
                    writer.writeText((Object)"'", null);
                }
            }
            writer.writeText((Object)"]);", null);
        }
        FormRenderer._renderSubformLists(context, jsID);
        writer.endElement("script");
    }

    private static void _renderSubformLists(FacesContext context, String jsID) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<String> subforms = SubformRenderer.getSubformList(context, false, false);
        writer.writeText((Object)"var ", null);
        writer.writeText((Object)jsID, null);
        writer.writeText((Object)"_SF={", null);
        if (subforms != null && !subforms.isEmpty()) {
            List<String> defaultSubforms = SubformRenderer.getSubformList(context, true, false);
            Iterator<String> ids = subforms.iterator();
            while (ids.hasNext()) {
                String id = ids.next();
                writer.writeText((Object)"\"", null);
                writer.writeText((Object)id, null);
                writer.writeText((Object)"\":", null);
                if (defaultSubforms != null && defaultSubforms.contains(id)) {
                    writer.writeText((Object)"2", null);
                } else {
                    writer.writeText((Object)"1", null);
                }
                if (!ids.hasNext()) continue;
                writer.writeText((Object)",", null);
            }
        }
        writer.writeText((Object)"};", null);
    }

    private static void _renderSubmitFormCheck(FacesContext context, RenderingContext rc) throws IOException {
        if (!FormRenderer.supportsScripting(rc)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        FormRenderer.renderScriptDeferAttribute(context, rc);
        FormRenderer.renderScriptTypeAttribute(context, rc);
        writer.writeText((Object)"_submitFormCheck();", null);
        writer.endElement("script");
    }

    public static void addResetCall(String clientId, String call) {
        CoreFormData fData = (CoreFormData)RenderingContext.getCurrentInstance().getFormData();
        fData.addResetCall(clientId, call);
    }

    public static void addOnSubmitConverterValidators(UIComponent component, Converter converter, Iterator<Validator> validators, String clientId, boolean immediate, boolean required, String requiredMessageKey) throws IOException {
        CoreFormData fData = (CoreFormData)RenderingContext.getCurrentInstance().getFormData();
        fData.addOnSubmitConverterValidators(component, converter, validators, clientId, immediate, required, requiredMessageKey);
    }

    public static void addLabelMapping(String targetID, String label) {
        FormData fData = RenderingContext.getCurrentInstance().getFormData();
        fData.addLabel(targetID, label);
    }

    public static int getInputTextCount() {
        CoreFormData fData = (CoreFormData)RenderingContext.getCurrentInstance().getFormData();
        return fData.getInputTextCount();
    }

    public static void incrementInputTextCount() {
        CoreFormData fData = (CoreFormData)RenderingContext.getCurrentInstance().getFormData();
        fData.incrementInputTextCount();
    }

    private static String _getPostscriptId(RenderingContext rc, String formName) {
        if (PartialPageUtils.supportsPartialRendering(rc)) {
            return "tr_" + formName + "_Postscript";
        }
        return null;
    }

    protected String getDefaultCommand(UIComponent component, FacesBean bean) {
        return FormRenderer.toString((Object)bean.getProperty(this._defaultCommandKey));
    }

    protected String getOnsubmit(UIComponent component, FacesBean bean) {
        if (this._onsubmitKey == null) {
            return null;
        }
        return XhtmlUtils.getClientEventHandler(FacesContext.getCurrentInstance(), component, "submit", null, FormRenderer.toString((Object)bean.getProperty(this._onsubmitKey)), null);
    }

    protected String getTargetFrame(UIComponent component, FacesBean bean) {
        return FormRenderer.toString((Object)bean.getProperty(this._targetFrameKey));
    }

    protected boolean getUsesUpload(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._usesUploadKey);
        if (o == null) {
            o = this._usesUploadKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getFullOnkeypress(FacesContext context, UIComponent component, FacesBean bean, String clientId) {
        String onKeypress = super.getOnkeypress(component, bean);
        String defaultCommand = this.getDefaultCommand(component, bean);
        String submitFunc = null;
        UIComponent defaultCommandComponent = null;
        if (defaultCommand != null && !"".equals(defaultCommand)) {
            defaultCommandComponent = component.findComponent(defaultCommand);
        }
        if (defaultCommandComponent != null && defaultCommandComponent instanceof ActionSource) {
            Boolean ppr;
            String defaultCommandId = defaultCommandComponent.getClientId(context);
            int immediate = 1;
            if (((ActionSource)defaultCommandComponent).isImmediate()) {
                immediate = 0;
            }
            submitFunc = (ppr = (Boolean)defaultCommandComponent.getAttributes().get("partialSubmit")) != null && ppr.booleanValue() ? "return _submitOnEnter(event,'" + clientId + "'," + "'" + defaultCommandId + "'," + immediate + "," + true + ");" : "return _submitOnEnter(event,'" + clientId + "'," + "'" + defaultCommandId + "'," + immediate + "," + false + ");";
        } else {
            submitFunc = "return _submitOnEnter(event,'" + clientId + "');";
        }
        onKeypress = XhtmlUtils.getChainedJS(onKeypress, submitFunc, true);
        return onKeypress;
    }

    @Override
    protected String getOnkeypress(UIComponent component, FacesBean bean) {
        return null;
    }

    protected String getAutoComplete(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._autoCompleteKey);
        if (o == null) {
            o = this._autoCompleteKey.getDefault();
        }
        return o.toString();
    }

    private static void _renderHiddenField(ResponseWriter writer, Object name, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", name, null);
        writer.writeAttribute("value", value, null);
        writer.endElement("input");
    }

    private static void _renderNeededValues(FacesContext context, RenderingContext rc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CoreFormData fData = (CoreFormData)rc.getFormData();
        if (fData.useCompoundNames()) {
            FormRenderer._renderHiddenField(writer, "_compNm", "a");
        } else {
            int neededCount;
            int realNeededIndex = 0;
            List<String> neededValues = fData.getNeededValues(false);
            int n = neededCount = neededValues != null ? neededValues.size() : 0;
            if (neededCount > 0) {
                int i;
                String neededValue = FormRenderer.supportsScripting(rc) ? null : "a";
                Set<String> renderedValues = fData.getRenderedValues(true);
                for (i = 0; i < neededCount; ++i) {
                    String currName = neededValues.get(i);
                    if (renderedValues.contains(currName)) continue;
                    neededValues.set(realNeededIndex, currName);
                    ++realNeededIndex;
                    FormRenderer._renderHiddenField(writer, currName, neededValue);
                    fData.addRenderedValue(currName);
                }
                if (realNeededIndex > 0 && FormRenderer.supportsScripting(rc)) {
                    writer.startElement("script", null);
                    FormRenderer.renderScriptDeferAttribute(context, rc);
                    FormRenderer.renderScriptTypeAttribute(context, rc);
                    writer.writeText((Object)"TrPage.getInstance()._addResetFields('", null);
                    writer.writeText((Object)fData.getName(), null);
                    writer.writeText((Object)"',[\"", null);
                    writer.writeText((Object)neededValues.get(0), null);
                    for (i = 1; i < realNeededIndex; ++i) {
                        writer.writeText((Object)"\",\"", null);
                        writer.writeText((Object)neededValues.get(i), null);
                    }
                    writer.writeText((Object)"\"]);", null);
                    writer.endElement("script");
                }
            }
        }
    }

    private void _renderOtherComponentScripts(FacesContext context, RenderingContext arc, ResponseWriter writer) throws IOException {
        writer.startElement("script", null);
        FormRenderer.renderScriptDeferAttribute(context, arc);
        FormRenderer.renderScriptTypeAttribute(context, arc);
        writer.writeText((Object)"function _submitHideShow(a,v,b,c,l,d) {var o = {event:b,source:c};if (d!=(void 0)) o.value=d;_setRequestedFocusNode(document,l,false,window);_submitPartialChange(a,v,o);return false;}", null);
        writer.endElement("script");
        ProcessUtils.renderNavSubmitScript(context, arc);
        ProcessUtils.renderNavChoiceSubmitScript(context, arc);
    }
}

