/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FacesContextWrapper;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.config.GlobalConfiguratorImpl;

public class FacesContextFactoryImpl
extends FacesContextFactory {
    private final FacesContextFactory _factory;

    public FacesContextFactoryImpl(FacesContextFactory factory) {
        this._factory = factory;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) {
        return new CacheRenderKit(this._factory.getFacesContext(context, request, response, lifecycle));
    }

    public FacesContextFactory getWrapped() {
        return this._factory;
    }

    public static class OverrideDispatch
    extends ExternalContextDecorator {
        private final ExternalContext _decorated;

        public OverrideDispatch(ExternalContext decorated) {
            this._decorated = decorated;
        }

        public void dispatch(String path) throws IOException {
            RequestContext afc = RequestContext.getCurrentInstance();
            if (afc != null) {
                path = afc.getPageResolver().getPhysicalURI(path);
            }
            super.dispatch(path);
        }

        public URL getResource(String path) throws MalformedURLException {
            RequestContext afc = RequestContext.getCurrentInstance();
            if (afc != null) {
                path = afc.getPageResolver().getPhysicalURI(path);
            }
            return super.getResource(path);
        }

        protected ExternalContext getExternalContext() {
            return this._decorated;
        }
    }

    public static class CacheRenderKit
    extends FacesContextWrapper {
        private final FacesContext _base;
        private final ExternalContext _external;
        private Object _cachedRenderKitId;
        private RenderKit _kit;
        private static final String _CONFIG_IN_CONTEXT = FacesContextFactoryImpl.class.getName() + ".CONFIG_IN_CONTEXT";

        public CacheRenderKit(FacesContext base) {
            this._base = base;
            ExternalContext baseExternal = base.getExternalContext();
            GlobalConfiguratorImpl config = GlobalConfiguratorImpl.getInstance();
            if (!GlobalConfiguratorImpl.isRequestStarted(baseExternal)) {
                Map requestMap = baseExternal.getRequestMap();
                requestMap.put(_CONFIG_IN_CONTEXT, Boolean.TRUE);
            }
            this._external = new OverrideDispatch(config.getExternalContext(baseExternal));
            CacheRenderKit.setCurrentInstance((FacesContext)this);
        }

        public ExternalContext getExternalContext() {
            return this._external;
        }

        public RenderKit getRenderKit() {
            if (this._kit == null) {
                this._kit = this._base.getRenderKit();
            } else {
                String renderKitId;
                UIViewRoot root = this.getViewRoot();
                if (root != null && (renderKitId = root.getRenderKitId()) != this._cachedRenderKitId) {
                    this._cachedRenderKitId = renderKitId;
                    this._kit = this._base.getRenderKit();
                }
            }
            return this._kit;
        }

        public FacesContext getWrapped() {
            return this._base;
        }

        public void release() {
            ExternalContext ec = this.getExternalContext();
            if (Boolean.TRUE.equals(ec.getRequestMap().get(_CONFIG_IN_CONTEXT))) {
                GlobalConfiguratorImpl.getInstance().endRequest(ec);
            }
            super.release();
        }
    }
}

