//*****************************************************************************
//
//  am_mcu_apollo3_info0.h
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2021, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision release_sdk_3_0_0-742e5ac27c of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_REG_INFO0_H
#define AM_REG_INFO0_H

#define AM_REG_INFO0_BASEADDR 0x50020000
#define AM_REG_INFO0n(n) 0x50020000

#define AM_REG_INFO0_SIGNATURE0_O 0x00000000
#define AM_REG_INFO0_SIGNATURE0_ADDR 0x50020000
#define AM_REG_INFO0_SIGNATURE1_O 0x00000004
#define AM_REG_INFO0_SIGNATURE1_ADDR 0x50020004
#define AM_REG_INFO0_SIGNATURE2_O 0x00000008
#define AM_REG_INFO0_SIGNATURE2_ADDR 0x50020008
#define AM_REG_INFO0_SIGNATURE3_O 0x0000000c
#define AM_REG_INFO0_SIGNATURE3_ADDR 0x5002000c
#define AM_REG_INFO0_SECURITY_O 0x00000010
#define AM_REG_INFO0_SECURITY_ADDR 0x50020010
#define AM_REG_INFO0_CUSTOMER_TRIM_O 0x00000014
#define AM_REG_INFO0_CUSTOMER_TRIM_ADDR 0x50020014
#define AM_REG_INFO0_CUSTOMER_TRIM2_O 0x00000018
#define AM_REG_INFO0_CUSTOMER_TRIM2_ADDR 0x50020018
#define AM_REG_INFO0_SECURITY_OVR_O 0x00000020
#define AM_REG_INFO0_SECURITY_OVR_ADDR 0x50020020
#define AM_REG_INFO0_SECURITY_WIRED_CFG_O 0x00000024
#define AM_REG_INFO0_SECURITY_WIRED_CFG_ADDR 0x50020024
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_O 0x00000028
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_ADDR 0x50020028
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_O 0x0000002c
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_ADDR 0x5002002c
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_O 0x00000030
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_ADDR 0x50020030
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_O 0x00000034
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_ADDR 0x50020034
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_O 0x00000038
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_ADDR 0x50020038
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_O 0x0000003c
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_ADDR 0x5002003c
#define AM_REG_INFO0_SECURITY_VERSION_O 0x00000040
#define AM_REG_INFO0_SECURITY_VERSION_ADDR 0x50020040
#define AM_REG_INFO0_SECURITY_SRAM_RESV_O 0x00000050
#define AM_REG_INFO0_SECURITY_SRAM_RESV_ADDR 0x50020050
#define AM_REG_INFO0_WRITE_PROTECT_L_O 0x000001f8
#define AM_REG_INFO0_WRITE_PROTECT_L_ADDR 0x500201f8
#define AM_REG_INFO0_WRITE_PROTECT_H_O 0x000001fc
#define AM_REG_INFO0_WRITE_PROTECT_H_ADDR 0x500201fc
#define AM_REG_INFO0_COPY_PROTECT_L_O 0x00000200
#define AM_REG_INFO0_COPY_PROTECT_L_ADDR 0x50020200
#define AM_REG_INFO0_COPY_PROTECT_H_O 0x00000204
#define AM_REG_INFO0_COPY_PROTECT_H_ADDR 0x50020204
#define AM_REG_INFO0_WRITE_PROTECT_SBL_L_O 0x000009f8
#define AM_REG_INFO0_WRITE_PROTECT_SBL_L_ADDR 0x500209f8
#define AM_REG_INFO0_WRITE_PROTECT_SBL_H_O 0x000009fc
#define AM_REG_INFO0_WRITE_PROTECT_SBL_H_ADDR 0x500209fc
#define AM_REG_INFO0_COPY_PROTECT_SBL_L_O 0x00000a00
#define AM_REG_INFO0_COPY_PROTECT_SBL_L_ADDR 0x50020a00
#define AM_REG_INFO0_COPY_PROTECT_SBL_H_O 0x00000a04
#define AM_REG_INFO0_COPY_PROTECT_SBL_H_ADDR 0x50020a04
#define AM_REG_INFO0_MAIN_PTR0_O 0x00000c00
#define AM_REG_INFO0_MAIN_PTR0_ADDR 0x50020c00
#define AM_REG_INFO0_MAIN_PTR1_O 0x00000c04
#define AM_REG_INFO0_MAIN_PTR1_ADDR 0x50020c04
#define AM_REG_INFO0_KREVTRACK_O 0x00000c08
#define AM_REG_INFO0_KREVTRACK_ADDR 0x50020c08
#define AM_REG_INFO0_AREVTRACK_O 0x00000c0c
#define AM_REG_INFO0_AREVTRACK_ADDR 0x50020c0c
#define AM_REG_INFO0_OTA_DESCRIPTOR_O 0x00000c10
#define AM_REG_INFO0_OTA_DESCRIPTOR_ADDR 0x50020c10
#define AM_REG_INFO0_MAIN_CNT0_O 0x00000ff8
#define AM_REG_INFO0_MAIN_CNT0_ADDR 0x50020ff8
#define AM_REG_INFO0_MAIN_CNT1_O 0x00000ffc
#define AM_REG_INFO0_MAIN_CNT1_ADDR 0x50020ffc
#define AM_REG_INFO0_CUST_KEK_W0_O 0x00001800
#define AM_REG_INFO0_CUST_KEK_W0_ADDR 0x50021800
#define AM_REG_INFO0_CUST_KEK_W1_O 0x00001804
#define AM_REG_INFO0_CUST_KEK_W1_ADDR 0x50021804
#define AM_REG_INFO0_CUST_KEK_W2_O 0x00001808
#define AM_REG_INFO0_CUST_KEK_W2_ADDR 0x50021808
#define AM_REG_INFO0_CUST_KEK_W3_O 0x0000180c
#define AM_REG_INFO0_CUST_KEK_W3_ADDR 0x5002180c
#define AM_REG_INFO0_CUST_KEK_W4_O 0x00001810
#define AM_REG_INFO0_CUST_KEK_W4_ADDR 0x50021810
#define AM_REG_INFO0_CUST_KEK_W5_O 0x00001814
#define AM_REG_INFO0_CUST_KEK_W5_ADDR 0x50021814
#define AM_REG_INFO0_CUST_KEK_W6_O 0x00001818
#define AM_REG_INFO0_CUST_KEK_W6_ADDR 0x50021818
#define AM_REG_INFO0_CUST_KEK_W7_O 0x0000181c
#define AM_REG_INFO0_CUST_KEK_W7_ADDR 0x5002181c
#define AM_REG_INFO0_CUST_KEK_W8_O 0x00001820
#define AM_REG_INFO0_CUST_KEK_W8_ADDR 0x50021820
#define AM_REG_INFO0_CUST_KEK_W9_O 0x00001824
#define AM_REG_INFO0_CUST_KEK_W9_ADDR 0x50021824
#define AM_REG_INFO0_CUST_KEK_W10_O 0x00001828
#define AM_REG_INFO0_CUST_KEK_W10_ADDR 0x50021828
#define AM_REG_INFO0_CUST_KEK_W11_O 0x0000182c
#define AM_REG_INFO0_CUST_KEK_W11_ADDR 0x5002182c
#define AM_REG_INFO0_CUST_KEK_W12_O 0x00001830
#define AM_REG_INFO0_CUST_KEK_W12_ADDR 0x50021830
#define AM_REG_INFO0_CUST_KEK_W13_O 0x00001834
#define AM_REG_INFO0_CUST_KEK_W13_ADDR 0x50021834
#define AM_REG_INFO0_CUST_KEK_W14_O 0x00001838
#define AM_REG_INFO0_CUST_KEK_W14_ADDR 0x50021838
#define AM_REG_INFO0_CUST_KEK_W15_O 0x0000183c
#define AM_REG_INFO0_CUST_KEK_W15_ADDR 0x5002183c
#define AM_REG_INFO0_CUST_KEK_W16_O 0x00001840
#define AM_REG_INFO0_CUST_KEK_W16_ADDR 0x50021840
#define AM_REG_INFO0_CUST_KEK_W17_O 0x00001844
#define AM_REG_INFO0_CUST_KEK_W17_ADDR 0x50021844
#define AM_REG_INFO0_CUST_KEK_W18_O 0x00001848
#define AM_REG_INFO0_CUST_KEK_W18_ADDR 0x50021848
#define AM_REG_INFO0_CUST_KEK_W19_O 0x0000184c
#define AM_REG_INFO0_CUST_KEK_W19_ADDR 0x5002184c
#define AM_REG_INFO0_CUST_KEK_W20_O 0x00001850
#define AM_REG_INFO0_CUST_KEK_W20_ADDR 0x50021850
#define AM_REG_INFO0_CUST_KEK_W21_O 0x00001854
#define AM_REG_INFO0_CUST_KEK_W21_ADDR 0x50021854
#define AM_REG_INFO0_CUST_KEK_W22_O 0x00001858
#define AM_REG_INFO0_CUST_KEK_W22_ADDR 0x50021858
#define AM_REG_INFO0_CUST_KEK_W23_O 0x0000185c
#define AM_REG_INFO0_CUST_KEK_W23_ADDR 0x5002185c
#define AM_REG_INFO0_CUST_KEK_W24_O 0x00001860
#define AM_REG_INFO0_CUST_KEK_W24_ADDR 0x50021860
#define AM_REG_INFO0_CUST_KEK_W25_O 0x00001864
#define AM_REG_INFO0_CUST_KEK_W25_ADDR 0x50021864
#define AM_REG_INFO0_CUST_KEK_W26_O 0x00001868
#define AM_REG_INFO0_CUST_KEK_W26_ADDR 0x50021868
#define AM_REG_INFO0_CUST_KEK_W27_O 0x0000186c
#define AM_REG_INFO0_CUST_KEK_W27_ADDR 0x5002186c
#define AM_REG_INFO0_CUST_KEK_W28_O 0x00001870
#define AM_REG_INFO0_CUST_KEK_W28_ADDR 0x50021870
#define AM_REG_INFO0_CUST_KEK_W29_O 0x00001874
#define AM_REG_INFO0_CUST_KEK_W29_ADDR 0x50021874
#define AM_REG_INFO0_CUST_KEK_W30_O 0x00001878
#define AM_REG_INFO0_CUST_KEK_W30_ADDR 0x50021878
#define AM_REG_INFO0_CUST_KEK_W31_O 0x0000187c
#define AM_REG_INFO0_CUST_KEK_W31_ADDR 0x5002187c
#define AM_REG_INFO0_CUST_AUTH_W0_O 0x00001880
#define AM_REG_INFO0_CUST_AUTH_W0_ADDR 0x50021880
#define AM_REG_INFO0_CUST_AUTH_W1_O 0x00001884
#define AM_REG_INFO0_CUST_AUTH_W1_ADDR 0x50021884
#define AM_REG_INFO0_CUST_AUTH_W2_O 0x00001888
#define AM_REG_INFO0_CUST_AUTH_W2_ADDR 0x50021888
#define AM_REG_INFO0_CUST_AUTH_W3_O 0x0000188c
#define AM_REG_INFO0_CUST_AUTH_W3_ADDR 0x5002188c
#define AM_REG_INFO0_CUST_AUTH_W4_O 0x00001890
#define AM_REG_INFO0_CUST_AUTH_W4_ADDR 0x50021890
#define AM_REG_INFO0_CUST_AUTH_W5_O 0x00001894
#define AM_REG_INFO0_CUST_AUTH_W5_ADDR 0x50021894
#define AM_REG_INFO0_CUST_AUTH_W6_O 0x00001898
#define AM_REG_INFO0_CUST_AUTH_W6_ADDR 0x50021898
#define AM_REG_INFO0_CUST_AUTH_W7_O 0x0000189c
#define AM_REG_INFO0_CUST_AUTH_W7_ADDR 0x5002189c
#define AM_REG_INFO0_CUST_AUTH_W8_O 0x000018a0
#define AM_REG_INFO0_CUST_AUTH_W8_ADDR 0x500218a0
#define AM_REG_INFO0_CUST_AUTH_W9_O 0x000018a4
#define AM_REG_INFO0_CUST_AUTH_W9_ADDR 0x500218a4
#define AM_REG_INFO0_CUST_AUTH_W10_O 0x000018a8
#define AM_REG_INFO0_CUST_AUTH_W10_ADDR 0x500218a8
#define AM_REG_INFO0_CUST_AUTH_W11_O 0x000018ac
#define AM_REG_INFO0_CUST_AUTH_W11_ADDR 0x500218ac
#define AM_REG_INFO0_CUST_AUTH_W12_O 0x000018b0
#define AM_REG_INFO0_CUST_AUTH_W12_ADDR 0x500218b0
#define AM_REG_INFO0_CUST_AUTH_W13_O 0x000018b4
#define AM_REG_INFO0_CUST_AUTH_W13_ADDR 0x500218b4
#define AM_REG_INFO0_CUST_AUTH_W14_O 0x000018b8
#define AM_REG_INFO0_CUST_AUTH_W14_ADDR 0x500218b8
#define AM_REG_INFO0_CUST_AUTH_W15_O 0x000018bc
#define AM_REG_INFO0_CUST_AUTH_W15_ADDR 0x500218bc
#define AM_REG_INFO0_CUST_AUTH_W16_O 0x000018c0
#define AM_REG_INFO0_CUST_AUTH_W16_ADDR 0x500218c0
#define AM_REG_INFO0_CUST_AUTH_W17_O 0x000018c4
#define AM_REG_INFO0_CUST_AUTH_W17_ADDR 0x500218c4
#define AM_REG_INFO0_CUST_AUTH_W18_O 0x000018c8
#define AM_REG_INFO0_CUST_AUTH_W18_ADDR 0x500218c8
#define AM_REG_INFO0_CUST_AUTH_W19_O 0x000018cc
#define AM_REG_INFO0_CUST_AUTH_W19_ADDR 0x500218cc
#define AM_REG_INFO0_CUST_AUTH_W20_O 0x000018d0
#define AM_REG_INFO0_CUST_AUTH_W20_ADDR 0x500218d0
#define AM_REG_INFO0_CUST_AUTH_W21_O 0x000018d4
#define AM_REG_INFO0_CUST_AUTH_W21_ADDR 0x500218d4
#define AM_REG_INFO0_CUST_AUTH_W22_O 0x000018d8
#define AM_REG_INFO0_CUST_AUTH_W22_ADDR 0x500218d8
#define AM_REG_INFO0_CUST_AUTH_W23_O 0x000018dc
#define AM_REG_INFO0_CUST_AUTH_W23_ADDR 0x500218dc
#define AM_REG_INFO0_CUST_AUTH_W24_O 0x000018e0
#define AM_REG_INFO0_CUST_AUTH_W24_ADDR 0x500218e0
#define AM_REG_INFO0_CUST_AUTH_W25_O 0x000018e4
#define AM_REG_INFO0_CUST_AUTH_W25_ADDR 0x500218e4
#define AM_REG_INFO0_CUST_AUTH_W26_O 0x000018e8
#define AM_REG_INFO0_CUST_AUTH_W26_ADDR 0x500218e8
#define AM_REG_INFO0_CUST_AUTH_W27_O 0x000018ec
#define AM_REG_INFO0_CUST_AUTH_W27_ADDR 0x500218ec
#define AM_REG_INFO0_CUST_AUTH_W28_O 0x000018f0
#define AM_REG_INFO0_CUST_AUTH_W28_ADDR 0x500218f0
#define AM_REG_INFO0_CUST_AUTH_W29_O 0x000018f4
#define AM_REG_INFO0_CUST_AUTH_W29_ADDR 0x500218f4
#define AM_REG_INFO0_CUST_AUTH_W30_O 0x000018f8
#define AM_REG_INFO0_CUST_AUTH_W30_ADDR 0x500218f8
#define AM_REG_INFO0_CUST_AUTH_W31_O 0x000018fc
#define AM_REG_INFO0_CUST_AUTH_W31_ADDR 0x500218fc
#define AM_REG_INFO0_CUST_PUBKEY_W0_O 0x00001900
#define AM_REG_INFO0_CUST_PUBKEY_W0_ADDR 0x50021900
#define AM_REG_INFO0_CUST_PUBKEY_W1_O 0x00001904
#define AM_REG_INFO0_CUST_PUBKEY_W1_ADDR 0x50021904
#define AM_REG_INFO0_CUST_PUBKEY_W2_O 0x00001908
#define AM_REG_INFO0_CUST_PUBKEY_W2_ADDR 0x50021908
#define AM_REG_INFO0_CUST_PUBKEY_W3_O 0x0000190c
#define AM_REG_INFO0_CUST_PUBKEY_W3_ADDR 0x5002190c
#define AM_REG_INFO0_CUST_PUBKEY_W4_O 0x00001910
#define AM_REG_INFO0_CUST_PUBKEY_W4_ADDR 0x50021910
#define AM_REG_INFO0_CUST_PUBKEY_W5_O 0x00001914
#define AM_REG_INFO0_CUST_PUBKEY_W5_ADDR 0x50021914
#define AM_REG_INFO0_CUST_PUBKEY_W6_O 0x00001918
#define AM_REG_INFO0_CUST_PUBKEY_W6_ADDR 0x50021918
#define AM_REG_INFO0_CUST_PUBKEY_W7_O 0x0000191c
#define AM_REG_INFO0_CUST_PUBKEY_W7_ADDR 0x5002191c
#define AM_REG_INFO0_CUST_PUBKEY_W8_O 0x00001920
#define AM_REG_INFO0_CUST_PUBKEY_W8_ADDR 0x50021920
#define AM_REG_INFO0_CUST_PUBKEY_W9_O 0x00001924
#define AM_REG_INFO0_CUST_PUBKEY_W9_ADDR 0x50021924
#define AM_REG_INFO0_CUST_PUBKEY_W10_O 0x00001928
#define AM_REG_INFO0_CUST_PUBKEY_W10_ADDR 0x50021928
#define AM_REG_INFO0_CUST_PUBKEY_W11_O 0x0000192c
#define AM_REG_INFO0_CUST_PUBKEY_W11_ADDR 0x5002192c
#define AM_REG_INFO0_CUST_PUBKEY_W12_O 0x00001930
#define AM_REG_INFO0_CUST_PUBKEY_W12_ADDR 0x50021930
#define AM_REG_INFO0_CUST_PUBKEY_W13_O 0x00001934
#define AM_REG_INFO0_CUST_PUBKEY_W13_ADDR 0x50021934
#define AM_REG_INFO0_CUST_PUBKEY_W14_O 0x00001938
#define AM_REG_INFO0_CUST_PUBKEY_W14_ADDR 0x50021938
#define AM_REG_INFO0_CUST_PUBKEY_W15_O 0x0000193c
#define AM_REG_INFO0_CUST_PUBKEY_W15_ADDR 0x5002193c
#define AM_REG_INFO0_CUST_PUBKEY_W16_O 0x00001940
#define AM_REG_INFO0_CUST_PUBKEY_W16_ADDR 0x50021940
#define AM_REG_INFO0_CUST_PUBKEY_W17_O 0x00001944
#define AM_REG_INFO0_CUST_PUBKEY_W17_ADDR 0x50021944
#define AM_REG_INFO0_CUST_PUBKEY_W18_O 0x00001948
#define AM_REG_INFO0_CUST_PUBKEY_W18_ADDR 0x50021948
#define AM_REG_INFO0_CUST_PUBKEY_W19_O 0x0000194c
#define AM_REG_INFO0_CUST_PUBKEY_W19_ADDR 0x5002194c
#define AM_REG_INFO0_CUST_PUBKEY_W20_O 0x00001950
#define AM_REG_INFO0_CUST_PUBKEY_W20_ADDR 0x50021950
#define AM_REG_INFO0_CUST_PUBKEY_W21_O 0x00001954
#define AM_REG_INFO0_CUST_PUBKEY_W21_ADDR 0x50021954
#define AM_REG_INFO0_CUST_PUBKEY_W22_O 0x00001958
#define AM_REG_INFO0_CUST_PUBKEY_W22_ADDR 0x50021958
#define AM_REG_INFO0_CUST_PUBKEY_W23_O 0x0000195c
#define AM_REG_INFO0_CUST_PUBKEY_W23_ADDR 0x5002195c
#define AM_REG_INFO0_CUST_PUBKEY_W24_O 0x00001960
#define AM_REG_INFO0_CUST_PUBKEY_W24_ADDR 0x50021960
#define AM_REG_INFO0_CUST_PUBKEY_W25_O 0x00001964
#define AM_REG_INFO0_CUST_PUBKEY_W25_ADDR 0x50021964
#define AM_REG_INFO0_CUST_PUBKEY_W26_O 0x00001968
#define AM_REG_INFO0_CUST_PUBKEY_W26_ADDR 0x50021968
#define AM_REG_INFO0_CUST_PUBKEY_W27_O 0x0000196c
#define AM_REG_INFO0_CUST_PUBKEY_W27_ADDR 0x5002196c
#define AM_REG_INFO0_CUST_PUBKEY_W28_O 0x00001970
#define AM_REG_INFO0_CUST_PUBKEY_W28_ADDR 0x50021970
#define AM_REG_INFO0_CUST_PUBKEY_W29_O 0x00001974
#define AM_REG_INFO0_CUST_PUBKEY_W29_ADDR 0x50021974
#define AM_REG_INFO0_CUST_PUBKEY_W30_O 0x00001978
#define AM_REG_INFO0_CUST_PUBKEY_W30_ADDR 0x50021978
#define AM_REG_INFO0_CUST_PUBKEY_W31_O 0x0000197c
#define AM_REG_INFO0_CUST_PUBKEY_W31_ADDR 0x5002197c
#define AM_REG_INFO0_CUST_PUBKEY_W32_O 0x00001980
#define AM_REG_INFO0_CUST_PUBKEY_W32_ADDR 0x50021980
#define AM_REG_INFO0_CUST_PUBKEY_W33_O 0x00001984
#define AM_REG_INFO0_CUST_PUBKEY_W33_ADDR 0x50021984
#define AM_REG_INFO0_CUST_PUBKEY_W34_O 0x00001988
#define AM_REG_INFO0_CUST_PUBKEY_W34_ADDR 0x50021988
#define AM_REG_INFO0_CUST_PUBKEY_W35_O 0x0000198c
#define AM_REG_INFO0_CUST_PUBKEY_W35_ADDR 0x5002198c
#define AM_REG_INFO0_CUST_PUBKEY_W36_O 0x00001990
#define AM_REG_INFO0_CUST_PUBKEY_W36_ADDR 0x50021990
#define AM_REG_INFO0_CUST_PUBKEY_W37_O 0x00001994
#define AM_REG_INFO0_CUST_PUBKEY_W37_ADDR 0x50021994
#define AM_REG_INFO0_CUST_PUBKEY_W38_O 0x00001998
#define AM_REG_INFO0_CUST_PUBKEY_W38_ADDR 0x50021998
#define AM_REG_INFO0_CUST_PUBKEY_W39_O 0x0000199c
#define AM_REG_INFO0_CUST_PUBKEY_W39_ADDR 0x5002199c
#define AM_REG_INFO0_CUST_PUBKEY_W40_O 0x000019a0
#define AM_REG_INFO0_CUST_PUBKEY_W40_ADDR 0x500219a0
#define AM_REG_INFO0_CUST_PUBKEY_W41_O 0x000019a4
#define AM_REG_INFO0_CUST_PUBKEY_W41_ADDR 0x500219a4
#define AM_REG_INFO0_CUST_PUBKEY_W42_O 0x000019a8
#define AM_REG_INFO0_CUST_PUBKEY_W42_ADDR 0x500219a8
#define AM_REG_INFO0_CUST_PUBKEY_W43_O 0x000019ac
#define AM_REG_INFO0_CUST_PUBKEY_W43_ADDR 0x500219ac
#define AM_REG_INFO0_CUST_PUBKEY_W44_O 0x000019b0
#define AM_REG_INFO0_CUST_PUBKEY_W44_ADDR 0x500219b0
#define AM_REG_INFO0_CUST_PUBKEY_W45_O 0x000019b4
#define AM_REG_INFO0_CUST_PUBKEY_W45_ADDR 0x500219b4
#define AM_REG_INFO0_CUST_PUBKEY_W46_O 0x000019b8
#define AM_REG_INFO0_CUST_PUBKEY_W46_ADDR 0x500219b8
#define AM_REG_INFO0_CUST_PUBKEY_W47_O 0x000019bc
#define AM_REG_INFO0_CUST_PUBKEY_W47_ADDR 0x500219bc
#define AM_REG_INFO0_CUST_PUBKEY_W48_O 0x000019c0
#define AM_REG_INFO0_CUST_PUBKEY_W48_ADDR 0x500219c0
#define AM_REG_INFO0_CUST_PUBKEY_W49_O 0x000019c4
#define AM_REG_INFO0_CUST_PUBKEY_W49_ADDR 0x500219c4
#define AM_REG_INFO0_CUST_PUBKEY_W50_O 0x000019c8
#define AM_REG_INFO0_CUST_PUBKEY_W50_ADDR 0x500219c8
#define AM_REG_INFO0_CUST_PUBKEY_W51_O 0x000019cc
#define AM_REG_INFO0_CUST_PUBKEY_W51_ADDR 0x500219cc
#define AM_REG_INFO0_CUST_PUBKEY_W52_O 0x000019d0
#define AM_REG_INFO0_CUST_PUBKEY_W52_ADDR 0x500219d0
#define AM_REG_INFO0_CUST_PUBKEY_W53_O 0x000019d4
#define AM_REG_INFO0_CUST_PUBKEY_W53_ADDR 0x500219d4
#define AM_REG_INFO0_CUST_PUBKEY_W54_O 0x000019d8
#define AM_REG_INFO0_CUST_PUBKEY_W54_ADDR 0x500219d8
#define AM_REG_INFO0_CUST_PUBKEY_W55_O 0x000019dc
#define AM_REG_INFO0_CUST_PUBKEY_W55_ADDR 0x500219dc
#define AM_REG_INFO0_CUST_PUBKEY_W56_O 0x000019e0
#define AM_REG_INFO0_CUST_PUBKEY_W56_ADDR 0x500219e0
#define AM_REG_INFO0_CUST_PUBKEY_W57_O 0x000019e4
#define AM_REG_INFO0_CUST_PUBKEY_W57_ADDR 0x500219e4
#define AM_REG_INFO0_CUST_PUBKEY_W58_O 0x000019e8
#define AM_REG_INFO0_CUST_PUBKEY_W58_ADDR 0x500219e8
#define AM_REG_INFO0_CUST_PUBKEY_W59_O 0x000019ec
#define AM_REG_INFO0_CUST_PUBKEY_W59_ADDR 0x500219ec
#define AM_REG_INFO0_CUST_PUBKEY_W60_O 0x000019f0
#define AM_REG_INFO0_CUST_PUBKEY_W60_ADDR 0x500219f0
#define AM_REG_INFO0_CUST_PUBKEY_W61_O 0x000019f4
#define AM_REG_INFO0_CUST_PUBKEY_W61_ADDR 0x500219f4
#define AM_REG_INFO0_CUST_PUBKEY_W62_O 0x000019f8
#define AM_REG_INFO0_CUST_PUBKEY_W62_ADDR 0x500219f8
#define AM_REG_INFO0_CUST_PUBKEY_W63_O 0x000019fc
#define AM_REG_INFO0_CUST_PUBKEY_W63_ADDR 0x500219fc
#define AM_REG_INFO0_CUSTOMER_KEY0_O 0x00001a00
#define AM_REG_INFO0_CUSTOMER_KEY0_ADDR 0x50021a00
#define AM_REG_INFO0_CUSTOMER_KEY1_O 0x00001a04
#define AM_REG_INFO0_CUSTOMER_KEY1_ADDR 0x50021a04
#define AM_REG_INFO0_CUSTOMER_KEY2_O 0x00001a08
#define AM_REG_INFO0_CUSTOMER_KEY2_ADDR 0x50021a08
#define AM_REG_INFO0_CUSTOMER_KEY3_O 0x00001a0c
#define AM_REG_INFO0_CUSTOMER_KEY3_ADDR 0x50021a0c
#define AM_REG_INFO0_CUST_PUBHASH_W0_O 0x00001a10
#define AM_REG_INFO0_CUST_PUBHASH_W0_ADDR 0x50021a10
#define AM_REG_INFO0_CUST_PUBHASH_W1_O 0x00001a14
#define AM_REG_INFO0_CUST_PUBHASH_W1_ADDR 0x50021a14
#define AM_REG_INFO0_CUST_PUBHASH_W2_O 0x00001a18
#define AM_REG_INFO0_CUST_PUBHASH_W2_ADDR 0x50021a18
#define AM_REG_INFO0_CUST_PUBHASH_W3_O 0x00001a1c
#define AM_REG_INFO0_CUST_PUBHASH_W3_ADDR 0x50021a1c
#define AM_REG_INFO0_CUSTID_O 0x00001a20
#define AM_REG_INFO0_CUSTID_ADDR 0x50021a20

// SIGNATURE0 - This is word 0 (low word, bits 31:0) of the 128-bit INFO0 signature. The value in SIGNATURE* determines if the rest of INFO0 is valid.
#define AM_REG_INFO0_SIGNATURE0_SIG0_S 0
#define AM_REG_INFO0_SIGNATURE0_SIG0_M 0xFFFFFFFF
#define AM_REG_INFO0_SIGNATURE0_SIG0(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// SIGNATURE1 - Word 1 (bits 63:32) of the 128-bit INFO0 signature. The value in SIGNATURE* determines if the rest of INFO0 is valid.
#define AM_REG_INFO0_SIGNATURE1_SIG1_S 0
#define AM_REG_INFO0_SIGNATURE1_SIG1_M 0xFFFFFFFF
#define AM_REG_INFO0_SIGNATURE1_SIG1(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// SIGNATURE2 - Word 2 (bits 95:64) of the 128-bit INFO0 signature. The value in SIGNATURE* determines if the rest of INFO0 is valid.
#define AM_REG_INFO0_SIGNATURE2_SIG2_S 0
#define AM_REG_INFO0_SIGNATURE2_SIG2_M 0xFFFFFFFF
#define AM_REG_INFO0_SIGNATURE2_SIG2(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// SIGNATURE3 - Word 3 (high word, bits 127:96) of the 128-bit INFO0 signature. The value in SIGNATURE* determines if the rest of INFO0 is valid.
#define AM_REG_INFO0_SIGNATURE3_SIG3_S 0
#define AM_REG_INFO0_SIGNATURE3_SIG3_M 0xFFFFFFFF
#define AM_REG_INFO0_SIGNATURE3_SIG3(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// SECURITY - This 32-bit word contains the customer programmable security.
#define AM_REG_INFO0_SECURITY_SECPOL_S 24
#define AM_REG_INFO0_SECURITY_SECPOL_M 0x07000000
#define AM_REG_INFO0_SECURITY_SECPOL(n) (((uint32_t)(n) << 24) & 0x07000000)
#define AM_REG_INFO0_SECURITY_KEYWRAP_S 20
#define AM_REG_INFO0_SECURITY_KEYWRAP_M 0x00F00000
#define AM_REG_INFO0_SECURITY_KEYWRAP(n) (((uint32_t)(n) << 20) & 0x00F00000)
#define AM_REG_INFO0_SECURITY_RSVD19_S 19
#define AM_REG_INFO0_SECURITY_RSVD19_M 0x00080000
#define AM_REG_INFO0_SECURITY_RSVD19(n) (((uint32_t)(n) << 19) & 0x00080000)
#define AM_REG_INFO0_SECURITY_SECBOOTONRST_S 16
#define AM_REG_INFO0_SECURITY_SECBOOTONRST_M 0x00070000
#define AM_REG_INFO0_SECURITY_SECBOOTONRST(n) (((uint32_t)(n) << 16) & 0x00070000)
#define AM_REG_INFO0_SECURITY_RSVD15_S 15
#define AM_REG_INFO0_SECURITY_RSVD15_M 0x00008000
#define AM_REG_INFO0_SECURITY_RSVD15(n) (((uint32_t)(n) << 15) & 0x00008000)
#define AM_REG_INFO0_SECURITY_SECBOOT_S 12
#define AM_REG_INFO0_SECURITY_SECBOOT_M 0x00007000
#define AM_REG_INFO0_SECURITY_SECBOOT(n) (((uint32_t)(n) << 12) & 0x00007000)
#define AM_REG_INFO0_SECURITY_PLONEXIT_S 11
#define AM_REG_INFO0_SECURITY_PLONEXIT_M 0x00000800
#define AM_REG_INFO0_SECURITY_PLONEXIT(n) (((uint32_t)(n) << 11) & 0x00000800)
#define AM_REG_INFO0_SECURITY_SDBG_S 10
#define AM_REG_INFO0_SECURITY_SDBG_M 0x00000400
#define AM_REG_INFO0_SECURITY_SDBG(n) (((uint32_t)(n) << 10) & 0x00000400)
#define AM_REG_INFO0_SECURITY_BOOTLOADER_AT_RESET_S 9
#define AM_REG_INFO0_SECURITY_BOOTLOADER_AT_RESET_M 0x00000200
#define AM_REG_INFO0_SECURITY_BOOTLOADER_AT_RESET(n) (((uint32_t)(n) << 9) & 0x00000200)
#define AM_REG_INFO0_SECURITY_EN_CUST_INFO_ERASE_S 8
#define AM_REG_INFO0_SECURITY_EN_CUST_INFO_ERASE_M 0x00000100
#define AM_REG_INFO0_SECURITY_EN_CUST_INFO_ERASE(n) (((uint32_t)(n) << 8) & 0x00000100)
#define AM_REG_INFO0_SECURITY_EN_CUST_INFO_PROG_S 4
#define AM_REG_INFO0_SECURITY_EN_CUST_INFO_PROG_M 0x000000F0
#define AM_REG_INFO0_SECURITY_EN_CUST_INFO_PROG(n) (((uint32_t)(n) << 4) & 0x000000F0)
#define AM_REG_INFO0_SECURITY_SECURE_LOCK_S 3
#define AM_REG_INFO0_SECURITY_SECURE_LOCK_M 0x00000008
#define AM_REG_INFO0_SECURITY_SECURE_LOCK(n) (((uint32_t)(n) << 3) & 0x00000008)
#define AM_REG_INFO0_SECURITY_RSVD02_S 2
#define AM_REG_INFO0_SECURITY_RSVD02_M 0x00000004
#define AM_REG_INFO0_SECURITY_RSVD02(n) (((uint32_t)(n) << 2) & 0x00000004)
#define AM_REG_INFO0_SECURITY_RSVD01_S 1
#define AM_REG_INFO0_SECURITY_RSVD01_M 0x00000002
#define AM_REG_INFO0_SECURITY_RSVD01(n) (((uint32_t)(n) << 1) & 0x00000002)
#define AM_REG_INFO0_SECURITY_DEBUG_PROT_S 0
#define AM_REG_INFO0_SECURITY_DEBUG_PROT_M 0x00000001
#define AM_REG_INFO0_SECURITY_DEBUG_PROT(n) (((uint32_t)(n) << 0) & 0x00000001)

// CUSTOMER_TRIM - Customer Programmable trim overrides.  Bits in this register are loaded into hardware registers at reset.
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_FEM_CTRL_S 3
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_FEM_CTRL_M 0x00000008
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_FEM_CTRL(n) (((uint32_t)(n) << 3) & 0x00000008)
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_FEATURE_enable_S 2
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_FEATURE_enable_M 0x00000004
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_FEATURE_enable(n) (((uint32_t)(n) << 2) & 0x00000004)
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_BUCK_enable_S 1
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_BUCK_enable_M 0x00000002
#define AM_REG_INFO0_CUSTOMER_TRIM_BLE_BUCK_enable(n) (((uint32_t)(n) << 1) & 0x00000002)
#define AM_REG_INFO0_CUSTOMER_TRIM_SIMO_BUCK_enable_S 0
#define AM_REG_INFO0_CUSTOMER_TRIM_SIMO_BUCK_enable_M 0x00000001
#define AM_REG_INFO0_CUSTOMER_TRIM_SIMO_BUCK_enable(n) (((uint32_t)(n) << 0) & 0x00000001)

// CUSTOMER_TRIM2 - Customer Programmable trim overrides.  Bits in this register are used by software for hardware configuration.
#define AM_REG_INFO0_CUSTOMER_TRIM2_XO32M_FREQ_TRIM_S 0
#define AM_REG_INFO0_CUSTOMER_TRIM2_XO32M_FREQ_TRIM_M 0x000007FF
#define AM_REG_INFO0_CUSTOMER_TRIM2_XO32M_FREQ_TRIM(n) (((uint32_t)(n) << 0) & 0x000007FF)

// SECURITY_OVR - This 32-bit word contains the override configuration for forcing GPIO-based firmware update.
#define AM_REG_INFO0_SECURITY_OVR_POL_S 7
#define AM_REG_INFO0_SECURITY_OVR_POL_M 0x00000080
#define AM_REG_INFO0_SECURITY_OVR_POL(n) (((uint32_t)(n) << 7) & 0x00000080)
#define AM_REG_INFO0_SECURITY_OVR_GPIO_S 0
#define AM_REG_INFO0_SECURITY_OVR_GPIO_M 0x0000007F
#define AM_REG_INFO0_SECURITY_OVR_GPIO(n) (((uint32_t)(n) << 0) & 0x0000007F)

// SECURITY_WIRED_CFG - This 32-bit word contains the configuration for the wired update interface.
#define AM_REG_INFO0_SECURITY_WIRED_CFG_TIMEOUT_S 16
#define AM_REG_INFO0_SECURITY_WIRED_CFG_TIMEOUT_M 0xFFFF0000
#define AM_REG_INFO0_SECURITY_WIRED_CFG_TIMEOUT(n) (((uint32_t)(n) << 16) & 0xFFFF0000)
#define AM_REG_INFO0_SECURITY_WIRED_CFG_I2CADDR_S 9
#define AM_REG_INFO0_SECURITY_WIRED_CFG_I2CADDR_M 0x0000FE00
#define AM_REG_INFO0_SECURITY_WIRED_CFG_I2CADDR(n) (((uint32_t)(n) << 9) & 0x0000FE00)
#define AM_REG_INFO0_SECURITY_WIRED_CFG_SLVINTPIN_S 3
#define AM_REG_INFO0_SECURITY_WIRED_CFG_SLVINTPIN_M 0x000001F8
#define AM_REG_INFO0_SECURITY_WIRED_CFG_SLVINTPIN(n) (((uint32_t)(n) << 3) & 0x000001F8)
#define AM_REG_INFO0_SECURITY_WIRED_CFG_IFC_S 0
#define AM_REG_INFO0_SECURITY_WIRED_CFG_IFC_M 0x00000007
#define AM_REG_INFO0_SECURITY_WIRED_CFG_IFC(n) (((uint32_t)(n) << 0) & 0x00000007)

// SECURITY_WIRED_IFC_CFG0 - This 32-bit word contains the interface configuration word0 for the UART wired update.
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_BAUDRATE_S 8
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_BAUDRATE_M 0x0FFFFF00
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_BAUDRATE(n) (((uint32_t)(n) << 8) & 0x0FFFFF00)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_DATALEN_S 6
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_DATALEN_M 0x000000C0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_DATALEN(n) (((uint32_t)(n) << 6) & 0x000000C0)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_2STOP_S 5
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_2STOP_M 0x00000020
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_2STOP(n) (((uint32_t)(n) << 5) & 0x00000020)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_EVEN_S 4
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_EVEN_M 0x00000010
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_EVEN(n) (((uint32_t)(n) << 4) & 0x00000010)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_PAR_S 3
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_PAR_M 0x00000008
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_PAR(n) (((uint32_t)(n) << 3) & 0x00000008)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_CTS_S 2
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_CTS_M 0x00000004
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_CTS(n) (((uint32_t)(n) << 2) & 0x00000004)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_RTS_S 1
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_RTS_M 0x00000002
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_RTS(n) (((uint32_t)(n) << 1) & 0x00000002)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_UART_S 0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_UART_M 0x00000001
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG0_UART(n) (((uint32_t)(n) << 0) & 0x00000001)

// SECURITY_WIRED_IFC_CFG1 - This 32-bit word contains the interface configuration word1 for the UART wired update.
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN3_S 24
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN3_M 0xFF000000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN3(n) (((uint32_t)(n) << 24) & 0xFF000000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN2_S 16
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN2_M 0x00FF0000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN2(n) (((uint32_t)(n) << 16) & 0x00FF0000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN1_S 8
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN1_M 0x0000FF00
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN1(n) (((uint32_t)(n) << 8) & 0x0000FF00)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN0_S 0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN0_M 0x000000FF
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG1_PIN0(n) (((uint32_t)(n) << 0) & 0x000000FF)

// SECURITY_WIRED_IFC_CFG2 - This 32-bit word contains the raw Pin configuration for the UART wired interface pin 0.
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_RSVD2_S 24
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_RSVD2_M 0xFF000000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_RSVD2(n) (((uint32_t)(n) << 24) & 0xFF000000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_ALTPADCFG_S 16
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_ALTPADCFG_M 0x00FF0000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_ALTPADCFG(n) (((uint32_t)(n) << 16) & 0x00FF0000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_RSVD1_S 12
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_RSVD1_M 0x0000F000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_RSVD1(n) (((uint32_t)(n) << 12) & 0x0000F000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_GPIOCFG_S 8
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_GPIOCFG_M 0x00000F00
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_GPIOCFG(n) (((uint32_t)(n) << 8) & 0x00000F00)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_PADCFG_S 0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_PADCFG_M 0x000000FF
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG2_PADCFG(n) (((uint32_t)(n) << 0) & 0x000000FF)

// SECURITY_WIRED_IFC_CFG3 - This 32-bit word contains the raw Pin configuration for the UART wired interface pin 1.
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_RSVD2_S 24
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_RSVD2_M 0xFF000000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_RSVD2(n) (((uint32_t)(n) << 24) & 0xFF000000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_ALTPADCFG_S 16
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_ALTPADCFG_M 0x00FF0000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_ALTPADCFG(n) (((uint32_t)(n) << 16) & 0x00FF0000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_RSVD1_S 12
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_RSVD1_M 0x0000F000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_RSVD1(n) (((uint32_t)(n) << 12) & 0x0000F000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_GPIOCFG_S 8
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_GPIOCFG_M 0x00000F00
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_GPIOCFG(n) (((uint32_t)(n) << 8) & 0x00000F00)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_PADCFG_S 0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_PADCFG_M 0x000000FF
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG3_PADCFG(n) (((uint32_t)(n) << 0) & 0x000000FF)

// SECURITY_WIRED_IFC_CFG4 - This 32-bit word contains the raw Pin configuration for the UART wired interface pin 2.
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_RSVD2_S 24
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_RSVD2_M 0xFF000000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_RSVD2(n) (((uint32_t)(n) << 24) & 0xFF000000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_ALTPADCFG_S 16
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_ALTPADCFG_M 0x00FF0000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_ALTPADCFG(n) (((uint32_t)(n) << 16) & 0x00FF0000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_RSVD1_S 12
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_RSVD1_M 0x0000F000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_RSVD1(n) (((uint32_t)(n) << 12) & 0x0000F000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_GPIOCFG_S 8
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_GPIOCFG_M 0x00000F00
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_GPIOCFG(n) (((uint32_t)(n) << 8) & 0x00000F00)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_PADCFG_S 0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_PADCFG_M 0x000000FF
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG4_PADCFG(n) (((uint32_t)(n) << 0) & 0x000000FF)

// SECURITY_WIRED_IFC_CFG5 - This 32-bit word contains the raw Pin configuration for the UART wired interface pin 3.
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_RSVD2_S 24
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_RSVD2_M 0xFF000000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_RSVD2(n) (((uint32_t)(n) << 24) & 0xFF000000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_ALTPADCFG_S 16
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_ALTPADCFG_M 0x00FF0000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_ALTPADCFG(n) (((uint32_t)(n) << 16) & 0x00FF0000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_RSVD1_S 12
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_RSVD1_M 0x0000F000
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_RSVD1(n) (((uint32_t)(n) << 12) & 0x0000F000)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_GPIOCFG_S 8
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_GPIOCFG_M 0x00000F00
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_GPIOCFG(n) (((uint32_t)(n) << 8) & 0x00000F00)
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_PADCFG_S 0
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_PADCFG_M 0x000000FF
#define AM_REG_INFO0_SECURITY_WIRED_IFC_CFG5_PADCFG(n) (((uint32_t)(n) << 0) & 0x000000FF)

// SECURITY_VERSION - This 32-bit word contains the version ID used for revision control
#define AM_REG_INFO0_SECURITY_VERSION_VERSION_S 0
#define AM_REG_INFO0_SECURITY_VERSION_VERSION_M 0xFFFFFFFF
#define AM_REG_INFO0_SECURITY_VERSION_VERSION(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// SECURITY_SRAM_RESV - This 16-bit word indicates the amount of SRAM to keep reserved for application scratch space. This reserves the specified memory at the top end of SRAM memory address range. This memory is not disturbed by the Secure Boot Loader. Please note that future releases of SBL may increase the width of this field to 18 bits.
#define AM_REG_INFO0_SECURITY_SRAM_RESV_SRAM_RESV_S 0
#define AM_REG_INFO0_SECURITY_SRAM_RESV_SRAM_RESV_M 0x0000FFFF
#define AM_REG_INFO0_SECURITY_SRAM_RESV_SRAM_RESV(n) (((uint32_t)(n) << 0) & 0x0000FFFF)

// WRITE_PROTECT_L - These bits write-protect flash in 16KB chunks.
#define AM_REG_INFO0_WRITE_PROTECT_L_CHUNKS_S 0
#define AM_REG_INFO0_WRITE_PROTECT_L_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_WRITE_PROTECT_L_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// WRITE_PROTECT_H - These bits write-protect flash in 16KB chunks.
#define AM_REG_INFO0_WRITE_PROTECT_H_CHUNKS_S 0
#define AM_REG_INFO0_WRITE_PROTECT_H_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_WRITE_PROTECT_H_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// COPY_PROTECT_L - These bits read-protect flash in 16KB chunks.
#define AM_REG_INFO0_COPY_PROTECT_L_CHUNKS_S 0
#define AM_REG_INFO0_COPY_PROTECT_L_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_COPY_PROTECT_L_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// COPY_PROTECT_H - These bits read-protect flash in 16KB chunks.
#define AM_REG_INFO0_COPY_PROTECT_H_CHUNKS_S 0
#define AM_REG_INFO0_COPY_PROTECT_H_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_COPY_PROTECT_H_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// WRITE_PROTECT_SBL_L - These bits write-protect flash in 16KB chunks. Only SBL can override these through Secure OTA
#define AM_REG_INFO0_WRITE_PROTECT_SBL_L_CHUNKS_S 0
#define AM_REG_INFO0_WRITE_PROTECT_SBL_L_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_WRITE_PROTECT_SBL_L_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// WRITE_PROTECT_SBL_H - These bits write-protect flash in 16KB chunks. Only SBL can override these through Secure OTA
#define AM_REG_INFO0_WRITE_PROTECT_SBL_H_CHUNKS_S 0
#define AM_REG_INFO0_WRITE_PROTECT_SBL_H_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_WRITE_PROTECT_SBL_H_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// COPY_PROTECT_SBL_L - These bits read-protect flash in 16KB chunks.
#define AM_REG_INFO0_COPY_PROTECT_SBL_L_CHUNKS_S 0
#define AM_REG_INFO0_COPY_PROTECT_SBL_L_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_COPY_PROTECT_SBL_L_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// COPY_PROTECT_SBL_H - These bits read-protect flash in 16KB chunks. Only SBL can override these through Secure OTA
#define AM_REG_INFO0_COPY_PROTECT_SBL_H_CHUNKS_S 0
#define AM_REG_INFO0_COPY_PROTECT_SBL_H_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_COPY_PROTECT_SBL_H_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// MAIN_PTR0 - This is the main/sbl_main firmware pointer 0 referenced by sbl_init for pointing to the main or sbl_main base address
#define AM_REG_INFO0_MAIN_PTR0_PTR0_S 0
#define AM_REG_INFO0_MAIN_PTR0_PTR0_M 0xFFFFFFFF
#define AM_REG_INFO0_MAIN_PTR0_PTR0(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// MAIN_PTR1 - This is the main/sbl_main firmware pointer 1 referenced by sbl_init for pointing to the main or sbl_main base address
#define AM_REG_INFO0_MAIN_PTR1_PTR1_S 0
#define AM_REG_INFO0_MAIN_PTR1_PTR1_M 0xFFFFFFFF
#define AM_REG_INFO0_MAIN_PTR1_PTR1(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// KREVTRACK - KEK Key Revocation Tracker. Monotonic counter where bits represents validity of a key index (each key index represents a 128b key in the keybank). Bit 31 represents first OEM key index (8) and bit 24 represents last OEM key index (15). Bits 0-23 are reserved. Example: To revoke KEK8, the INFO0:KREVTRACK would need to be updated to 0x7FFFFFFF.
#define AM_REG_INFO0_KREVTRACK_KTRCKER_S 24
#define AM_REG_INFO0_KREVTRACK_KTRCKER_M 0xFF000000
#define AM_REG_INFO0_KREVTRACK_KTRCKER(n) (((uint32_t)(n) << 24) & 0xFF000000)

// AREVTRACK - AUTH Key Revocation Tracker. Monotonic counter where bits represents validity of a key index (each key index represents a 128b key in the keybank). Bit 31 represents first OEM key index (8) and bit 24 represents last OEM key index (15). Bits 0-23 are reserved. Example: To revoke AUTH8, the INFO0:AREVTRACK would need to be updated to 0x7FFFFFFF.
#define AM_REG_INFO0_AREVTRACK_ATRCKER_S 0
#define AM_REG_INFO0_AREVTRACK_ATRCKER_M 0xFFFFFFFF
#define AM_REG_INFO0_AREVTRACK_ATRCKER(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// OTA_DESCRIPTOR - This field is used to track the OTA DESCRIPTOR pointer to ensure proper OTA update.
#define AM_REG_INFO0_OTA_DESCRIPTOR_DESCRIPTOR_S 0
#define AM_REG_INFO0_OTA_DESCRIPTOR_DESCRIPTOR_M 0xFFFFFFFF
#define AM_REG_INFO0_OTA_DESCRIPTOR_DESCRIPTOR(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// MAIN_CNT0 - Index counter for main or sbl_main firmware. Counter is used to indicate which pointer to reference, MAINPTR1 or MAINPTR2
#define AM_REG_INFO0_MAIN_CNT0_INDXCNTR_S 0
#define AM_REG_INFO0_MAIN_CNT0_INDXCNTR_M 0xFFFFFFFF
#define AM_REG_INFO0_MAIN_CNT0_INDXCNTR(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// MAIN_CNT1 - Index counter for main or sbl_main firmware. Counter is used to indicate which pointer to reference, MAINPTR1 or MAINPTR2
#define AM_REG_INFO0_MAIN_CNT1_INDXCNTR_S 0
#define AM_REG_INFO0_MAIN_CNT1_INDXCNTR_M 0xFFFFFFFF
#define AM_REG_INFO0_MAIN_CNT1_INDXCNTR(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W0 - This is the Customer KEK Word0. Keys are represented using key Index. Valid values for OEM key indices are 8-15. Each key index comprises of 128 bits (4 words) in the keybank, with words CUST_KEK_W0-3 representing key index 8, and so on.
#define AM_REG_INFO0_CUST_KEK_W0_CUSTKEK_W0_S 0
#define AM_REG_INFO0_CUST_KEK_W0_CUSTKEK_W0_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W0_CUSTKEK_W0(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W1 - This is the Customer KEK Word1.
#define AM_REG_INFO0_CUST_KEK_W1_CUSTKEK_W1_S 0
#define AM_REG_INFO0_CUST_KEK_W1_CUSTKEK_W1_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W1_CUSTKEK_W1(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W2 - This is the Customer KEK Word2.
#define AM_REG_INFO0_CUST_KEK_W2_CUSTKEK_W2_S 0
#define AM_REG_INFO0_CUST_KEK_W2_CUSTKEK_W2_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W2_CUSTKEK_W2(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W3 - This is the Customer KEK Word3.
#define AM_REG_INFO0_CUST_KEK_W3_CUSTKEK_W3_S 0
#define AM_REG_INFO0_CUST_KEK_W3_CUSTKEK_W3_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W3_CUSTKEK_W3(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W4 - This is the Customer KEK Word4.
#define AM_REG_INFO0_CUST_KEK_W4_CUSTKEK_W4_S 0
#define AM_REG_INFO0_CUST_KEK_W4_CUSTKEK_W4_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W4_CUSTKEK_W4(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W5 - This is the Customer KEK Word5.
#define AM_REG_INFO0_CUST_KEK_W5_CUSTKEK_W5_S 0
#define AM_REG_INFO0_CUST_KEK_W5_CUSTKEK_W5_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W5_CUSTKEK_W5(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W6 - This is the Customer KEK Word6.
#define AM_REG_INFO0_CUST_KEK_W6_CUSTKEK_W6_S 0
#define AM_REG_INFO0_CUST_KEK_W6_CUSTKEK_W6_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W6_CUSTKEK_W6(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W7 - This is the Customer KEK Word7.
#define AM_REG_INFO0_CUST_KEK_W7_CUSTKEK_W7_S 0
#define AM_REG_INFO0_CUST_KEK_W7_CUSTKEK_W7_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W7_CUSTKEK_W7(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W8 - This is the Customer KEK Word8.
#define AM_REG_INFO0_CUST_KEK_W8_CUSTKEK_W8_S 0
#define AM_REG_INFO0_CUST_KEK_W8_CUSTKEK_W8_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W8_CUSTKEK_W8(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W9 - This is the Customer KEK Word9.
#define AM_REG_INFO0_CUST_KEK_W9_CUSTKEK_W9_S 0
#define AM_REG_INFO0_CUST_KEK_W9_CUSTKEK_W9_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W9_CUSTKEK_W9(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W10 - This is the Customer KEK Word10.
#define AM_REG_INFO0_CUST_KEK_W10_CUSTKEK_W10_S 0
#define AM_REG_INFO0_CUST_KEK_W10_CUSTKEK_W10_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W10_CUSTKEK_W10(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W11 - This is the Customer KEK Word11.
#define AM_REG_INFO0_CUST_KEK_W11_CUSTKEK_W11_S 0
#define AM_REG_INFO0_CUST_KEK_W11_CUSTKEK_W11_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W11_CUSTKEK_W11(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W12 - This is the Customer KEK Word12.
#define AM_REG_INFO0_CUST_KEK_W12_CUSTKEK_W12_S 0
#define AM_REG_INFO0_CUST_KEK_W12_CUSTKEK_W12_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W12_CUSTKEK_W12(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W13 - This is the Customer KEK Word13.
#define AM_REG_INFO0_CUST_KEK_W13_CUSTKEK_W13_S 0
#define AM_REG_INFO0_CUST_KEK_W13_CUSTKEK_W13_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W13_CUSTKEK_W13(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W14 - This is the Customer KEK Word14.
#define AM_REG_INFO0_CUST_KEK_W14_CUSTKEK_W14_S 0
#define AM_REG_INFO0_CUST_KEK_W14_CUSTKEK_W14_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W14_CUSTKEK_W14(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W15 - This is the Customer KEK Word15.
#define AM_REG_INFO0_CUST_KEK_W15_CUSTKEK_W15_S 0
#define AM_REG_INFO0_CUST_KEK_W15_CUSTKEK_W15_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W15_CUSTKEK_W15(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W16 - This is the Customer KEK Word16.
#define AM_REG_INFO0_CUST_KEK_W16_CUSTKEK_W16_S 0
#define AM_REG_INFO0_CUST_KEK_W16_CUSTKEK_W16_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W16_CUSTKEK_W16(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W17 - This is the Customer KEK Word17.
#define AM_REG_INFO0_CUST_KEK_W17_CUSTKEK_W17_S 0
#define AM_REG_INFO0_CUST_KEK_W17_CUSTKEK_W17_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W17_CUSTKEK_W17(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W18 - This is the Customer KEK Word18.
#define AM_REG_INFO0_CUST_KEK_W18_CUSTKEK_W18_S 0
#define AM_REG_INFO0_CUST_KEK_W18_CUSTKEK_W18_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W18_CUSTKEK_W18(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W19 - This is the Customer KEK Word19.
#define AM_REG_INFO0_CUST_KEK_W19_CUSTKEK_W19_S 0
#define AM_REG_INFO0_CUST_KEK_W19_CUSTKEK_W19_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W19_CUSTKEK_W19(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W20 - This is the Customer KEK Word20.
#define AM_REG_INFO0_CUST_KEK_W20_CUSTKEK_W20_S 0
#define AM_REG_INFO0_CUST_KEK_W20_CUSTKEK_W20_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W20_CUSTKEK_W20(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W21 - This is the Customer KEK Word21.
#define AM_REG_INFO0_CUST_KEK_W21_CUSTKEK_W21_S 0
#define AM_REG_INFO0_CUST_KEK_W21_CUSTKEK_W21_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W21_CUSTKEK_W21(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W22 - This is the Customer KEK Word22.
#define AM_REG_INFO0_CUST_KEK_W22_CUSTKEK_W22_S 0
#define AM_REG_INFO0_CUST_KEK_W22_CUSTKEK_W22_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W22_CUSTKEK_W22(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W23 - This is the Customer KEK Word23.
#define AM_REG_INFO0_CUST_KEK_W23_CUSTKEK_W23_S 0
#define AM_REG_INFO0_CUST_KEK_W23_CUSTKEK_W23_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W23_CUSTKEK_W23(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W24 - This is the Customer KEK Word24.
#define AM_REG_INFO0_CUST_KEK_W24_CUSTKEK_W24_S 0
#define AM_REG_INFO0_CUST_KEK_W24_CUSTKEK_W24_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W24_CUSTKEK_W24(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W25 - This is the Customer KEK Word25.
#define AM_REG_INFO0_CUST_KEK_W25_CUSTKEK_W25_S 0
#define AM_REG_INFO0_CUST_KEK_W25_CUSTKEK_W25_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W25_CUSTKEK_W25(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W26 - This is the Customer KEK Word26.
#define AM_REG_INFO0_CUST_KEK_W26_CUSTKEK_W26_S 0
#define AM_REG_INFO0_CUST_KEK_W26_CUSTKEK_W26_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W26_CUSTKEK_W26(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W27 - This is the Customer KEK Word27.
#define AM_REG_INFO0_CUST_KEK_W27_CUSTKEK_W27_S 0
#define AM_REG_INFO0_CUST_KEK_W27_CUSTKEK_W27_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W27_CUSTKEK_W27(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W28 - This is the Customer KEK Word28.
#define AM_REG_INFO0_CUST_KEK_W28_CUSTKEK_W28_S 0
#define AM_REG_INFO0_CUST_KEK_W28_CUSTKEK_W28_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W28_CUSTKEK_W28(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W29 - This is the Customer KEK Word29.
#define AM_REG_INFO0_CUST_KEK_W29_CUSTKEK_W29_S 0
#define AM_REG_INFO0_CUST_KEK_W29_CUSTKEK_W29_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W29_CUSTKEK_W29(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W30 - This is the Customer KEK Word30.
#define AM_REG_INFO0_CUST_KEK_W30_CUSTKEK_W30_S 0
#define AM_REG_INFO0_CUST_KEK_W30_CUSTKEK_W30_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W30_CUSTKEK_W30(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_KEK_W31 - This is the Customer KEK Word31.
#define AM_REG_INFO0_CUST_KEK_W31_CUSTKEK_W31_S 0
#define AM_REG_INFO0_CUST_KEK_W31_CUSTKEK_W31_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_KEK_W31_CUSTKEK_W31(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W0 - This is the Customer AUTH Key Word0. Keys are represented using key Index. Valid values for OEM key indices are 8-15. Each key index comprises of 128 bits (4 words) in the keybank, with words CUST_AUTH_W0-3 representing key index 8, and so on.
#define AM_REG_INFO0_CUST_AUTH_W0_CUSTAUTH_W0_S 0
#define AM_REG_INFO0_CUST_AUTH_W0_CUSTAUTH_W0_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W0_CUSTAUTH_W0(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W1 - This is the Customer AUTH Key Word1.
#define AM_REG_INFO0_CUST_AUTH_W1_CUSTAUTH_W1_S 0
#define AM_REG_INFO0_CUST_AUTH_W1_CUSTAUTH_W1_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W1_CUSTAUTH_W1(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W2 - This is the Customer AUTH Key Word2.
#define AM_REG_INFO0_CUST_AUTH_W2_CUSTAUTH_W2_S 0
#define AM_REG_INFO0_CUST_AUTH_W2_CUSTAUTH_W2_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W2_CUSTAUTH_W2(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W3 - This is the Customer AUTH Key Word3.
#define AM_REG_INFO0_CUST_AUTH_W3_CUSTAUTH_W3_S 0
#define AM_REG_INFO0_CUST_AUTH_W3_CUSTAUTH_W3_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W3_CUSTAUTH_W3(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W4 - This is the Customer AUTH Key Word4.
#define AM_REG_INFO0_CUST_AUTH_W4_CUSTAUTH_W4_S 0
#define AM_REG_INFO0_CUST_AUTH_W4_CUSTAUTH_W4_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W4_CUSTAUTH_W4(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W5 - This is the Customer AUTH Key Word5.
#define AM_REG_INFO0_CUST_AUTH_W5_CUSTAUTH_W5_S 0
#define AM_REG_INFO0_CUST_AUTH_W5_CUSTAUTH_W5_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W5_CUSTAUTH_W5(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W6 - This is the Customer AUTH Key Word6.
#define AM_REG_INFO0_CUST_AUTH_W6_CUSTAUTH_W6_S 0
#define AM_REG_INFO0_CUST_AUTH_W6_CUSTAUTH_W6_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W6_CUSTAUTH_W6(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W7 - This is the Customer AUTH Key Word7.
#define AM_REG_INFO0_CUST_AUTH_W7_CUSTAUTH_W7_S 0
#define AM_REG_INFO0_CUST_AUTH_W7_CUSTAUTH_W7_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W7_CUSTAUTH_W7(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W8 - This is the Customer AUTH Key Word8.
#define AM_REG_INFO0_CUST_AUTH_W8_CUSTAUTH_W8_S 0
#define AM_REG_INFO0_CUST_AUTH_W8_CUSTAUTH_W8_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W8_CUSTAUTH_W8(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W9 - This is the Customer AUTH Key Word9.
#define AM_REG_INFO0_CUST_AUTH_W9_CUSTAUTH_W9_S 0
#define AM_REG_INFO0_CUST_AUTH_W9_CUSTAUTH_W9_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W9_CUSTAUTH_W9(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W10 - This is the Customer AUTH Key Word10.
#define AM_REG_INFO0_CUST_AUTH_W10_CUSTAUTH_W10_S 0
#define AM_REG_INFO0_CUST_AUTH_W10_CUSTAUTH_W10_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W10_CUSTAUTH_W10(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W11 - This is the Customer AUTH Key Word11.
#define AM_REG_INFO0_CUST_AUTH_W11_CUSTAUTH_W11_S 0
#define AM_REG_INFO0_CUST_AUTH_W11_CUSTAUTH_W11_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W11_CUSTAUTH_W11(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W12 - This is the Customer AUTH Key Word12.
#define AM_REG_INFO0_CUST_AUTH_W12_CUSTAUTH_W12_S 0
#define AM_REG_INFO0_CUST_AUTH_W12_CUSTAUTH_W12_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W12_CUSTAUTH_W12(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W13 - This is the Customer AUTH Key Word13.
#define AM_REG_INFO0_CUST_AUTH_W13_CUSTAUTH_W13_S 0
#define AM_REG_INFO0_CUST_AUTH_W13_CUSTAUTH_W13_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W13_CUSTAUTH_W13(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W14 - This is the Customer AUTH Key Word14.
#define AM_REG_INFO0_CUST_AUTH_W14_CUSTAUTH_W14_S 0
#define AM_REG_INFO0_CUST_AUTH_W14_CUSTAUTH_W14_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W14_CUSTAUTH_W14(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W15 - This is the Customer AUTH Key Word15.
#define AM_REG_INFO0_CUST_AUTH_W15_CUSTAUTH_W15_S 0
#define AM_REG_INFO0_CUST_AUTH_W15_CUSTAUTH_W15_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W15_CUSTAUTH_W15(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W16 - This is the Customer AUTH Key Word16.
#define AM_REG_INFO0_CUST_AUTH_W16_CUSTAUTH_W16_S 0
#define AM_REG_INFO0_CUST_AUTH_W16_CUSTAUTH_W16_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W16_CUSTAUTH_W16(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W17 - This is the Customer AUTH Key Word17.
#define AM_REG_INFO0_CUST_AUTH_W17_CUSTAUTH_W17_S 0
#define AM_REG_INFO0_CUST_AUTH_W17_CUSTAUTH_W17_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W17_CUSTAUTH_W17(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W18 - This is the Customer AUTH Key Word18.
#define AM_REG_INFO0_CUST_AUTH_W18_CUSTAUTH_W18_S 0
#define AM_REG_INFO0_CUST_AUTH_W18_CUSTAUTH_W18_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W18_CUSTAUTH_W18(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W19 - This is the Customer AUTH Key Word19.
#define AM_REG_INFO0_CUST_AUTH_W19_CUSTAUTH_W19_S 0
#define AM_REG_INFO0_CUST_AUTH_W19_CUSTAUTH_W19_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W19_CUSTAUTH_W19(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W20 - This is the Customer AUTH Key Word20.
#define AM_REG_INFO0_CUST_AUTH_W20_CUSTAUTH_W20_S 0
#define AM_REG_INFO0_CUST_AUTH_W20_CUSTAUTH_W20_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W20_CUSTAUTH_W20(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W21 - This is the Customer AUTH Key Word21.
#define AM_REG_INFO0_CUST_AUTH_W21_CUSTAUTH_W21_S 0
#define AM_REG_INFO0_CUST_AUTH_W21_CUSTAUTH_W21_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W21_CUSTAUTH_W21(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W22 - This is the Customer AUTH Key Word22.
#define AM_REG_INFO0_CUST_AUTH_W22_CUSTAUTH_W22_S 0
#define AM_REG_INFO0_CUST_AUTH_W22_CUSTAUTH_W22_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W22_CUSTAUTH_W22(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W23 - This is the Customer AUTH Key Word23.
#define AM_REG_INFO0_CUST_AUTH_W23_CUSTAUTH_W23_S 0
#define AM_REG_INFO0_CUST_AUTH_W23_CUSTAUTH_W23_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W23_CUSTAUTH_W23(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W24 - This is the Customer AUTH Key Word24.
#define AM_REG_INFO0_CUST_AUTH_W24_CUSTAUTH_W24_S 0
#define AM_REG_INFO0_CUST_AUTH_W24_CUSTAUTH_W24_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W24_CUSTAUTH_W24(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W25 - This is the Customer AUTH Key Word25.
#define AM_REG_INFO0_CUST_AUTH_W25_CUSTAUTH_W25_S 0
#define AM_REG_INFO0_CUST_AUTH_W25_CUSTAUTH_W25_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W25_CUSTAUTH_W25(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W26 - This is the Customer AUTH Key Word26.
#define AM_REG_INFO0_CUST_AUTH_W26_CUSTAUTH_W26_S 0
#define AM_REG_INFO0_CUST_AUTH_W26_CUSTAUTH_W26_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W26_CUSTAUTH_W26(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W27 - This is the Customer AUTH Key Word27.
#define AM_REG_INFO0_CUST_AUTH_W27_CUSTAUTH_W27_S 0
#define AM_REG_INFO0_CUST_AUTH_W27_CUSTAUTH_W27_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W27_CUSTAUTH_W27(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W28 - This is the Customer AUTH Key Word28.
#define AM_REG_INFO0_CUST_AUTH_W28_CUSTAUTH_W28_S 0
#define AM_REG_INFO0_CUST_AUTH_W28_CUSTAUTH_W28_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W28_CUSTAUTH_W28(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W29 - This is the Customer AUTH Key Word29.
#define AM_REG_INFO0_CUST_AUTH_W29_CUSTAUTH_W29_S 0
#define AM_REG_INFO0_CUST_AUTH_W29_CUSTAUTH_W29_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W29_CUSTAUTH_W29(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W30 - This is the Customer AUTH Key Word30.
#define AM_REG_INFO0_CUST_AUTH_W30_CUSTAUTH_W30_S 0
#define AM_REG_INFO0_CUST_AUTH_W30_CUSTAUTH_W30_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W30_CUSTAUTH_W30(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_AUTH_W31 - This is the Customer AUTH Key Word31.
#define AM_REG_INFO0_CUST_AUTH_W31_CUSTAUTH_W31_S 0
#define AM_REG_INFO0_CUST_AUTH_W31_CUSTAUTH_W31_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_AUTH_W31_CUSTAUTH_W31(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W0 - This is the Customer Public Key Word0.
#define AM_REG_INFO0_CUST_PUBKEY_W0_CUSTPUBKEY_W0_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W0_CUSTPUBKEY_W0_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W0_CUSTPUBKEY_W0(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W1 - This is the Customer Public Key Word1.
#define AM_REG_INFO0_CUST_PUBKEY_W1_CUSTPUBKEY_W1_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W1_CUSTPUBKEY_W1_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W1_CUSTPUBKEY_W1(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W2 - This is the Customer Public Key Word2.
#define AM_REG_INFO0_CUST_PUBKEY_W2_CUSTPUBKEY_W2_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W2_CUSTPUBKEY_W2_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W2_CUSTPUBKEY_W2(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W3 - This is the Customer Public Key Word3.
#define AM_REG_INFO0_CUST_PUBKEY_W3_CUSTPUBKEY_W3_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W3_CUSTPUBKEY_W3_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W3_CUSTPUBKEY_W3(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W4 - This is the Customer Public Key Word4.
#define AM_REG_INFO0_CUST_PUBKEY_W4_CUSTPUBKEY_W4_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W4_CUSTPUBKEY_W4_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W4_CUSTPUBKEY_W4(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W5 - This is the Customer Public Key Word5.
#define AM_REG_INFO0_CUST_PUBKEY_W5_CUSTPUBKEY_W5_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W5_CUSTPUBKEY_W5_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W5_CUSTPUBKEY_W5(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W6 - This is the Customer Public Key Word6.
#define AM_REG_INFO0_CUST_PUBKEY_W6_CUSTPUBKEY_W6_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W6_CUSTPUBKEY_W6_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W6_CUSTPUBKEY_W6(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W7 - This is the Customer Public Key Word7.
#define AM_REG_INFO0_CUST_PUBKEY_W7_CUSTPUBKEY_W7_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W7_CUSTPUBKEY_W7_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W7_CUSTPUBKEY_W7(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W8 - This is the Customer Public Key Word8.
#define AM_REG_INFO0_CUST_PUBKEY_W8_CUSTPUBKEY_W8_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W8_CUSTPUBKEY_W8_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W8_CUSTPUBKEY_W8(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W9 - This is the Customer Public Key Word9.
#define AM_REG_INFO0_CUST_PUBKEY_W9_CUSTPUBKEY_W9_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W9_CUSTPUBKEY_W9_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W9_CUSTPUBKEY_W9(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W10 - This is the Customer Public Key Word10.
#define AM_REG_INFO0_CUST_PUBKEY_W10_CUSTPUBKEY_W10_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W10_CUSTPUBKEY_W10_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W10_CUSTPUBKEY_W10(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W11 - This is the Customer Public Key Word11.
#define AM_REG_INFO0_CUST_PUBKEY_W11_CUSTPUBKEY_W11_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W11_CUSTPUBKEY_W11_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W11_CUSTPUBKEY_W11(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W12 - This is the Customer Public Key Word12.
#define AM_REG_INFO0_CUST_PUBKEY_W12_CUSTPUBKEY_W12_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W12_CUSTPUBKEY_W12_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W12_CUSTPUBKEY_W12(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W13 - This is the Customer Public Key Word13.
#define AM_REG_INFO0_CUST_PUBKEY_W13_CUSTPUBKEY_W13_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W13_CUSTPUBKEY_W13_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W13_CUSTPUBKEY_W13(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W14 - This is the Customer Public Key Word14.
#define AM_REG_INFO0_CUST_PUBKEY_W14_CUSTPUBKEY_W14_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W14_CUSTPUBKEY_W14_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W14_CUSTPUBKEY_W14(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W15 - This is the Customer Public Key Word15.
#define AM_REG_INFO0_CUST_PUBKEY_W15_CUSTPUBKEY_W15_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W15_CUSTPUBKEY_W15_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W15_CUSTPUBKEY_W15(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W16 - This is the Customer Public Key Word16.
#define AM_REG_INFO0_CUST_PUBKEY_W16_CUSTPUBKEY_W16_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W16_CUSTPUBKEY_W16_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W16_CUSTPUBKEY_W16(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W17 - This is the Customer Public Key Word17.
#define AM_REG_INFO0_CUST_PUBKEY_W17_CUSTPUBKEY_W17_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W17_CUSTPUBKEY_W17_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W17_CUSTPUBKEY_W17(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W18 - This is the Customer Public Key Word18.
#define AM_REG_INFO0_CUST_PUBKEY_W18_CUSTPUBKEY_W18_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W18_CUSTPUBKEY_W18_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W18_CUSTPUBKEY_W18(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W19 - This is the Customer Public Key Word19.
#define AM_REG_INFO0_CUST_PUBKEY_W19_CUSTPUBKEY_W19_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W19_CUSTPUBKEY_W19_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W19_CUSTPUBKEY_W19(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W20 - This is the Customer Public Key Word20.
#define AM_REG_INFO0_CUST_PUBKEY_W20_CUSTPUBKEY_W20_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W20_CUSTPUBKEY_W20_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W20_CUSTPUBKEY_W20(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W21 - This is the Customer Public Key Word21.
#define AM_REG_INFO0_CUST_PUBKEY_W21_CUSTPUBKEY_W21_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W21_CUSTPUBKEY_W21_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W21_CUSTPUBKEY_W21(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W22 - This is the Customer Public Key Word22.
#define AM_REG_INFO0_CUST_PUBKEY_W22_CUSTPUBKEY_W22_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W22_CUSTPUBKEY_W22_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W22_CUSTPUBKEY_W22(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W23 - This is the Customer Public Key Word23.
#define AM_REG_INFO0_CUST_PUBKEY_W23_CUSTPUBKEY_W23_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W23_CUSTPUBKEY_W23_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W23_CUSTPUBKEY_W23(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W24 - This is the Customer Public Key Word24.
#define AM_REG_INFO0_CUST_PUBKEY_W24_CUSTPUBKEY_W24_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W24_CUSTPUBKEY_W24_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W24_CUSTPUBKEY_W24(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W25 - This is the Customer Public Key Word25.
#define AM_REG_INFO0_CUST_PUBKEY_W25_CUSTPUBKEY_W25_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W25_CUSTPUBKEY_W25_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W25_CUSTPUBKEY_W25(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W26 - This is the Customer Public Key Word26.
#define AM_REG_INFO0_CUST_PUBKEY_W26_CUSTPUBKEY_W26_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W26_CUSTPUBKEY_W26_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W26_CUSTPUBKEY_W26(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W27 - This is the Customer Public Key Word27.
#define AM_REG_INFO0_CUST_PUBKEY_W27_CUSTPUBKEY_W27_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W27_CUSTPUBKEY_W27_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W27_CUSTPUBKEY_W27(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W28 - This is the Customer Public Key Word28.
#define AM_REG_INFO0_CUST_PUBKEY_W28_CUSTPUBKEY_W28_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W28_CUSTPUBKEY_W28_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W28_CUSTPUBKEY_W28(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W29 - This is the Customer Public Key Word29.
#define AM_REG_INFO0_CUST_PUBKEY_W29_CUSTPUBKEY_W29_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W29_CUSTPUBKEY_W29_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W29_CUSTPUBKEY_W29(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W30 - This is the Customer Public Key Word30.
#define AM_REG_INFO0_CUST_PUBKEY_W30_CUSTPUBKEY_W30_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W30_CUSTPUBKEY_W30_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W30_CUSTPUBKEY_W30(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W31 - This is the Customer Public Key Word31.
#define AM_REG_INFO0_CUST_PUBKEY_W31_CUSTPUBKEY_W31_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W31_CUSTPUBKEY_W31_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W31_CUSTPUBKEY_W31(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W32 - This is the Customer Public Key Word32.
#define AM_REG_INFO0_CUST_PUBKEY_W32_CUSTPUBKEY_W32_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W32_CUSTPUBKEY_W32_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W32_CUSTPUBKEY_W32(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W33 - This is the Customer Public Key Word33.
#define AM_REG_INFO0_CUST_PUBKEY_W33_CUSTPUBKEY_W33_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W33_CUSTPUBKEY_W33_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W33_CUSTPUBKEY_W33(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W34 - This is the Customer Public Key Word34.
#define AM_REG_INFO0_CUST_PUBKEY_W34_CUSTPUBKEY_W34_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W34_CUSTPUBKEY_W34_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W34_CUSTPUBKEY_W34(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W35 - This is the Customer Public Key Word35.
#define AM_REG_INFO0_CUST_PUBKEY_W35_CUSTPUBKEY_W35_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W35_CUSTPUBKEY_W35_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W35_CUSTPUBKEY_W35(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W36 - This is the Customer Public Key Word36.
#define AM_REG_INFO0_CUST_PUBKEY_W36_CUSTPUBKEY_W36_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W36_CUSTPUBKEY_W36_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W36_CUSTPUBKEY_W36(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W37 - This is the Customer Public Key Word37.
#define AM_REG_INFO0_CUST_PUBKEY_W37_CUSTPUBKEY_W37_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W37_CUSTPUBKEY_W37_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W37_CUSTPUBKEY_W37(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W38 - This is the Customer Public Key Word38.
#define AM_REG_INFO0_CUST_PUBKEY_W38_CUSTPUBKEY_W38_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W38_CUSTPUBKEY_W38_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W38_CUSTPUBKEY_W38(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W39 - This is the Customer Public Key Word39.
#define AM_REG_INFO0_CUST_PUBKEY_W39_CUSTPUBKEY_W39_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W39_CUSTPUBKEY_W39_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W39_CUSTPUBKEY_W39(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W40 - This is the Customer Public Key Word40.
#define AM_REG_INFO0_CUST_PUBKEY_W40_CUSTPUBKEY_W40_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W40_CUSTPUBKEY_W40_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W40_CUSTPUBKEY_W40(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W41 - This is the Customer Public Key Word41.
#define AM_REG_INFO0_CUST_PUBKEY_W41_CUSTPUBKEY_W41_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W41_CUSTPUBKEY_W41_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W41_CUSTPUBKEY_W41(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W42 - This is the Customer Public Key Word42.
#define AM_REG_INFO0_CUST_PUBKEY_W42_CUSTPUBKEY_W42_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W42_CUSTPUBKEY_W42_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W42_CUSTPUBKEY_W42(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W43 - This is the Customer Public Key Word43.
#define AM_REG_INFO0_CUST_PUBKEY_W43_CUSTPUBKEY_W43_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W43_CUSTPUBKEY_W43_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W43_CUSTPUBKEY_W43(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W44 - This is the Customer Public Key Word44.
#define AM_REG_INFO0_CUST_PUBKEY_W44_CUSTPUBKEY_W44_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W44_CUSTPUBKEY_W44_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W44_CUSTPUBKEY_W44(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W45 - This is the Customer Public Key Word45.
#define AM_REG_INFO0_CUST_PUBKEY_W45_CUSTPUBKEY_W45_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W45_CUSTPUBKEY_W45_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W45_CUSTPUBKEY_W45(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W46 - This is the Customer Public Key Word46.
#define AM_REG_INFO0_CUST_PUBKEY_W46_CUSTPUBKEY_W46_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W46_CUSTPUBKEY_W46_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W46_CUSTPUBKEY_W46(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W47 - This is the Customer Public Key Word47.
#define AM_REG_INFO0_CUST_PUBKEY_W47_CUSTPUBKEY_W47_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W47_CUSTPUBKEY_W47_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W47_CUSTPUBKEY_W47(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W48 - This is the Customer Public Key Word48.
#define AM_REG_INFO0_CUST_PUBKEY_W48_CUSTPUBKEY_W48_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W48_CUSTPUBKEY_W48_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W48_CUSTPUBKEY_W48(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W49 - This is the Customer Public Key Word49.
#define AM_REG_INFO0_CUST_PUBKEY_W49_CUSTPUBKEY_W49_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W49_CUSTPUBKEY_W49_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W49_CUSTPUBKEY_W49(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W50 - This is the Customer Public Key Word50.
#define AM_REG_INFO0_CUST_PUBKEY_W50_CUSTPUBKEY_W50_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W50_CUSTPUBKEY_W50_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W50_CUSTPUBKEY_W50(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W51 - This is the Customer Public Key Word51.
#define AM_REG_INFO0_CUST_PUBKEY_W51_CUSTPUBKEY_W51_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W51_CUSTPUBKEY_W51_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W51_CUSTPUBKEY_W51(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W52 - This is the Customer Public Key Word52.
#define AM_REG_INFO0_CUST_PUBKEY_W52_CUSTPUBKEY_W52_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W52_CUSTPUBKEY_W52_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W52_CUSTPUBKEY_W52(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W53 - This is the Customer Public Key Word53.
#define AM_REG_INFO0_CUST_PUBKEY_W53_CUSTPUBKEY_W53_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W53_CUSTPUBKEY_W53_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W53_CUSTPUBKEY_W53(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W54 - This is the Customer Public Key Word54.
#define AM_REG_INFO0_CUST_PUBKEY_W54_CUSTPUBKEY_W54_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W54_CUSTPUBKEY_W54_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W54_CUSTPUBKEY_W54(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W55 - This is the Customer Public Key Word55.
#define AM_REG_INFO0_CUST_PUBKEY_W55_CUSTPUBKEY_W55_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W55_CUSTPUBKEY_W55_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W55_CUSTPUBKEY_W55(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W56 - This is the Customer Public Key Word56.
#define AM_REG_INFO0_CUST_PUBKEY_W56_CUSTPUBKEY_W56_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W56_CUSTPUBKEY_W56_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W56_CUSTPUBKEY_W56(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W57 - This is the Customer Public Key Word57.
#define AM_REG_INFO0_CUST_PUBKEY_W57_CUSTPUBKEY_W57_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W57_CUSTPUBKEY_W57_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W57_CUSTPUBKEY_W57(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W58 - This is the Customer Public Key Word58.
#define AM_REG_INFO0_CUST_PUBKEY_W58_CUSTPUBKEY_W58_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W58_CUSTPUBKEY_W58_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W58_CUSTPUBKEY_W58(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W59 - This is the Customer Public Key Word59.
#define AM_REG_INFO0_CUST_PUBKEY_W59_CUSTPUBKEY_W59_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W59_CUSTPUBKEY_W59_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W59_CUSTPUBKEY_W59(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W60 - This is the Customer Public Key Word60.
#define AM_REG_INFO0_CUST_PUBKEY_W60_CUSTPUBKEY_W60_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W60_CUSTPUBKEY_W60_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W60_CUSTPUBKEY_W60(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W61 - This is the Customer Public Key Word61.
#define AM_REG_INFO0_CUST_PUBKEY_W61_CUSTPUBKEY_W61_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W61_CUSTPUBKEY_W61_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W61_CUSTPUBKEY_W61(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W62 - This is the Customer Public Key Word62.
#define AM_REG_INFO0_CUST_PUBKEY_W62_CUSTPUBKEY_W62_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W62_CUSTPUBKEY_W62_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W62_CUSTPUBKEY_W62(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBKEY_W63 - This is the Customer Public Key Word63.
#define AM_REG_INFO0_CUST_PUBKEY_W63_CUSTPUBKEY_W63_S 0
#define AM_REG_INFO0_CUST_PUBKEY_W63_CUSTPUBKEY_W63_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBKEY_W63_CUSTPUBKEY_W63(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUSTOMER_KEY0 - customer_key[31:0]
#define AM_REG_INFO0_CUSTOMER_KEY0_CHUNKS_S 0
#define AM_REG_INFO0_CUSTOMER_KEY0_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_CUSTOMER_KEY0_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUSTOMER_KEY1 - customer_key[63:32]
#define AM_REG_INFO0_CUSTOMER_KEY1_CHUNKS_S 0
#define AM_REG_INFO0_CUSTOMER_KEY1_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_CUSTOMER_KEY1_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUSTOMER_KEY2 - customer_key[95:64]
#define AM_REG_INFO0_CUSTOMER_KEY2_CHUNKS_S 0
#define AM_REG_INFO0_CUSTOMER_KEY2_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_CUSTOMER_KEY2_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUSTOMER_KEY3 - customer_key[127:96]
#define AM_REG_INFO0_CUSTOMER_KEY3_CHUNKS_S 0
#define AM_REG_INFO0_CUSTOMER_KEY3_CHUNKS_M 0xFFFFFFFF
#define AM_REG_INFO0_CUSTOMER_KEY3_CHUNKS(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBHASH_W0 - This is the Customer Public Key Hash Word0.
#define AM_REG_INFO0_CUST_PUBHASH_W0_CUSTPUBHASH_W0_S 0
#define AM_REG_INFO0_CUST_PUBHASH_W0_CUSTPUBHASH_W0_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBHASH_W0_CUSTPUBHASH_W0(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBHASH_W1 - This is the Customer Public Key Hash Word1.
#define AM_REG_INFO0_CUST_PUBHASH_W1_CUSTPUBHASH_W1_S 0
#define AM_REG_INFO0_CUST_PUBHASH_W1_CUSTPUBHASH_W1_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBHASH_W1_CUSTPUBHASH_W1(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBHASH_W2 - This is the Customer Public Key Hash Word2.
#define AM_REG_INFO0_CUST_PUBHASH_W2_CUSTPUBHASH_W2_S 0
#define AM_REG_INFO0_CUST_PUBHASH_W2_CUSTPUBHASH_W2_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBHASH_W2_CUSTPUBHASH_W2(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUST_PUBHASH_W3 - This is the Customer Public Key Hash Word3.
#define AM_REG_INFO0_CUST_PUBHASH_W3_CUSTPUBHASH_W3_S 0
#define AM_REG_INFO0_CUST_PUBHASH_W3_CUSTPUBHASH_W3_M 0xFFFFFFFF
#define AM_REG_INFO0_CUST_PUBHASH_W3_CUSTPUBHASH_W3(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

// CUSTID - This is the Ambiq assigned Customer ID. This field should be initialized with a unique (OEM spe- cific) value, supplied by Ambiq to as a precondition to enable Secure Boot support.
#define AM_REG_INFO0_CUSTID_CUSTID_S 0
#define AM_REG_INFO0_CUSTID_CUSTID_M 0xFFFFFFFF
#define AM_REG_INFO0_CUSTID_CUSTID(n) (((uint32_t)(n) << 0) & 0xFFFFFFFF)

#endif
