/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixProcessUtils
implements ProcessUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnixProcessUtils.class);
    private final int processKillCheckRetries;

    public UnixProcessUtils(int processKillCheckRetries) {
        this.processKillCheckRetries = processKillCheckRetries;
    }

    @Override
    public boolean isProcessRunning(Long pid) {
        if (pid == null) {
            LOGGER.error("Unable to get process status due to missing process id");
            return false;
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            String pidString = String.valueOf(pid);
            builder.command("ps", "-p", pidString);
            Process proc = builder.start();
            boolean running = false;
            try (InputStream in = proc.getInputStream();
                 InputStreamReader streamReader = new InputStreamReader(in);
                 BufferedReader reader = new BufferedReader(streamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().startsWith(pidString)) continue;
                    running = true;
                }
            }
            LOGGER.debug("Process with PID {} is {}running", (Object)pid, (Object)(running ? "" : "not "));
            return running;
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to determine if Process {} is running; assuming that it is not", (Object)pid);
            return false;
        }
    }

    @Override
    public void shutdownProcess(Long pid, String s, int gracefulShutdownSeconds) {
        long startWait = System.nanoTime();
        while (this.isProcessRunning(pid)) {
            LOGGER.info("Waiting for Apache MiNiFi to finish shutting down...");
            long waitNanos = System.nanoTime() - startWait;
            long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
            if (waitSeconds >= (long)gracefulShutdownSeconds || gracefulShutdownSeconds == 0) {
                if (!this.isProcessRunning(pid)) break;
                LOGGER.warn(s, (Object)gracefulShutdownSeconds);
                try {
                    this.killProcessTree(pid);
                }
                catch (IOException ioe) {
                    LOGGER.error("Failed to kill Process with PID {}", (Object)pid);
                }
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                RunMiNiFi.DEFAULT_LOGGER.warn("Thread interrupted while shutting down MiNiFi");
            }
        }
    }

    @Override
    public void killProcessTree(Long pid) throws IOException {
        LOGGER.debug("Killing Process Tree for PID {}", (Object)pid);
        List<Long> children = this.getChildProcesses(pid);
        LOGGER.debug("Children of PID {}: {}", (Object)pid, children);
        for (Long childPid : children) {
            this.killProcessTree(childPid);
        }
        Runtime.getRuntime().exec(new String[]{"kill", "-9", String.valueOf(pid)});
        int retries = this.processKillCheckRetries;
        while (this.isProcessRunning(pid)) {
            if (retries == 0) {
                throw new IOException("Failed to stop process. Process is still running after killing attempt with pid=" + pid);
            }
            LOGGER.warn("Process is still running after killing attempt with pid=" + pid);
            --retries;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                RunMiNiFi.DEFAULT_LOGGER.warn("Thread interrupted while waiting for killing process with pid=" + pid);
            }
        }
    }

    private List<Long> getChildProcesses(Long ppid) throws IOException {
        Process proc = Runtime.getRuntime().exec(new String[]{"ps", "-o", "pid", "--no-headers", "--ppid", String.valueOf(ppid)});
        ArrayList<Long> childPids = new ArrayList<Long>();
        try (InputStream in = proc.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    Long childPid = Long.valueOf(line.trim());
                    childPids.add(childPid);
                }
                catch (NumberFormatException e) {
                    LOGGER.trace("Failed to parse PID", (Throwable)e);
                }
            }
        }
        return childPids;
    }
}

