/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NegIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "-(I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends IntFunction
    implements UnaryFunction {
        final Function arg;

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            int value = this.arg.getInt(rec);
            return value != Integer.MIN_VALUE ? -value : Integer.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('-').val(this.arg);
        }
    }
}

