/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.Unsafe;
import java.util.concurrent.locks.LockSupport;

public class SOUnboundedCountDownLatch
implements CountDownLatchSPI {
    private static final long COUNT_OFFSET = Unsafe.getFieldOffset(SOUnboundedCountDownLatch.class, "count");
    private volatile int awaitedCount;
    private volatile int count;
    private volatile Thread waiter;

    public void await(int count) {
        this.awaitedCount = count;
        this.waiter = Thread.currentThread();
        while (this.count > -count) {
            LockSupport.park();
        }
    }

    @Override
    public void countDown() {
        int awaitedCount;
        int prevCount = Unsafe.getUnsafe().getAndAddInt(this, COUNT_OFFSET, -1);
        if (prevCount - 1 <= -(awaitedCount = this.awaitedCount)) {
            this.unparkWaiter();
        }
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
        this.awaitedCount = 0;
        this.waiter = null;
    }

    private void unparkWaiter() {
        Thread waiter = this.waiter;
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }
}

