/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.commons.schema.common.CommonPropertyKeys;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class ProcessorSchema
extends BaseSchemaWithIdAndName {
    public static final String PENALIZATION_PERIOD_KEY = "penalization period";
    public static final String RUN_DURATION_NANOS_KEY = "run duration nanos";
    public static final String AUTO_TERMINATED_RELATIONSHIPS_LIST_KEY = "auto-terminated relationships list";
    public static final int DEFAULT_MAX_CONCURRENT_TASKS = 1;
    public static final String DEFAULT_PENALIZATION_PERIOD = "30 sec";
    public static final String DEFAULT_YIELD_DURATION = "1 sec";
    public static final long DEFAULT_RUN_DURATION_NANOS = 0L;
    public static final List<String> DEFAULT_AUTO_TERMINATED_RELATIONSHIPS_LIST = Collections.emptyList();
    public static final String IT_IS_NOT_A_VALID_SCHEDULING_STRATEGY = "it is not a valid scheduling strategy";
    private String processorClass;
    private String schedulingStrategy;
    private String schedulingPeriod;
    private Number maxConcurrentTasks = 1;
    private String penalizationPeriod = "30 sec";
    private String yieldPeriod = "1 sec";
    private Number runDurationNanos = 0L;
    private List<String> autoTerminatedRelationshipsList = DEFAULT_AUTO_TERMINATED_RELATIONSHIPS_LIST;
    private Map<String, Object> properties = CommonPropertyKeys.DEFAULT_PROPERTIES;
    private String annotationData = "";

    public ProcessorSchema(Map map) {
        super(map, "Processor(id: {id}, name: {name})");
        String wrapperName = this.getWrapperName();
        this.processorClass = this.getRequiredKeyAsType(map, "class", String.class, wrapperName);
        this.schedulingStrategy = this.getRequiredKeyAsType(map, "scheduling strategy", String.class, wrapperName);
        if (this.schedulingStrategy != null && !ProcessorSchema.isSchedulingStrategy(this.schedulingStrategy)) {
            this.addValidationIssue("scheduling strategy", wrapperName, IT_IS_NOT_A_VALID_SCHEDULING_STRATEGY);
        }
        this.schedulingPeriod = this.getRequiredKeyAsType(map, "scheduling period", String.class, wrapperName);
        this.maxConcurrentTasks = this.getOptionalKeyAsType(map, "max concurrent tasks", Number.class, wrapperName, 1);
        this.penalizationPeriod = this.getOptionalKeyAsType(map, PENALIZATION_PERIOD_KEY, String.class, wrapperName, DEFAULT_PENALIZATION_PERIOD);
        this.yieldPeriod = this.getOptionalKeyAsType(map, "yield period", String.class, wrapperName, DEFAULT_YIELD_DURATION);
        this.runDurationNanos = this.getOptionalKeyAsType(map, RUN_DURATION_NANOS_KEY, Number.class, wrapperName, 0L);
        this.autoTerminatedRelationshipsList = this.getOptionalKeyAsType(map, AUTO_TERMINATED_RELATIONSHIPS_LIST_KEY, List.class, wrapperName, DEFAULT_AUTO_TERMINATED_RELATIONSHIPS_LIST);
        this.properties = this.getOptionalKeyAsType(map, "Properties", Map.class, wrapperName, CommonPropertyKeys.DEFAULT_PROPERTIES);
        this.annotationData = this.getOptionalKeyAsType(map, "annotation data", String.class, wrapperName, "");
    }

    public static boolean isSchedulingStrategy(String string) {
        try {
            SchedulingStrategy.valueOf((String)string);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put("class", this.processorClass);
        result.put("max concurrent tasks", this.maxConcurrentTasks);
        result.put("scheduling strategy", this.schedulingStrategy);
        result.put("scheduling period", this.schedulingPeriod);
        result.put(PENALIZATION_PERIOD_KEY, this.penalizationPeriod);
        result.put("yield period", this.yieldPeriod);
        result.put(RUN_DURATION_NANOS_KEY, this.runDurationNanos);
        result.put(AUTO_TERMINATED_RELATIONSHIPS_LIST_KEY, this.autoTerminatedRelationshipsList);
        result.put("Properties", new TreeMap<String, Object>(this.properties));
        if (this.annotationData != null && !this.annotationData.isEmpty()) {
            result.put("annotation data", this.annotationData);
        }
        return result;
    }

    public String getProcessorClass() {
        return this.processorClass;
    }

    public Number getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public String getPenalizationPeriod() {
        return this.penalizationPeriod;
    }

    public String getYieldPeriod() {
        return this.yieldPeriod;
    }

    public Number getRunDurationNanos() {
        return this.runDurationNanos;
    }

    public List<String> getAutoTerminatedRelationshipsList() {
        return this.autoTerminatedRelationshipsList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }
}

