/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.leader.election;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.nifi.controller.cluster.ZooKeeperClientConfig;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class CuratorACLProviderFactory {
    public static final String SASL_AUTH_SCHEME = "sasl";

    public ACLProvider create(ZooKeeperClientConfig config) {
        return StringUtils.equalsIgnoreCase((CharSequence)config.getAuthType(), (CharSequence)SASL_AUTH_SCHEME) ? new SaslACLProvider(config) : new DefaultACLProvider();
    }

    private class SaslACLProvider
    implements ACLProvider {
        private final List<ACL> acls;

        private SaslACLProvider(ZooKeeperClientConfig config) {
            StringBuilder principal;
            if (!StringUtils.isEmpty((CharSequence)config.getAuthPrincipal())) {
                String realm = config.getAuthPrincipal().substring(config.getAuthPrincipal().indexOf(64) + 1, config.getAuthPrincipal().length());
                String[] user = config.getAuthPrincipal().substring(0, config.getAuthPrincipal().indexOf(64)).split("/");
                String host = user.length == 2 ? user[1] : null;
                String instance = user[0];
                principal = new StringBuilder(instance);
                if (!config.getRemoveHostFromPrincipal().equalsIgnoreCase("true")) {
                    principal.append("/");
                    principal.append(host);
                }
                if (!config.getRemoveRealmFromPrincipal().equalsIgnoreCase("true")) {
                    principal.append("@");
                    principal.append(realm);
                }
            } else {
                throw new IllegalArgumentException("No Kerberos Principal configured for use with SASL Authentication Scheme");
            }
            this.acls = new ArrayList<ACL>(Arrays.asList(new ACL(31, new Id(CuratorACLProviderFactory.SASL_AUTH_SCHEME, principal.toString()))));
            this.acls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
        }

        public List<ACL> getDefaultAcl() {
            return this.acls;
        }

        public List<ACL> getAclForPath(String s) {
            return this.acls;
        }
    }
}

