/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.groups.DataValveDiagnostics;
import org.apache.nifi.groups.ProcessGroup;

public class DataValveDiagnosticsTask
implements DiagnosticTask {
    private final FlowManager flowManager;

    public DataValveDiagnosticsTask(FlowManager flowManager) {
        this.flowManager = flowManager;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        if (!verbose) {
            return null;
        }
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        List allGroups = rootGroup.findAllProcessGroups();
        allGroups.add(rootGroup);
        ArrayList<String> details = new ArrayList<String>();
        for (ProcessGroup group : allGroups) {
            DataValveDiagnostics valveDiagnostics = group.getDataValve().getDiagnostics();
            details.add("Process Group " + group.getIdentifier() + ", Name = " + group.getName());
            details.add("Currently Have Data Flowing In: " + valveDiagnostics.getGroupsWithDataFlowingIn());
            details.add("Currently Have Data Flowing Out: " + valveDiagnostics.getGroupsWithDataFlowingOut());
            details.add("Reason for Not allowing data to flow in:");
            for (Map.Entry entry : valveDiagnostics.getReasonForInputNotAllowed().entrySet()) {
                details.add("    " + (String)entry.getKey() + ":");
                ((List)entry.getValue()).forEach(pg -> details.add("        " + pg));
            }
            details.add("Reason for Not allowing data to flow out:");
            for (Map.Entry entry : valveDiagnostics.getReasonForOutputNotAllowed().entrySet()) {
                details.add("    " + (String)entry.getKey() + ":");
                ((List)entry.getValue()).forEach(pg -> details.add("        " + pg));
            }
            details.add("");
        }
        return new StandardDiagnosticsDumpElement("DataValve Diagnostics", details);
    }
}

