/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;

public final class CompressedUnsignedLongArrayByteIterable
extends ByteIterableBase {
    private final long[] longs;
    private final int size;
    private final int bytesPerLong;

    private CompressedUnsignedLongArrayByteIterable(long[] longs, int size) {
        if (size > longs.length) {
            throw new IllegalArgumentException();
        }
        this.longs = longs;
        this.size = size;
        int logarithm = 0;
        for (int i = 0; i < size; ++i) {
            long l = longs[i];
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            int log = CompressedUnsignedLongArrayByteIterable.logarithm(l);
            if (log <= logarithm) continue;
            logarithm = log;
        }
        this.bytesPerLong = logarithm;
    }

    public static ByteIterable getIterable(long[] longs) {
        return CompressedUnsignedLongArrayByteIterable.getIterable(longs, longs.length);
    }

    public static ByteIterable getIterable(long[] longs, int size) {
        return new CompressedUnsignedLongArrayByteIterable(longs, size);
    }

    public static int loadLongs(long[] output, ByteIterator iterator) {
        return CompressedUnsignedLongArrayByteIterable.loadLongs(output, iterator, output.length);
    }

    public static int loadLongs(long[] output, ByteIterator iterator, int size) {
        if (size > 0) {
            byte bytesPerLong = iterator.next();
            for (int i = 0; i < size; ++i) {
                output[i] = iterator.nextLong(bytesPerLong);
            }
            return bytesPerLong;
        }
        return 0;
    }

    public static int loadLongs(long[] output, ByteIterator iterator, int size, int bytesPerLong) {
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                output[i] = iterator.nextLong(bytesPerLong);
            }
            return bytesPerLong;
        }
        return 0;
    }

    public static int logarithm(long l) {
        int result = 0;
        do {
            ++result;
        } while ((l >>= 8) > 0L);
        return result;
    }

    @Override
    protected ByteIterator getIterator() {
        return this.size == 0 ? ByteIterable.EMPTY_ITERATOR : new ByteIterator(){
            private int i = -1;
            private int bits = 8;
            private long data = CompressedUnsignedLongArrayByteIterable.access$000(CompressedUnsignedLongArrayByteIterable.this);

            @Override
            public boolean hasNext() {
                return this.i < CompressedUnsignedLongArrayByteIterable.this.size - 1 || this.bits > 0;
            }

            @Override
            public byte next() {
                if (this.bits == 0) {
                    this.bits = CompressedUnsignedLongArrayByteIterable.this.bytesPerLong << 3;
                    this.data = CompressedUnsignedLongArrayByteIterable.this.longs[++this.i];
                }
                return (byte)(this.data >> (this.bits -= 8) & 0xFFL);
            }

            @Override
            public long skip(long bytes) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

