/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class CastDateToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ms)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.getQuick(0);
        if (func.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(func.getDate(null));
            return new StrConstant(Chars.toString(sink));
        }
        return new CastDateToStrFunction(args.getQuick(0));
    }

    public static class CastDateToStrFunction
    extends AbstractCastToStrFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public CastDateToStrFunction(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStr(Record rec) {
            long value = this.arg.getDate(rec);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            this.sinkA.clear();
            this.sinkA.putISODateMillis(value);
            return this.sinkA;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            long value = this.arg.getDate(rec);
            if (value == Long.MIN_VALUE) {
                return;
            }
            sink.putISODateMillis(value);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            long value = this.arg.getDate(rec);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            this.sinkB.clear();
            this.sinkB.putISODateMillis(value);
            return this.sinkB;
        }
    }
}

