/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.griffin.engine.functions.eq.EqStrFunctionFactory;
import io.questdb.std.NumericException;
import io.questdb.std.Uuid;
import org.jetbrains.annotations.Nullable;

final class UuidEqUtils {
    private UuidEqUtils() {
    }

    @Nullable
    static BooleanFunction eqStrUuid(Function strFun, Function uuidFun) {
        if (strFun.isConstant()) {
            long hi;
            long lo;
            CharSequence uuidStr = strFun.getStr(null);
            if (uuidStr == null) {
                lo = Long.MIN_VALUE;
                hi = Long.MIN_VALUE;
            } else {
                try {
                    Uuid.checkDashesAndLength(uuidStr);
                    lo = Uuid.parseLo(uuidStr);
                    hi = Uuid.parseHi(uuidStr);
                }
                catch (NumericException e) {
                    return BooleanConstant.FALSE;
                }
            }
            if (uuidFun.isConstant()) {
                return BooleanConstant.of(hi == uuidFun.getLong128Hi(null) && lo == uuidFun.getLong128Hi(null));
            }
            return new ConstStrFun(lo, hi, uuidFun);
        }
        if (uuidFun.isConstant()) {
            long hi;
            long lo = uuidFun.getLong128Lo(null);
            if (Uuid.isNull(lo, hi = uuidFun.getLong128Hi(null))) {
                return new EqStrFunctionFactory.NullCheckFunc(strFun);
            }
            return new ConstUuidFun(lo, hi, strFun);
        }
        return new Fun(strFun, uuidFun);
    }

    private static class Fun
    extends AbstractEqBinaryFunction
    implements BinaryFunction {
        private Fun(Function strFunction, Function uuidFunction) {
            super(strFunction, uuidFunction);
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence str = this.left.getStr(rec);
            long lo = this.right.getLong128Lo(rec);
            long hi = this.right.getLong128Hi(rec);
            if (str == null) {
                return this.negated != Uuid.isNull(lo, hi);
            }
            try {
                Uuid.checkDashesAndLength(str);
                return this.negated != (hi == Uuid.parseHi(str) && lo == Uuid.parseLo(str));
            }
            catch (NumericException e) {
                return this.negated;
            }
        }
    }

    private static class ConstUuidFun
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long constUuidHi;
        private final long constUuidLo;
        private final Function fun;

        private ConstUuidFun(long constUuidLo, long constUuidHi, Function fun) {
            this.constUuidLo = constUuidLo;
            this.constUuidHi = constUuidHi;
            this.fun = fun;
        }

        @Override
        public Function getArg() {
            return this.fun;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence uuidStr = this.fun.getStr(rec);
            if (uuidStr == null) {
                return this.negated != (this.constUuidHi == Long.MIN_VALUE && this.constUuidLo == Long.MIN_VALUE);
            }
            try {
                Uuid.checkDashesAndLength(uuidStr);
                return this.negated != (this.constUuidHi == Uuid.parseHi(uuidStr) && this.constUuidLo == Uuid.parseLo(uuidStr));
            }
            catch (NumericException e) {
                return this.negated;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.fun);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").valUuid(this.constUuidLo, this.constUuidHi).val('\'');
        }
    }

    private static class ConstStrFun
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long constStrHi;
        private final long constStrLo;
        private final Function fun;

        private ConstStrFun(long constStrLo, long constStrHi, Function fun) {
            this.constStrLo = constStrLo;
            this.constStrHi = constStrHi;
            this.fun = fun;
        }

        @Override
        public Function getArg() {
            return this.fun;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.constStrHi == this.fun.getLong128Hi(rec) && this.constStrLo == this.fun.getLong128Lo(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.fun);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").valUuid(this.constStrLo, this.constStrHi).val('\'');
        }
    }
}

