/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.nifi.diagnostics.GarbageCollection;
import org.apache.nifi.diagnostics.StorageUsage;

public class SystemDiagnostics
implements Cloneable {
    private long totalNonHeap;
    private long usedNonHeap;
    private long maxNonHeap;
    private long totalHeap;
    private long usedHeap;
    private long maxHeap;
    private int availableProcessors;
    private Double processorLoadAverage;
    private int totalThreads;
    private int daemonThreads;
    private long totalPhysicalMemory;
    private long maxOpenFileHandles;
    private long openFileHandles;
    private long uptime;
    private StorageUsage flowFileRepositoryStorageUsage;
    private Map<String, StorageUsage> contentRepositoryStorageUsage;
    private Map<String, StorageUsage> provenanceRepositoryStorageUsage;
    private Map<String, GarbageCollection> garbageCollection;
    private long creationTimestamp;

    public void setTotalNonHeap(long totalNonHeap) {
        this.totalNonHeap = totalNonHeap;
    }

    public void setUsedNonHeap(long usedNonHeap) {
        this.usedNonHeap = usedNonHeap;
    }

    public void setMaxNonHeap(long maxNonHeap) {
        this.maxNonHeap = maxNonHeap;
    }

    public void setTotalHeap(long totalHeap) {
        this.totalHeap = totalHeap;
    }

    public void setUsedHeap(long usedHeap) {
        this.usedHeap = usedHeap;
    }

    public void setMaxHeap(long maxHeap) {
        this.maxHeap = maxHeap;
    }

    public void setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    public void setProcessorLoadAverage(Double processorLoadAverage) {
        this.processorLoadAverage = processorLoadAverage;
    }

    public void setTotalThreads(int totalThreads) {
        this.totalThreads = totalThreads;
    }

    public void setDaemonThreads(int daemonThreads) {
        this.daemonThreads = daemonThreads;
    }

    public void setFlowFileRepositoryStorageUsage(StorageUsage flowFileRepositoryStorageUsage) {
        this.flowFileRepositoryStorageUsage = flowFileRepositoryStorageUsage;
    }

    public void setContentRepositoryStorageUsage(Map<String, StorageUsage> contentRepositoryStorageUsage) {
        this.contentRepositoryStorageUsage = contentRepositoryStorageUsage;
    }

    public void setProvenanceRepositoryStorageUsage(Map<String, StorageUsage> provenanceRepositoryStorageUsage) {
        this.provenanceRepositoryStorageUsage = provenanceRepositoryStorageUsage;
    }

    public long getTotalNonHeap() {
        return this.totalNonHeap;
    }

    public long getUsedNonHeap() {
        return this.usedNonHeap;
    }

    public long getMaxNonHeap() {
        return this.maxNonHeap;
    }

    public long getTotalHeap() {
        return this.totalHeap;
    }

    public long getUsedHeap() {
        return this.usedHeap;
    }

    public long getMaxHeap() {
        return this.maxHeap;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public Double getProcessorLoadAverage() {
        return this.processorLoadAverage;
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public int getDaemonThreads() {
        return this.daemonThreads;
    }

    public StorageUsage getFlowFileRepositoryStorageUsage() {
        return this.flowFileRepositoryStorageUsage;
    }

    public Map<String, StorageUsage> getContentRepositoryStorageUsage() {
        return this.contentRepositoryStorageUsage;
    }

    public Map<String, StorageUsage> getProvenanceRepositoryStorageUsage() {
        return this.provenanceRepositoryStorageUsage;
    }

    public long getFreeNonHeap() {
        return this.totalNonHeap - this.usedNonHeap;
    }

    public long getFreeHeap() {
        return this.totalHeap - this.usedHeap;
    }

    public int getHeapUtilization() {
        if (this.maxHeap == -1L) {
            return -1;
        }
        return Math.round((float)this.usedHeap / (float)this.maxHeap * 100.0f);
    }

    public int getNonHeapUtilization() {
        if (this.maxNonHeap == -1L) {
            return -1;
        }
        return Math.round((float)this.usedNonHeap / (float)this.maxNonHeap * 100.0f);
    }

    public Map<String, GarbageCollection> getGarbageCollection() {
        return this.garbageCollection;
    }

    public void setGarbageCollection(Map<String, GarbageCollection> garbageCollection) {
        this.garbageCollection = garbageCollection;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public long getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public void setTotalPhysicalMemory(long totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
    }

    public long getMaxOpenFileHandles() {
        return this.maxOpenFileHandles;
    }

    public void setMaxOpenFileHandles(long maxOpenFileHandles) {
        this.maxOpenFileHandles = maxOpenFileHandles;
    }

    public long getOpenFileHandles() {
        return this.openFileHandles;
    }

    public void setOpenFileHandles(long openFileHandles) {
        this.openFileHandles = openFileHandles;
    }

    public SystemDiagnostics clone() {
        LinkedHashMap<String, StorageUsage> clonedMap;
        SystemDiagnostics clonedObj = new SystemDiagnostics();
        clonedObj.availableProcessors = this.availableProcessors;
        clonedObj.daemonThreads = this.daemonThreads;
        if (this.flowFileRepositoryStorageUsage != null) {
            clonedObj.flowFileRepositoryStorageUsage = this.flowFileRepositoryStorageUsage.clone();
        }
        if (this.contentRepositoryStorageUsage != null) {
            clonedMap = new LinkedHashMap<String, StorageUsage>();
            clonedObj.setContentRepositoryStorageUsage(clonedMap);
            for (Map.Entry<String, StorageUsage> entry : this.contentRepositoryStorageUsage.entrySet()) {
                clonedMap.put(entry.getKey(), entry.getValue().clone());
            }
        }
        if (this.provenanceRepositoryStorageUsage != null) {
            clonedMap = new LinkedHashMap();
            clonedObj.setProvenanceRepositoryStorageUsage(clonedMap);
            for (Map.Entry<String, Cloneable> entry : this.provenanceRepositoryStorageUsage.entrySet()) {
                clonedMap.put(entry.getKey(), ((StorageUsage)entry.getValue()).clone());
            }
        }
        if (this.garbageCollection != null) {
            clonedMap = new LinkedHashMap();
            clonedObj.setGarbageCollection(clonedMap);
            for (Map.Entry<String, Cloneable> entry : this.garbageCollection.entrySet()) {
                clonedMap.put(entry.getKey(), (StorageUsage)((Object)((GarbageCollection)entry.getValue()).clone()));
            }
        }
        clonedObj.maxHeap = this.maxHeap;
        clonedObj.maxNonHeap = this.maxNonHeap;
        clonedObj.processorLoadAverage = this.processorLoadAverage;
        clonedObj.totalHeap = this.totalHeap;
        clonedObj.totalNonHeap = this.totalNonHeap;
        clonedObj.totalThreads = this.totalThreads;
        clonedObj.usedHeap = this.usedHeap;
        clonedObj.usedNonHeap = this.usedNonHeap;
        clonedObj.creationTimestamp = this.creationTimestamp;
        clonedObj.uptime = this.uptime;
        clonedObj.totalPhysicalMemory = this.totalPhysicalMemory;
        clonedObj.openFileHandles = this.openFileHandles;
        clonedObj.maxOpenFileHandles = this.maxOpenFileHandles;
        return clonedObj;
    }
}

