/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.ResourceClaimReference;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentRepositoryScanTask
implements DiagnosticTask {
    private static final Logger logger = LoggerFactory.getLogger(ContentRepositoryScanTask.class);
    private final FlowController flowController;

    public ContentRepositoryScanTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        if (!verbose) {
            return null;
        }
        ContentRepository contentRepository = this.flowController.getRepositoryContextFactory().getContentRepository();
        if (!contentRepository.isActiveResourceClaimsSupported()) {
            return new StandardDiagnosticsDumpElement("Content Repository Scan", Collections.singletonList("Current Content Repository does not support scanning for in-use content"));
        }
        FlowFileRepository flowFileRepository = this.flowController.getRepositoryContextFactory().getFlowFileRepository();
        ResourceClaimManager resourceClaimManager = this.flowController.getResourceClaimManager();
        FlowFileSwapManager swapManager = this.flowController.createSwapManager();
        ArrayList<String> details = new ArrayList<String>();
        HashMap<String, RetainedFileSet> retainedFileSetsByQueue = new HashMap<String, RetainedFileSet>();
        FlowManager flowManager = this.flowController.getFlowManager();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        for (Object containerName : contentRepository.getContainerNames()) {
            try {
                Set resourceClaims = contentRepository.getActiveResourceClaims((String)containerName);
                Map referenceMap = flowFileRepository.findResourceClaimReferences(resourceClaims, swapManager);
                for (ResourceClaim resourceClaim : resourceClaims) {
                    int claimCount = resourceClaimManager.getClaimantCount(resourceClaim);
                    boolean inUse = resourceClaim.isInUse();
                    boolean destructable = resourceClaimManager.isDestructable(resourceClaim);
                    Set<ResourceClaimReference> references = referenceMap == null ? Collections.emptySet() : referenceMap.getOrDefault(resourceClaim, Collections.emptySet());
                    String path = resourceClaim.getContainer() + "/" + resourceClaim.getSection() + "/" + resourceClaim.getId();
                    long fileSize = contentRepository.size(resourceClaim);
                    details.add(String.format("%1$s; Size = %2$s bytes; Claimant Count = %3$d; In Use = %4$b; Awaiting Destruction = %5$b; References (%6$d) = %7$s", path, numberFormat.format(fileSize), claimCount, inUse, destructable, references.size(), references));
                    for (ResourceClaimReference claimReference : references) {
                        String queueId = claimReference.getQueueIdentifier();
                        Connection connection = flowManager.getConnection(queueId);
                        QueueSize queueSize = new QueueSize(0, 0L);
                        if (connection != null) {
                            queueSize = connection.getFlowFileQueue().size();
                        }
                        RetainedFileSet retainedFileSet = retainedFileSetsByQueue.computeIfAbsent(queueId, RetainedFileSet::new);
                        retainedFileSet.addFile(path, fileSize);
                        retainedFileSet.setQueueSize(queueSize);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to obtain listing of Active Resource Claims for container {}", containerName, (Object)e);
                details.add("Failed to obtain listing of Active Resource Claims in container " + (String)containerName);
            }
        }
        details.add("");
        Set orphanedResourceClaims = flowFileRepository.findOrphanedResourceClaims();
        if (orphanedResourceClaims == null || orphanedResourceClaims.isEmpty()) {
            details.add("No Resource Claims were referenced by orphaned FlowFiles.");
        } else {
            details.add("The following Resource Claims were referenced by orphaned FlowFiles (FlowFiles that exist in the FlowFile Repository but for which the FlowFile's connection/queue did not exist when NiFi started):");
            for (ResourceClaim claim : orphanedResourceClaims) {
                details.add(claim.toString());
            }
        }
        details.add("");
        ArrayList retainedFileSets = new ArrayList(retainedFileSetsByQueue.values());
        retainedFileSets.sort(Comparator.comparing(RetainedFileSet::getByteCount).reversed());
        details.add("The following queues retain data in the Content Repository:");
        if (retainedFileSets.isEmpty()) {
            details.add("No queues retain any files in the Content Repository");
        } else {
            for (RetainedFileSet retainedFileSet : retainedFileSets) {
                String formatted = String.format("Queue ID = %s; Queue Size = %s FlowFiles / %s; Retained Files = %d; Retained Size = %s bytes (%s)", retainedFileSet.getQueueId(), numberFormat.format(retainedFileSet.getQueueSize().getObjectCount()), FormatUtils.formatDataSize((double)retainedFileSet.getQueueSize().getByteCount()), retainedFileSet.getFilenames().size(), numberFormat.format(retainedFileSet.getByteCount()), FormatUtils.formatDataSize((double)retainedFileSet.getByteCount()));
                details.add(formatted);
            }
        }
        return new StandardDiagnosticsDumpElement("Content Repository Scan", details);
    }

    private static class RetainedFileSet {
        private final String queueId;
        private final Set<String> filenames = new HashSet<String>();
        private long byteCount;
        private QueueSize queueSize;

        public RetainedFileSet(String queueId) {
            this.queueId = queueId;
        }

        public String getQueueId() {
            return this.queueId;
        }

        public void addFile(String filename, long bytes) {
            if (this.filenames.add(filename)) {
                this.byteCount += bytes;
            }
        }

        public Set<String> getFilenames() {
            return this.filenames;
        }

        public long getByteCount() {
            return this.byteCount;
        }

        public QueueSize getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(QueueSize queueSize) {
            this.queueSize = queueSize;
        }
    }
}

