/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public final class WebSessionOAuth2ServerAuthorizationRequestRepository
implements ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    private static final String DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME = WebSessionOAuth2ServerAuthorizationRequestRepository.class.getName() + ".AUTHORIZATION_REQUEST";
    private final String sessionAttributeName = DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME;
    private boolean allowMultipleAuthorizationRequests;

    @Override
    public Mono<OAuth2AuthorizationRequest> loadAuthorizationRequest(ServerWebExchange exchange) {
        String state = this.getStateParameter(exchange);
        if (state == null) {
            return Mono.empty();
        }
        return this.getSessionAttributes(exchange).filter(sessionAttrs -> sessionAttrs.containsKey(this.sessionAttributeName)).map(this::getAuthorizationRequests).filter(stateToAuthorizationRequest -> stateToAuthorizationRequest.containsKey(state)).map(stateToAuthorizationRequest -> (OAuth2AuthorizationRequest)stateToAuthorizationRequest.get(state));
    }

    @Override
    public Mono<Void> saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, ServerWebExchange exchange) {
        Assert.notNull((Object)authorizationRequest, (String)"authorizationRequest cannot be null");
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return this.getSessionAttributes(exchange).doOnNext(sessionAttrs -> {
            if (this.allowMultipleAuthorizationRequests) {
                Map<String, OAuth2AuthorizationRequest> authorizationRequests = this.getAuthorizationRequests((Map<String, Object>)sessionAttrs);
                authorizationRequests.put(authorizationRequest.getState(), authorizationRequest);
                sessionAttrs.put(this.sessionAttributeName, authorizationRequests);
            } else {
                sessionAttrs.put(this.sessionAttributeName, authorizationRequest);
            }
        }).then();
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> removeAuthorizationRequest(ServerWebExchange exchange) {
        String state = this.getStateParameter(exchange);
        if (state == null) {
            return Mono.empty();
        }
        return this.getSessionAttributes(exchange).flatMap(sessionAttrs -> {
            Map<String, OAuth2AuthorizationRequest> authorizationRequests = this.getAuthorizationRequests((Map<String, Object>)sessionAttrs);
            OAuth2AuthorizationRequest originalRequest = authorizationRequests.remove(state);
            if (authorizationRequests.isEmpty()) {
                sessionAttrs.remove(this.sessionAttributeName);
            } else if (authorizationRequests.size() == 1) {
                sessionAttrs.put(this.sessionAttributeName, authorizationRequests.values().iterator().next());
            } else {
                sessionAttrs.put(this.sessionAttributeName, authorizationRequests);
            }
            return Mono.justOrEmpty((Object)originalRequest);
        });
    }

    private String getStateParameter(ServerWebExchange exchange) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return (String)exchange.getRequest().getQueryParams().getFirst((Object)"state");
    }

    private Mono<Map<String, Object>> getSessionAttributes(ServerWebExchange exchange) {
        return exchange.getSession().map(WebSession::getAttributes);
    }

    private Map<String, OAuth2AuthorizationRequest> getAuthorizationRequests(Map<String, Object> sessionAttrs) {
        Object sessionAttributeValue = sessionAttrs.get(this.sessionAttributeName);
        if (sessionAttributeValue == null) {
            return new HashMap<String, OAuth2AuthorizationRequest>();
        }
        if (sessionAttributeValue instanceof OAuth2AuthorizationRequest) {
            OAuth2AuthorizationRequest oauth2AuthorizationRequest = (OAuth2AuthorizationRequest)sessionAttributeValue;
            HashMap<String, OAuth2AuthorizationRequest> authorizationRequests = new HashMap<String, OAuth2AuthorizationRequest>(1);
            authorizationRequests.put(oauth2AuthorizationRequest.getState(), oauth2AuthorizationRequest);
            return authorizationRequests;
        }
        if (sessionAttributeValue instanceof Map) {
            Map authorizationRequests = (Map)sessionAttrs.get(this.sessionAttributeName);
            return authorizationRequests;
        }
        throw new IllegalStateException("authorizationRequests is supposed to be a Map or OAuth2AuthorizationRequest but actually is a " + sessionAttributeValue.getClass());
    }

    @Deprecated
    public void setAllowMultipleAuthorizationRequests(boolean allowMultipleAuthorizationRequests) {
        this.allowMultipleAuthorizationRequests = allowMultipleAuthorizationRequests;
    }
}

