/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqBooleanCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(Ta)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), (args.getQuick(1).getChar(null) | 0x20) == 116);
    }

    private static class Func
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function left;
        private final boolean right;

        public Func(Function left, boolean right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getBool(rec) == this.right);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val('!');
            }
            sink.val('=').val(this.right);
        }
    }
}

