/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key.command;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.UUID;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.SignerListener;
import org.apache.nifi.web.security.jwt.key.VerificationKeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGenerationCommand
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyGenerationCommand.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 4096;
    private static final JWSAlgorithm JWS_ALGORITHM = JWSAlgorithm.PS512;
    private final KeyPairGenerator keyPairGenerator;
    private final SignerListener signerListener;
    private final VerificationKeyListener verificationKeyListener;

    public KeyGenerationCommand(SignerListener signerListener, VerificationKeyListener verificationKeyListener) {
        this.signerListener = Objects.requireNonNull(signerListener, "Signer Listener required");
        this.verificationKeyListener = Objects.requireNonNull(verificationKeyListener, "Verification Key Listener required");
        try {
            this.keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            this.keyPairGenerator.initialize(4096, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        String keyIdentifier = UUID.randomUUID().toString();
        LOGGER.debug("Generated Key Pair [{}] Key Identifier [{}]", (Object)KEY_ALGORITHM, (Object)keyIdentifier);
        this.verificationKeyListener.onVerificationKeyGenerated(keyIdentifier, keyPair.getPublic());
        RSASSASigner jwsSigner = new RSASSASigner(keyPair.getPrivate());
        this.signerListener.onSignerUpdated(new JwsSignerContainer(keyIdentifier, JWS_ALGORITHM, (JWSSigner)jwsSigner));
    }
}

