/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;

@Order(value=2147478547)
class InitializeAuthenticationProviderBeanManagerConfigurer
extends GlobalAuthenticationConfigurerAdapter {
    static final int DEFAULT_ORDER = 2147478547;
    private final ApplicationContext context;

    InitializeAuthenticationProviderBeanManagerConfigurer(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void init(AuthenticationManagerBuilder auth) throws Exception {
        auth.apply(new InitializeAuthenticationProviderManagerConfigurer());
    }

    class InitializeAuthenticationProviderManagerConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        private final Log logger = LogFactory.getLog(this.getClass());

        InitializeAuthenticationProviderManagerConfigurer() {
        }

        @Override
        public void configure(AuthenticationManagerBuilder auth) {
            if (auth.isConfigured()) {
                return;
            }
            List<BeanWithName<AuthenticationProvider>> authenticationProviders = this.getBeansWithName(AuthenticationProvider.class);
            if (authenticationProviders.isEmpty()) {
                return;
            }
            if (authenticationProviders.size() > 1) {
                List<String> beanNames = authenticationProviders.stream().map(BeanWithName::getName).toList();
                this.logger.info((Object)LogMessage.format((String)"Found %s AuthenticationProvider beans, with names %s. Global Authentication Manager will not be configured with AuthenticationProviders. Consider publishing a single AuthenticationProvider bean, or wiring your Providers directly using the DSL.", (Object)authenticationProviders.size(), beanNames));
                return;
            }
            AuthenticationProvider authenticationProvider = authenticationProviders.get(0).getBean();
            String authenticationProviderBeanName = authenticationProviders.get(0).getName();
            auth.authenticationProvider(authenticationProvider);
            this.logger.info((Object)LogMessage.format((String)"Global AuthenticationManager configured with AuthenticationProvider bean with name %s", (Object)authenticationProviderBeanName));
        }

        private <T> List<BeanWithName<T>> getBeansWithName(Class<T> type) {
            String[] beanNames;
            ArrayList<BeanWithName<T>> beanWithNames = new ArrayList<BeanWithName<T>>();
            for (String beanName : beanNames = InitializeAuthenticationProviderBeanManagerConfigurer.this.context.getBeanNamesForType(type)) {
                Object bean = InitializeAuthenticationProviderBeanManagerConfigurer.this.context.getBean(beanName, type);
                beanWithNames.add(new BeanWithName<Object>(bean, beanName));
            }
            return beanWithNames;
        }

        static class BeanWithName<T> {
            private final T bean;
            private final String name;

            BeanWithName(T bean, String name) {
                this.bean = bean;
                this.name = name;
            }

            T getBean() {
                return this.bean;
            }

            String getName() {
                return this.name;
            }
        }
    }
}

