/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.bucket;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.authorization.Tenant;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.PoliciesClient;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.command.registry.tenant.TenantHelper;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.util.StringUtils;

public class UpdateBucketPolicy
extends AbstractNiFiRegistryCommand<StringResult> {
    public UpdateBucketPolicy() {
        super("update-bucket-policy", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates access policy of bucket, NOTE: Overwrites the users/user-groups in the specified policy";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.USER_NAME_LIST.createOption());
        this.addOption(CommandOption.USER_ID_LIST.createOption());
        this.addOption(CommandOption.GROUP_NAME_LIST.createOption());
        this.addOption(CommandOption.GROUP_ID_LIST.createOption());
        this.addOption(CommandOption.POLICY_ACTION.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        AccessPolicy accessPolicy;
        PoliciesClient policiesClient = client.getPoliciesClient();
        String bucketName = this.getArg(properties, CommandOption.BUCKET_NAME);
        String bucketId = this.getArg(properties, CommandOption.BUCKET_ID);
        String userNames = this.getArg(properties, CommandOption.USER_NAME_LIST);
        String userIds = this.getArg(properties, CommandOption.USER_ID_LIST);
        String groupNames = this.getArg(properties, CommandOption.GROUP_NAME_LIST);
        String groupIds = this.getArg(properties, CommandOption.GROUP_ID_LIST);
        String policyAction = this.getRequiredArg(properties, CommandOption.POLICY_ACTION);
        Set<String> permittedActions = Set.of("read", "write", "delete");
        if (!permittedActions.contains(policyAction)) {
            throw new IllegalArgumentException("Only read, write, delete actions permitted");
        }
        if (StringUtils.isBlank((String)bucketName) == StringUtils.isBlank((String)bucketId)) {
            throw new IllegalArgumentException("Specify either bucket name or bucket id");
        }
        if (StringUtils.isBlank((String)bucketId)) {
            Optional<Bucket> optionalBucket = client.getBucketClient().getAll().stream().filter(b -> bucketName.equals(b.getName())).findAny();
            if (!optionalBucket.isPresent()) {
                throw new IllegalArgumentException("Specified bucket does not exist");
            }
            bucketId = optionalBucket.get().getIdentifier();
        } else {
            try {
                client.getBucketClient().get(bucketId);
            }
            catch (NiFiRegistryException e) {
                throw new IllegalArgumentException("Specified bucket does not exist");
            }
        }
        String resource = "/buckets/" + bucketId;
        try {
            accessPolicy = policiesClient.getAccessPolicy(policyAction, resource);
        }
        catch (NiFiRegistryException e) {
            accessPolicy = new AccessPolicy();
            accessPolicy.setResource(resource);
            accessPolicy.setAction(policyAction);
        }
        if (!StringUtils.isBlank((String)userNames) || !StringUtils.isBlank((String)userIds)) {
            Set<Tenant> users = TenantHelper.selectExistingTenants(userNames, userIds, client.getTenantsClient().getUsers());
            accessPolicy.setUsers(users);
        }
        if (!StringUtils.isBlank((String)groupNames) || !StringUtils.isBlank((String)groupIds)) {
            Set<Tenant> groups = TenantHelper.selectExistingTenants(groupNames, groupIds, client.getTenantsClient().getUserGroups());
            accessPolicy.setUserGroups(groups);
        }
        AccessPolicy updatedPolicy = StringUtils.isBlank((String)accessPolicy.getIdentifier()) ? policiesClient.createAccessPolicy(accessPolicy) : policiesClient.updateAccessPolicy(accessPolicy);
        return new StringResult(updatedPolicy.getIdentifier(), this.getContext().isInteractive());
    }
}

