/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.commons.collections.set.MapBackedSet;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.ImplHelper;

public abstract class AbstractChangeTracker
implements ChangeTracker {
    protected Collection add = null;
    protected Collection rem = null;
    protected Collection change = null;
    private boolean _autoOff = true;
    private boolean _track = false;
    private Boolean _identity = null;
    private int _seq = -1;

    public boolean getAutoOff() {
        return this._autoOff;
    }

    public void setAutoOff(boolean autoOff) {
        this._autoOff = autoOff;
    }

    @Override
    public boolean isTracking() {
        return this._track;
    }

    @Override
    public void startTracking() {
        this._track = true;
        if (this._seq == -1) {
            this._seq = this.initialSequence();
        }
        this.reset();
    }

    protected int initialSequence() {
        return 0;
    }

    @Override
    public void stopTracking() {
        this._track = false;
        this._seq = -1;
        this.reset();
    }

    protected void reset() {
        if (this.add != null) {
            this.add.clear();
        }
        if (this.rem != null) {
            this.rem.clear();
        }
        if (this.change != null) {
            this.change.clear();
        }
        this._identity = null;
    }

    @Override
    public Collection getAdded() {
        return this.add == null ? Collections.EMPTY_LIST : this.add;
    }

    @Override
    public Collection getRemoved() {
        return this.rem == null ? Collections.EMPTY_LIST : this.rem;
    }

    @Override
    public Collection getChanged() {
        return this.change == null ? Collections.EMPTY_LIST : this.change;
    }

    protected void added(Object val) {
        if (!this._track) {
            return;
        }
        this.setIdentity(val);
        this.add(val);
    }

    protected abstract void add(Object var1);

    protected void removed(Object val) {
        if (!this._track) {
            return;
        }
        this.setIdentity(val);
        this.remove(val);
    }

    protected abstract void remove(Object var1);

    protected void changed(Object val) {
        if (!this._track) {
            return;
        }
        this.setIdentity(val);
        this.change(val);
    }

    protected abstract void change(Object var1);

    @Override
    public int getNextSequence() {
        return this._seq;
    }

    @Override
    public void setNextSequence(int seq) {
        this._seq = seq;
    }

    protected Set newSet() {
        if (this._identity == Boolean.TRUE) {
            return MapBackedSet.decorate(new IdentityHashMap());
        }
        return new HashSet();
    }

    private void setIdentity(Object val) {
        if (val == null || this._identity != null) {
            return;
        }
        this._identity = ImplHelper.isManagedType(null, val.getClass()) ? Boolean.TRUE : Boolean.FALSE;
        this.add = AbstractChangeTracker.switchStructure(this.add, this._identity);
        this.rem = AbstractChangeTracker.switchStructure(this.rem, this._identity);
        this.change = AbstractChangeTracker.switchStructure(this.change, this._identity);
    }

    private static Collection switchStructure(Collection cur, boolean identity) {
        if (cur == null) {
            return null;
        }
        if (identity && cur instanceof HashSet) {
            if (cur.isEmpty()) {
                return null;
            }
            Set replace = MapBackedSet.decorate(new IdentityHashMap());
            replace.addAll(cur);
            return replace;
        }
        if (!identity && !(cur instanceof HashSet) && cur instanceof Set) {
            if (cur.isEmpty()) {
                return null;
            }
            return new HashSet(cur);
        }
        return cur;
    }
}

