/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.apache.ratis.util.UncheckedAutoCloseable;
import org.rocksdb.DBOptions;
import org.slf4j.Logger;

public class ManagedDBOptions
extends DBOptions {
    private final UncheckedAutoCloseable leakTracker = ManagedRocksObjectUtils.track((AutoCloseable)((Object)this));
    private final AtomicReference<org.rocksdb.Logger> loggerRef = new AtomicReference();

    public DBOptions setLogger(org.rocksdb.Logger logger) {
        IOUtils.close((Logger)ManagedRocksObjectUtils.LOG, (AutoCloseable[])new AutoCloseable[]{(AutoCloseable)this.loggerRef.getAndSet(logger)});
        return super.setLogger(logger);
    }

    public void close() {
        try {
            IOUtils.close((Logger)ManagedRocksObjectUtils.LOG, (AutoCloseable[])new AutoCloseable[]{this.loggerRef.getAndSet(null)});
            super.close();
        }
        finally {
            this.leakTracker.close();
        }
    }
}

