/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceTagsDeltaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceTagsDeltaUtil.class);
    private static final Logger PERF_TAGS_DELTA_LOG = RangerPerfTracer.getPerfLogger("tags.delta");
    private static boolean SUPPORTS_TAGS_DEDUP_INITIALIZED = false;
    private static boolean SUPPORTS_TAGS_DEDUP = false;

    public static ServiceTags applyDelta(ServiceTags serviceTags, ServiceTags delta) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTagsDeltaUtil.applyDelta()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TAGS_DELTA_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TAGS_DELTA_LOG, "RangerServiceTagsDeltaUtil.applyDelta()");
        }
        if (serviceTags != null && !serviceTags.getIsDelta().booleanValue() && delta != null && delta.getIsDelta().booleanValue()) {
            serviceTags.setServiceName(delta.getServiceName());
            serviceTags.setTagVersion(delta.getTagVersion());
            Map<Long, RangerTag> tags = serviceTags.getTags();
            List<RangerServiceResource> serviceResources = serviceTags.getServiceResources();
            Map<Long, List<Long>> resourceToTagIds = serviceTags.getResourceToTagIds();
            boolean isAnyMaterialChange = false;
            HashMap<Long, Long> replacedIds = new HashMap<Long, Long>();
            Iterator<Map.Entry<Long, RangerTag>> deltaTagIter = delta.getTags().entrySet().iterator();
            while (deltaTagIter.hasNext()) {
                Map.Entry<Long, RangerTag> entry = deltaTagIter.next();
                Long tagId = entry.getKey();
                RangerTag tag = entry.getValue();
                if (StringUtils.isEmpty((String)tag.getType())) {
                    if (null == tags.remove(tagId)) continue;
                    isAnyMaterialChange = true;
                    if (!RangerServiceTagsDeltaUtil.isSupportsTagsDedup()) continue;
                    serviceTags.cachedTags.remove(tag);
                    continue;
                }
                if (RangerServiceTagsDeltaUtil.isSupportsTagsDedup()) {
                    Long l = serviceTags.cachedTags.get(tag);
                    if (l == null) {
                        serviceTags.cachedTags.put(tag, tagId);
                        tags.put(tagId, tag);
                        continue;
                    }
                    replacedIds.put(tagId, l);
                    deltaTagIter.remove();
                    continue;
                }
                tags.put(tagId, tag);
            }
            HashMap<Long, Long> deletedServiceResources = new HashMap<Long, Long>();
            ArrayList<RangerServiceResource> addedServiceResources = new ArrayList<RangerServiceResource>();
            for (RangerServiceResource rangerServiceResource : delta.getServiceResources()) {
                boolean found = false;
                Iterator<RangerServiceResource> iter = serviceResources.iterator();
                while (iter.hasNext()) {
                    RangerServiceResource existingResource = iter.next();
                    if (!rangerServiceResource.getId().equals(existingResource.getId())) continue;
                    if (!StringUtils.isEmpty((String)rangerServiceResource.getResourceSignature())) {
                        if (!rangerServiceResource.getResourceSignature().equals(existingResource.getResourceSignature())) {
                            iter.remove();
                            existingResource.setResourceSignature(null);
                            addedServiceResources.add(existingResource);
                            break;
                        }
                    } else {
                        iter.remove();
                        deletedServiceResources.put(rangerServiceResource.getId(), rangerServiceResource.getId());
                    }
                    found = true;
                    break;
                }
                if (found || !StringUtils.isNotEmpty((String)rangerServiceResource.getResourceSignature())) continue;
                serviceResources.add(rangerServiceResource);
                isAnyMaterialChange = true;
            }
            for (Long l : deletedServiceResources.keySet()) {
                resourceToTagIds.remove(l);
            }
            if (RangerServiceTagsDeltaUtil.isSupportsTagsDedup()) {
                for (Map.Entry entry : delta.getResourceToTagIds().entrySet()) {
                    ListIterator<Long> listIter = ((List)entry.getValue()).listIterator();
                    while (listIter.hasNext()) {
                        Long tagId = (Long)listIter.next();
                        Long replacerTagId = (Long)replacedIds.get(tagId);
                        if (replacerTagId == null) continue;
                        listIter.set(replacerTagId);
                    }
                }
            }
            resourceToTagIds.putAll(delta.getResourceToTagIds());
            addedServiceResources.addAll(delta.getServiceResources());
            delta.setServiceResources(addedServiceResources);
            if (!isAnyMaterialChange && LOG.isDebugEnabled()) {
                LOG.debug("No material change may have occurred because of applying this delta");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot apply deltas to service-tags as one of preconditions is violated. Returning received serviceTags without applying delta!!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTagsDeltaUtil.applyDelta()");
        }
        RangerPerfTracer.log(perf);
        return serviceTags;
    }

    public static void pruneUnusedAttributes(ServiceTags serviceTags) {
        if (serviceTags != null) {
            serviceTags.setTagUpdateTime(null);
            for (Map.Entry<Long, RangerTagDef> entry : serviceTags.getTagDefinitions().entrySet()) {
                RangerTagDef tagDef = entry.getValue();
                tagDef.setCreatedBy(null);
                tagDef.setCreateTime(null);
                tagDef.setUpdatedBy(null);
                tagDef.setUpdateTime(null);
                tagDef.setGuid(null);
            }
            for (Map.Entry<Long, RangerBaseModelObject> entry : serviceTags.getTags().entrySet()) {
                RangerTag tag = (RangerTag)entry.getValue();
                tag.setCreatedBy(null);
                tag.setCreateTime(null);
                tag.setUpdatedBy(null);
                tag.setUpdateTime(null);
                tag.setGuid(null);
            }
            for (RangerServiceResource rangerServiceResource : serviceTags.getServiceResources()) {
                rangerServiceResource.setCreatedBy(null);
                rangerServiceResource.setCreateTime(null);
                rangerServiceResource.setUpdatedBy(null);
                rangerServiceResource.setUpdateTime(null);
                rangerServiceResource.setGuid(null);
            }
        }
    }

    public static boolean isSupportsTagsDedup() {
        if (!SUPPORTS_TAGS_DEDUP_INITIALIZED) {
            RangerAdminConfig config = RangerAdminConfig.getInstance();
            SUPPORTS_TAGS_DEDUP = config.getBoolean("ranger.admin.supports.tags.dedup", false);
            SUPPORTS_TAGS_DEDUP_INITIALIZED = true;
        }
        return SUPPORTS_TAGS_DEDUP;
    }
}

