/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.MessageLite;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class S3SecretValue {
    private static final Codec<S3SecretValue> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.S3Secret.getDefaultInstance()), S3SecretValue::fromProtobuf, S3SecretValue::getProtobuf);
    private final String kerberosID;
    private final String awsSecret;
    private final boolean isDeleted;
    private final long transactionLogIndex;

    public static Codec<S3SecretValue> getCodec() {
        return CODEC;
    }

    public static S3SecretValue of(String kerberosID, String awsSecret) {
        return S3SecretValue.of(kerberosID, awsSecret, 0L);
    }

    public static S3SecretValue of(String kerberosID, String awsSecret, long transactionLogIndex) {
        return new S3SecretValue(Objects.requireNonNull(kerberosID), Objects.requireNonNull(awsSecret), false, transactionLogIndex);
    }

    public S3SecretValue deleted() {
        return new S3SecretValue(this.kerberosID, "", true, this.transactionLogIndex);
    }

    private S3SecretValue(String kerberosID, String awsSecret, boolean isDeleted, long transactionLogIndex) {
        this.kerberosID = kerberosID;
        this.awsSecret = awsSecret;
        this.isDeleted = isDeleted;
        this.transactionLogIndex = transactionLogIndex;
    }

    public String getKerberosID() {
        return this.kerberosID;
    }

    public String getAwsSecret() {
        return this.awsSecret;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String getAwsAccessKey() {
        return this.kerberosID;
    }

    public long getTransactionLogIndex() {
        return this.transactionLogIndex;
    }

    public static S3SecretValue fromProtobuf(OzoneManagerProtocolProtos.S3Secret s3Secret) {
        return S3SecretValue.of(s3Secret.getKerberosID(), s3Secret.getAwsSecret());
    }

    public OzoneManagerProtocolProtos.S3Secret getProtobuf() {
        return OzoneManagerProtocolProtos.S3Secret.newBuilder().setAwsSecret(this.awsSecret).setKerberosID(this.kerberosID).build();
    }

    public String toString() {
        return "awsAccessKey=" + this.kerberosID + "\nawsSecret=" + this.awsSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3SecretValue that = (S3SecretValue)o;
        return this.kerberosID.equals(that.kerberosID) && this.awsSecret.equals(that.awsSecret) && this.isDeleted == that.isDeleted && this.transactionLogIndex == that.transactionLogIndex;
    }

    public int hashCode() {
        return Objects.hash(this.kerberosID, this.awsSecret, this.isDeleted, this.transactionLogIndex);
    }
}

