/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.client.checksum.CompositeCrcFileChecksum;
import org.apache.hadoop.ozone.client.checksum.CrcUtil;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMPBHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OMPBHelper.class);
    public static final ByteString REDACTED = ByteString.copyFromUtf8((String)"<redacted>");

    private OMPBHelper() {
    }

    public static SecurityProtos.TokenProto convertToTokenProto(Token<?> tok) {
        if (tok == null) {
            throw new IllegalArgumentException("Invalid argument: token is null");
        }
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(OMPBHelper.getByteString(tok.getIdentifier())).setPassword(OMPBHelper.getByteString(tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static Token<OzoneTokenIdentifier> convertToDelegationToken(SecurityProtos.TokenProto tokenProto) {
        return new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
    }

    public static BucketEncryptionKeyInfo convert(OzoneManagerProtocolProtos.BucketEncryptionInfoProto beInfo) {
        if (beInfo == null) {
            throw new IllegalArgumentException("Invalid argument: bucket encryption info is null");
        }
        return new BucketEncryptionKeyInfo(beInfo.hasCryptoProtocolVersion() ? OMPBHelper.convert(beInfo.getCryptoProtocolVersion()) : null, beInfo.hasSuite() ? OMPBHelper.convert(beInfo.getSuite()) : null, beInfo.getKeyName());
    }

    public static OzoneManagerProtocolProtos.BucketEncryptionInfoProto convert(BucketEncryptionKeyInfo beInfo) {
        if (beInfo == null || beInfo.getKeyName() == null) {
            throw new IllegalArgumentException("Invalid argument: bucket encryption info is null");
        }
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(beInfo.getKeyName());
        if (beInfo.getSuite() != null) {
            bb.setSuite(OMPBHelper.convert(beInfo.getSuite()));
        }
        if (beInfo.getVersion() != null) {
            bb.setCryptoProtocolVersion(OMPBHelper.convert(beInfo.getVersion()));
        }
        return bb.build();
    }

    public static OzoneManagerProtocolProtos.FileEncryptionInfoProto convert(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return OzoneManagerProtocolProtos.FileEncryptionInfoProto.newBuilder().setSuite(OMPBHelper.convert(info.getCipherSuite())).setCryptoProtocolVersion(OMPBHelper.convert(info.getCryptoProtocolVersion())).setKey(OMPBHelper.getByteString(info.getEncryptedDataEncryptionKey())).setIv(OMPBHelper.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).setKeyName(info.getKeyName()).build();
    }

    public static FileEncryptionInfo convert(OzoneManagerProtocolProtos.FileEncryptionInfoProto proto) {
        if (proto == null) {
            return null;
        }
        CipherSuite suite = OMPBHelper.convert(proto.getSuite());
        CryptoProtocolVersion version = OMPBHelper.convert(proto.getCryptoProtocolVersion());
        byte[] key = proto.getKey().toByteArray();
        byte[] iv = proto.getIv().toByteArray();
        String ezKeyVersionName = proto.getEzKeyVersionName();
        String keyName = proto.getKeyName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static FileChecksum convert(OzoneManagerProtocolProtos.FileChecksumProto proto) throws IOException {
        if (proto == null) {
            return null;
        }
        switch (proto.getChecksumType()) {
            case MD5CRC: {
                if (proto.hasMd5Crc()) {
                    return OMPBHelper.convertMD5MD5FileChecksum(proto.getMd5Crc());
                }
                throw new IOException("The field md5Crc is not set.");
            }
            case COMPOSITE_CRC: {
                if (proto.hasCompositeCrc()) {
                    return OMPBHelper.convertCompositeCrcChecksum(proto.getCompositeCrc());
                }
                throw new IOException("The field CompositeCrc is not set.");
            }
        }
        throw new IOException("Unexpected checksum type" + proto.getChecksumType());
    }

    public static MD5MD5CRC32FileChecksum convertMD5MD5FileChecksum(OzoneManagerProtocolProtos.MD5MD5Crc32FileChecksumProto proto) throws IOException {
        OzoneManagerProtocolProtos.ChecksumTypeProto checksumTypeProto = proto.getChecksumType();
        int bytesPerCRC = proto.getBytesPerCRC();
        long crcPerBlock = proto.getCrcPerBlock();
        ByteString md5 = proto.getMd5();
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(md5.toByteArray()));
        MD5Hash md5Hash = MD5Hash.read((DataInput)inputStream);
        switch (checksumTypeProto) {
            case CHECKSUM_CRC32: {
                return new MD5MD5CRC32GzipFileChecksum(bytesPerCRC, crcPerBlock, md5Hash);
            }
            case CHECKSUM_CRC32C: {
                return new MD5MD5CRC32CastagnoliFileChecksum(bytesPerCRC, crcPerBlock, md5Hash);
            }
        }
        throw new IOException("Unexpected checksum type " + checksumTypeProto);
    }

    public static CompositeCrcFileChecksum convertCompositeCrcChecksum(OzoneManagerProtocolProtos.CompositeCrcFileChecksumProto proto) throws IOException {
        OzoneManagerProtocolProtos.ChecksumTypeProto checksumTypeProto = proto.getChecksumType();
        int bytesPerCRC = proto.getBytesPerCrc();
        int crc = proto.getCrc();
        switch (checksumTypeProto) {
            case CHECKSUM_CRC32: {
                return new CompositeCrcFileChecksum(crc, DataChecksum.Type.CRC32, bytesPerCRC);
            }
            case CHECKSUM_CRC32C: {
                return new CompositeCrcFileChecksum(crc, DataChecksum.Type.CRC32C, bytesPerCRC);
            }
        }
        throw new IOException("Unexpected checksum type " + checksumTypeProto);
    }

    public static OzoneManagerProtocolProtos.MD5MD5Crc32FileChecksumProto convert(MD5MD5CRC32FileChecksum checksum) throws IOException {
        OzoneManagerProtocolProtos.ChecksumTypeProto type;
        switch (checksum.getCrcType()) {
            case CRC32: {
                type = OzoneManagerProtocolProtos.ChecksumTypeProto.CHECKSUM_CRC32;
                break;
            }
            case CRC32C: {
                type = OzoneManagerProtocolProtos.ChecksumTypeProto.CHECKSUM_CRC32C;
                break;
            }
            default: {
                type = OzoneManagerProtocolProtos.ChecksumTypeProto.CHECKSUM_NULL;
            }
        }
        DataOutputBuffer buf = new DataOutputBuffer();
        checksum.write((DataOutput)buf);
        byte[] bytes = buf.getData();
        DataInputBuffer buffer = new DataInputBuffer();
        buffer.reset(bytes, 0, bytes.length);
        int bytesPerCRC = buffer.readInt();
        long crcPerBlock = buffer.readLong();
        buffer.close();
        int offset = 12;
        ByteString byteString = ByteString.copyFrom((byte[])bytes, (int)offset, (int)(bytes.length - offset));
        return OzoneManagerProtocolProtos.MD5MD5Crc32FileChecksumProto.newBuilder().setChecksumType(type).setBytesPerCRC(bytesPerCRC).setCrcPerBlock(crcPerBlock).setMd5(byteString).build();
    }

    public static OzoneManagerProtocolProtos.CompositeCrcFileChecksumProto convert(CompositeCrcFileChecksum checksum) throws IOException {
        OzoneManagerProtocolProtos.ChecksumTypeProto type;
        Options.ChecksumOpt opt = checksum.getChecksumOpt();
        switch (opt.getChecksumType()) {
            case CRC32: {
                type = OzoneManagerProtocolProtos.ChecksumTypeProto.CHECKSUM_CRC32;
                break;
            }
            case CRC32C: {
                type = OzoneManagerProtocolProtos.ChecksumTypeProto.CHECKSUM_CRC32C;
                break;
            }
            default: {
                type = OzoneManagerProtocolProtos.ChecksumTypeProto.CHECKSUM_NULL;
            }
        }
        int crc = CrcUtil.readInt(checksum.getBytes(), 0);
        return OzoneManagerProtocolProtos.CompositeCrcFileChecksumProto.newBuilder().setChecksumType(type).setBytesPerCrc(opt.getBytesPerChecksum()).setCrc(crc).build();
    }

    public static OzoneManagerProtocolProtos.FileChecksumProto convert(FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        try {
            if (checksum instanceof MD5MD5CRC32FileChecksum) {
                OzoneManagerProtocolProtos.MD5MD5Crc32FileChecksumProto c1 = OMPBHelper.convert((MD5MD5CRC32FileChecksum)checksum);
                return OzoneManagerProtocolProtos.FileChecksumProto.newBuilder().setChecksumType(OzoneManagerProtocolProtos.FileChecksumTypeProto.MD5CRC).setMd5Crc(c1).build();
            }
            if (checksum instanceof CompositeCrcFileChecksum) {
                OzoneManagerProtocolProtos.CompositeCrcFileChecksumProto c2 = OMPBHelper.convert((CompositeCrcFileChecksum)checksum);
                return OzoneManagerProtocolProtos.FileChecksumProto.newBuilder().setChecksumType(OzoneManagerProtocolProtos.FileChecksumTypeProto.COMPOSITE_CRC).setCompositeCrc(c2).build();
            }
            LOG.warn("Unsupported file checksum runtime type " + checksum.getClass().getName());
        }
        catch (IOException ioe) {
            LOG.warn("Failed to convert a FileChecksum {} to its protobuf representation", (Object)checksum, (Object)ioe);
        }
        return null;
    }

    public static CipherSuite convert(OzoneManagerProtocolProtos.CipherSuiteProto proto) {
        switch (proto) {
            case AES_CTR_NOPADDING: {
                return CipherSuite.AES_CTR_NOPADDING;
            }
        }
        CipherSuite suite = CipherSuite.UNKNOWN;
        suite.setUnknownValue(proto.getNumber());
        return suite;
    }

    public static OzoneManagerProtocolProtos.CipherSuiteProto convert(CipherSuite suite) {
        switch (suite) {
            case UNKNOWN: {
                return OzoneManagerProtocolProtos.CipherSuiteProto.UNKNOWN;
            }
            case AES_CTR_NOPADDING: {
                return OzoneManagerProtocolProtos.CipherSuiteProto.AES_CTR_NOPADDING;
            }
        }
        return null;
    }

    public static OzoneManagerProtocolProtos.CryptoProtocolVersionProto convert(CryptoProtocolVersion version) {
        switch (version) {
            case UNKNOWN: {
                return OzoneManagerProtocolProtos.CryptoProtocolVersionProto.UNKNOWN_PROTOCOL_VERSION;
            }
            case ENCRYPTION_ZONES: {
                return OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES;
            }
        }
        return null;
    }

    public static CryptoProtocolVersion convert(OzoneManagerProtocolProtos.CryptoProtocolVersionProto proto) {
        switch (proto) {
            case ENCRYPTION_ZONES: {
                return CryptoProtocolVersion.ENCRYPTION_ZONES;
            }
        }
        CryptoProtocolVersion version = CryptoProtocolVersion.UNKNOWN;
        version.setUnknownValue(proto.getNumber());
        return version;
    }

    public static OzoneManagerProtocolProtos.OMRequest processForDebug(OzoneManagerProtocolProtos.OMRequest msg) {
        return msg;
    }

    public static OzoneManagerProtocolProtos.OMResponse processForDebug(OzoneManagerProtocolProtos.OMResponse msg) {
        if (msg == null) {
            return null;
        }
        if (msg.hasDbUpdatesResponse()) {
            OzoneManagerProtocolProtos.OMResponse.Builder builder = msg.toBuilder();
            builder.getDbUpdatesResponseBuilder().clearData().addData(REDACTED);
            return builder.build();
        }
        return msg;
    }
}

