/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.snapshot;

import com.google.protobuf.MessageLite;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class SnapshotDiffReportOzone
extends SnapshotDiffReport {
    private static final Codec<SnapshotDiffReport.DiffReportEntry> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.DiffReportEntryProto.getDefaultInstance()), SnapshotDiffReportOzone::fromProtobufDiffReportEntry, SnapshotDiffReportOzone::toProtobufDiffReportEntry, DelegatedCodec.CopyType.SHALLOW);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final String volumeName;
    private final String bucketName;
    private final String token;

    public static Codec<SnapshotDiffReport.DiffReportEntry> getDiffReportEntryCodec() {
        return CODEC;
    }

    public SnapshotDiffReportOzone(String snapshotRoot, String volumeName, String bucketName, String fromSnapshot, String toSnapshot, List<SnapshotDiffReport.DiffReportEntry> entryList, String token) {
        super(snapshotRoot, fromSnapshot, toSnapshot, entryList);
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.token = token;
    }

    public List<SnapshotDiffReport.DiffReportEntry> getDiffList() {
        return super.getDiffList();
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Difference between snapshot: ").append(this.getFromSnapshot()).append(" and snapshot: ").append(this.getLaterSnapshotName()).append(LINE_SEPARATOR);
        for (SnapshotDiffReport.DiffReportEntry entry : this.getDiffList()) {
            str.append(entry.toString()).append(LINE_SEPARATOR);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.token)) {
            str.append("Next token: ").append(this.token);
        }
        return str.toString();
    }

    public OzoneManagerProtocolProtos.SnapshotDiffReportProto toProtobuf() {
        OzoneManagerProtocolProtos.SnapshotDiffReportProto.Builder builder = OzoneManagerProtocolProtos.SnapshotDiffReportProto.newBuilder();
        builder.setVolumeName(this.volumeName).setBucketName(this.bucketName).setFromSnapshot(this.getFromSnapshot()).setToSnapshot(this.getLaterSnapshotName());
        builder.addAllDiffList((Iterable)this.getDiffList().stream().map(SnapshotDiffReportOzone::toProtobufDiffReportEntry).collect(Collectors.toList()));
        if (StringUtils.isNotEmpty((CharSequence)this.token)) {
            builder.setToken(this.token);
        }
        return builder.build();
    }

    public static SnapshotDiffReportOzone fromProtobuf(OzoneManagerProtocolProtos.SnapshotDiffReportProto report) {
        Path bucketPath = new Path("/" + report.getVolumeName() + "/" + report.getBucketName());
        OFSPath path = new OFSPath(bucketPath, new OzoneConfiguration());
        return new SnapshotDiffReportOzone(path.toString(), report.getVolumeName(), report.getBucketName(), report.getFromSnapshot(), report.getToSnapshot(), report.getDiffListList().stream().map(SnapshotDiffReportOzone::fromProtobufDiffReportEntry).collect(Collectors.toList()), report.getToken());
    }

    public static SnapshotDiffReport.DiffType fromProtobufDiffType(OzoneManagerProtocolProtos.DiffReportEntryProto.DiffTypeProto type) {
        return SnapshotDiffReport.DiffType.valueOf((String)type.name());
    }

    public static OzoneManagerProtocolProtos.DiffReportEntryProto.DiffTypeProto toProtobufDiffType(SnapshotDiffReport.DiffType type) {
        return OzoneManagerProtocolProtos.DiffReportEntryProto.DiffTypeProto.valueOf((String)type.name());
    }

    public static SnapshotDiffReport.DiffReportEntry fromProtobufDiffReportEntry(OzoneManagerProtocolProtos.DiffReportEntryProto entry) {
        if (entry == null) {
            return null;
        }
        SnapshotDiffReport.DiffType type = SnapshotDiffReportOzone.fromProtobufDiffType(entry.getDiffType());
        return type == null ? null : new SnapshotDiffReport.DiffReportEntry(type, entry.getSourcePath().getBytes(StandardCharsets.UTF_8), entry.hasTargetPath() ? entry.getTargetPath().getBytes(StandardCharsets.UTF_8) : null);
    }

    public static OzoneManagerProtocolProtos.DiffReportEntryProto toProtobufDiffReportEntry(SnapshotDiffReport.DiffReportEntry entry) {
        OzoneManagerProtocolProtos.DiffReportEntryProto.Builder builder = OzoneManagerProtocolProtos.DiffReportEntryProto.newBuilder();
        builder.setDiffType(SnapshotDiffReportOzone.toProtobufDiffType(entry.getType())).setSourcePath(new String(entry.getSourcePath(), StandardCharsets.UTF_8));
        if (entry.getTargetPath() != null) {
            String targetPath = new String(entry.getTargetPath(), StandardCharsets.UTF_8);
            builder.setTargetPath(targetPath);
        }
        return builder.build();
    }

    public static SnapshotDiffReport.DiffReportEntry getDiffReportEntry(SnapshotDiffReport.DiffType type, String sourcePath) {
        return SnapshotDiffReportOzone.getDiffReportEntry(type, sourcePath, null);
    }

    public static SnapshotDiffReport.DiffReportEntry getDiffReportEntry(SnapshotDiffReport.DiffType type, String sourcePath, String targetPath) {
        return new SnapshotDiffReport.DiffReportEntry(type, sourcePath.getBytes(StandardCharsets.UTF_8), targetPath != null ? targetPath.getBytes(StandardCharsets.UTF_8) : null);
    }

    public void aggregate(SnapshotDiffReportOzone diffReport) {
        this.getDiffList().addAll(diffReport.getDiffList());
    }
}

