/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import com.sun.jersey.api.container.ContainerException;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.ozone.lib.service.FileSystemAccessException;
import org.apache.ozone.lib.wsrs.ExceptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Provider
@InterfaceAudience.Private
public class HttpFSExceptionProvider
extends ExceptionProvider {
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)"httpfsaudit");
    private static final Logger LOG = LoggerFactory.getLogger(HttpFSExceptionProvider.class);

    @Override
    public Response toResponse(Throwable throwable) {
        Response.Status status;
        if (throwable instanceof FileSystemAccessException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ContainerException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof SecurityException) {
            status = Response.Status.UNAUTHORIZED;
        } else if (throwable instanceof FileNotFoundException) {
            status = Response.Status.NOT_FOUND;
        } else if (throwable instanceof IOException) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            this.logErrorFully(status, throwable);
        } else if (throwable instanceof UnsupportedOperationException) {
            status = Response.Status.BAD_REQUEST;
            this.logErrorFully(status, throwable);
        } else if (throwable instanceof IllegalArgumentException) {
            status = Response.Status.BAD_REQUEST;
            this.logErrorFully(status, throwable);
        } else {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            this.logErrorFully(status, throwable);
        }
        return this.createResponse(status, throwable);
    }

    @Override
    protected void log(Response.Status status, Throwable throwable) {
        String method = MDC.get((String)"method");
        String path = MDC.get((String)"path");
        String message = this.getOneLineMessage(throwable);
        AUDIT_LOG.warn("FAILED [{}:{}] response [{}] {}", new Object[]{method, path, status, message});
        LOG.warn("[{}:{}] response [{}] {}", new Object[]{method, path, status, message, throwable});
    }

    private void logErrorFully(Response.Status status, Throwable throwable) {
        LOG.debug("Failed with {}", (Object)status, (Object)throwable);
    }
}

