/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.proxy;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMProxyInfo;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMContainerLocationFailoverProxyProvider
implements FailoverProxyProvider<StorageContainerLocationProtocolPB>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(SCMContainerLocationFailoverProxyProvider.class);
    private final Map<String, FailoverProxyProvider.ProxyInfo<StorageContainerLocationProtocolPB>> scmProxies;
    private final Map<String, SCMProxyInfo> scmProxyInfoMap;
    private List<String> scmNodeIds;
    private volatile String currentProxySCMNodeId;
    private volatile int currentProxyIndex;
    private final ConfigurationSource conf;
    private final SCMClientConfig scmClientConfig;
    private final long scmVersion;
    private String scmServiceId;
    private final int maxRetryCount;
    private final long retryInterval;
    private final UserGroupInformation ugi;
    private String updatedLeaderNodeID = null;

    public SCMContainerLocationFailoverProxyProvider(ConfigurationSource conf, UserGroupInformation userGroupInformation) {
        this.conf = conf;
        if (userGroupInformation == null) {
            try {
                this.ugi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ex) {
                LOG.error("Unable to fetch user credentials from UGI", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        } else {
            this.ugi = userGroupInformation;
        }
        this.scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        this.scmProxies = new HashMap<String, FailoverProxyProvider.ProxyInfo<StorageContainerLocationProtocolPB>>();
        this.scmProxyInfoMap = new HashMap<String, SCMProxyInfo>();
        this.loadConfigs();
        this.currentProxyIndex = 0;
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
        this.scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class);
        this.maxRetryCount = this.scmClientConfig.getRetryCount();
        this.retryInterval = this.scmClientConfig.getRetryInterval();
    }

    @VisibleForTesting
    protected synchronized void loadConfigs() {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf);
        this.scmNodeIds = new ArrayList<String>();
        for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
            if (scmNodeInfo.getScmClientAddress() == null) {
                throw new ConfigurationException("SCM Client Address could not be obtained from config. Config is not properly defined");
            }
            InetSocketAddress scmClientAddress = NetUtils.createSocketAddr((String)scmNodeInfo.getScmClientAddress());
            this.scmServiceId = scmNodeInfo.getServiceId();
            String scmNodeId = scmNodeInfo.getNodeId();
            this.scmNodeIds.add(scmNodeId);
            SCMProxyInfo scmProxyInfo = new SCMProxyInfo(this.scmServiceId, scmNodeId, scmClientAddress);
            this.scmProxyInfoMap.put(scmNodeId, scmProxyInfo);
        }
    }

    @VisibleForTesting
    public synchronized String getCurrentProxySCMNodeId() {
        return this.currentProxySCMNodeId;
    }

    @VisibleForTesting
    public synchronized void changeCurrentProxy(String nodeId) {
        this.currentProxyIndex = this.scmNodeIds.indexOf(nodeId);
        this.currentProxySCMNodeId = nodeId;
        this.nextProxyIndex();
    }

    public synchronized FailoverProxyProvider.ProxyInfo<StorageContainerLocationProtocolPB> getProxy() {
        FailoverProxyProvider.ProxyInfo currentProxyInfo = this.scmProxies.get(this.getCurrentProxySCMNodeId());
        if (currentProxyInfo == null) {
            currentProxyInfo = this.createSCMProxy(this.getCurrentProxySCMNodeId());
        }
        return currentProxyInfo;
    }

    public synchronized List<StorageContainerLocationProtocolPB> getProxies() {
        for (SCMProxyInfo scmProxyInfo : this.scmProxyInfoMap.values()) {
            if (this.scmProxies.get(scmProxyInfo.getNodeId()) != null) continue;
            this.scmProxies.put(scmProxyInfo.getNodeId(), (FailoverProxyProvider.ProxyInfo<StorageContainerLocationProtocolPB>)this.createSCMProxy(scmProxyInfo.getNodeId()));
        }
        return this.scmProxies.values().stream().map(proxyInfo -> (StorageContainerLocationProtocolPB)proxyInfo.proxy).collect(Collectors.toList());
    }

    public synchronized void performFailover(StorageContainerLocationProtocolPB newLeader) {
        if (this.updatedLeaderNodeID != null) {
            this.currentProxySCMNodeId = this.updatedLeaderNodeID;
        } else {
            this.nextProxyIndex();
        }
        LOG.debug("Failing over to next proxy. {}", (Object)this.getCurrentProxySCMNodeId());
    }

    public synchronized void performFailoverToAssignedLeader(String newLeader, Exception e) {
        ServerNotLeaderException snle = (ServerNotLeaderException)SCMHAUtils.getServerNotLeaderException((Exception)e);
        if (snle != null && snle.getSuggestedLeader() != null) {
            Optional<SCMProxyInfo> matchedProxyInfo = this.scmProxyInfoMap.values().stream().filter(proxyInfo -> NetUtils.getHostPortString((InetSocketAddress)proxyInfo.getAddress()).equals(snle.getSuggestedLeader())).findFirst();
            if (matchedProxyInfo.isPresent()) {
                newLeader = matchedProxyInfo.get().getNodeId();
                LOG.debug("Performing failover to suggested leader {}, nodeId {}", (Object)snle.getSuggestedLeader(), (Object)newLeader);
            } else {
                LOG.debug("Suggested leader {} does not match with any of the proxyInfo adress {}", (Object)snle.getSuggestedLeader(), (Object)Arrays.toString(this.scmProxyInfoMap.values().toArray()));
            }
        }
        this.assignLeaderToNode(newLeader);
    }

    public Class<StorageContainerLocationProtocolPB> getInterface() {
        return StorageContainerLocationProtocolPB.class;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo<StorageContainerLocationProtocolPB> proxy : this.scmProxies.values()) {
            StorageContainerLocationProtocolPB scmProxy = (StorageContainerLocationProtocolPB)proxy.proxy;
            if (scmProxy == null) continue;
            RPC.stopProxy((Object)scmProxy);
        }
    }

    private long getRetryInterval() {
        return this.retryInterval;
    }

    private synchronized void nextProxyIndex() {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.scmProxyInfoMap.size();
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
    }

    private synchronized void assignLeaderToNode(String newLeaderNodeId) {
        if (!this.currentProxySCMNodeId.equals(newLeaderNodeId)) {
            if (this.scmProxyInfoMap.containsKey(newLeaderNodeId)) {
                this.updatedLeaderNodeID = newLeaderNodeId;
                LOG.debug("Updated LeaderNodeID {}", (Object)this.updatedLeaderNodeID);
            } else {
                this.updatedLeaderNodeID = null;
            }
        }
    }

    private FailoverProxyProvider.ProxyInfo createSCMProxy(String nodeId) {
        SCMProxyInfo scmProxyInfo = this.scmProxyInfoMap.get(nodeId);
        InetSocketAddress address = scmProxyInfo.getAddress();
        try {
            StorageContainerLocationProtocolPB scmProxy = this.createSCMProxy(address);
            FailoverProxyProvider.ProxyInfo proxyInfo = new FailoverProxyProvider.ProxyInfo((Object)scmProxy, scmProxyInfo.toString());
            this.scmProxies.put(nodeId, (FailoverProxyProvider.ProxyInfo<StorageContainerLocationProtocolPB>)proxyInfo);
            return proxyInfo;
        }
        catch (IOException ioe) {
            LOG.error("{} Failed to create RPC proxy to SCM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
            throw new RuntimeException(ioe);
        }
    }

    private StorageContainerLocationProtocolPB createSCMProxy(InetSocketAddress scmAddress) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        RetryPolicy connectionRetryPolicy = RetryPolicies.failoverOnNetworkException((int)0);
        return (StorageContainerLocationProtocolPB)RPC.getProtocolProxy(StorageContainerLocationProtocolPB.class, (long)this.scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)this.ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)this.scmClientConfig.getRpcTimeOut()), (RetryPolicy)connectionRetryPolicy).getProxy();
    }

    public RetryPolicy getRetryPolicy() {
        return new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception e, int retry, int failover, boolean b) {
                if (SCMHAUtils.checkRetriableWithNoFailoverException((Exception)e)) {
                    SCMContainerLocationFailoverProxyProvider.this.setUpdatedLeaderNodeID();
                } else {
                    SCMContainerLocationFailoverProxyProvider.this.performFailoverToAssignedLeader(null, e);
                }
                return SCMHAUtils.getRetryAction((int)failover, (int)retry, (Exception)e, (int)SCMContainerLocationFailoverProxyProvider.this.maxRetryCount, (long)SCMContainerLocationFailoverProxyProvider.this.getRetryInterval());
            }
        };
    }

    public synchronized void setUpdatedLeaderNodeID() {
        this.updatedLeaderNodeID = this.getCurrentProxySCMNodeId();
    }
}

