/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.keys.SecurityUtil;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneSecretKey
implements Writable {
    private int keyId;
    private long expiryDate;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private SecurityConfig securityConfig;
    private String certSerialId;

    public OzoneSecretKey(int keyId, long expiryDate, KeyPair keyPair, String certificateSerialId) {
        Preconditions.checkNotNull((Object)keyId);
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        this.certSerialId = certificateSerialId;
    }

    public OzoneSecretKey(int keyId, long expiryDate, byte[] pvtKey, byte[] publicKey) {
        Preconditions.checkNotNull((Object)pvtKey);
        Preconditions.checkNotNull((Object)publicKey);
        this.securityConfig = new SecurityConfig((ConfigurationSource)new OzoneConfiguration());
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        this.privateKey = SecurityUtil.getPrivateKey(pvtKey, this.securityConfig);
        this.publicKey = SecurityUtil.getPublicKey(publicKey, this.securityConfig);
    }

    public int getKeyId() {
        return this.keyId;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getCertSerialId() {
        return this.certSerialId;
    }

    public byte[] getEncodedPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public byte[] getEncodedPubliceKey() {
        return this.publicKey.getEncoded();
    }

    public void setExpiryDate(long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void write(DataOutput out) throws IOException {
        HddsProtos.SecretKeyProto token = HddsProtos.SecretKeyProto.newBuilder().setKeyId(this.getKeyId()).setExpiryDate(this.getExpiryDate()).setPrivateKeyBytes(ByteString.copyFrom((byte[])this.getEncodedPrivateKey())).setPublicKeyBytes(ByteString.copyFrom((byte[])this.getEncodedPubliceKey())).build();
        out.write(token.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        HddsProtos.SecretKeyProto secretKey = HddsProtos.SecretKeyProto.parseFrom((InputStream)((DataInputStream)in));
        this.expiryDate = secretKey.getExpiryDate();
        this.keyId = secretKey.getKeyId();
        this.privateKey = SecurityUtil.getPrivateKey(secretKey.getPrivateKeyBytes().toByteArray(), this.securityConfig);
        this.publicKey = SecurityUtil.getPublicKey(secretKey.getPublicKeyBytes().toByteArray(), this.securityConfig);
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(537, 963);
        hashCodeBuilder.append(this.getExpiryDate()).append(this.getKeyId()).append(this.getEncodedPrivateKey()).append(this.getEncodedPubliceKey());
        return hashCodeBuilder.build();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OzoneSecretKey) {
            OzoneSecretKey that = (OzoneSecretKey)obj;
            return new EqualsBuilder().append(this.keyId, that.keyId).append(this.expiryDate, that.expiryDate).append((Object)this.privateKey, (Object)that.privateKey).append((Object)this.publicKey, (Object)that.publicKey).build();
        }
        return false;
    }

    static OzoneSecretKey readProtoBuf(DataInput in) throws IOException {
        Preconditions.checkNotNull((Object)in);
        HddsProtos.SecretKeyProto key = HddsProtos.SecretKeyProto.parseFrom((InputStream)((DataInputStream)in));
        return new OzoneSecretKey(key.getKeyId(), key.getExpiryDate(), key.getPrivateKeyBytes().toByteArray(), key.getPublicKeyBytes().toByteArray());
    }

    static OzoneSecretKey readProtoBuf(byte[] identifier) throws IOException {
        Preconditions.checkNotNull((Object)identifier);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(identifier));
        return OzoneSecretKey.readProtoBuf(in);
    }
}

