/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.IOException;
import java.time.Instant;
import java.util.Set;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenSecretManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneBlockTokenSecretManager
extends ShortLivedTokenSecretManager<OzoneBlockTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneBlockTokenSecretManager.class);

    public OzoneBlockTokenSecretManager(long tokenLifetime, SecretKeySignerClient passwordManager) {
        super(tokenLifetime, passwordManager);
    }

    public OzoneBlockTokenIdentifier createIdentifier(String owner, BlockID blockID, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) {
        return new OzoneBlockTokenIdentifier(owner, blockID, modes, this.getTokenExpiryTime().toEpochMilli(), maxLength);
    }

    public Token<OzoneBlockTokenIdentifier> generateToken(String user, BlockID blockId, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) {
        OzoneBlockTokenIdentifier tokenIdentifier = this.createIdentifier(user, blockId, modes, maxLength);
        if (LOG.isDebugEnabled()) {
            long expiryTime = tokenIdentifier.getExpiryDate();
            LOG.info("Issued delegation token -> expiryTime:{}, tokenId:{}", (Object)Instant.ofEpochMilli(expiryTime), (Object)tokenIdentifier);
        }
        byte[] password = this.createPassword(tokenIdentifier);
        return new Token(tokenIdentifier.getBytes(), password, tokenIdentifier.getKind(), new Text(tokenIdentifier.getService()));
    }

    public Token<OzoneBlockTokenIdentifier> generateToken(BlockID blockId, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String userID = ugi == null ? null : ugi.getShortUserName();
        return this.generateToken(userID, blockId, modes, maxLength);
    }
}

