/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.token.BlockTokenException;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenIdentifier;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public abstract class ShortLivedTokenVerifier<T extends ShortLivedTokenIdentifier>
implements TokenVerifier {
    private final SecurityConfig conf;
    private final SecretKeyVerifierClient secretKeyClient;

    protected ShortLivedTokenVerifier(SecurityConfig conf, SecretKeyVerifierClient secretKeyClient) {
        this.conf = conf;
        this.secretKeyClient = secretKeyClient;
    }

    protected abstract boolean isTokenRequired(ContainerProtos.Type var1);

    protected abstract T createTokenIdentifier();

    protected abstract Object getService(ContainerProtos.ContainerCommandRequestProtoOrBuilder var1);

    protected void verify(T tokenId, ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) throws SCMSecurityException {
    }

    @Override
    public void verify(String user, Token<?> token, ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) throws SCMSecurityException {
        if (!this.isTokenRequired(cmd.getCmdType())) {
            return;
        }
        T tokenId = this.createTokenIdentifier();
        try {
            tokenId.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        }
        catch (IOException ex) {
            throw new BlockTokenException("Failed to decode token : " + token);
        }
        this.verifyTokenPassword((ShortLivedTokenIdentifier)tokenId, token.getPassword());
        UserGroupInformation tokenUser = tokenId.getUser();
        if (tokenId.isExpired(Instant.now())) {
            throw new BlockTokenException("Expired token for user: " + tokenUser);
        }
        String service = String.valueOf(this.getService(cmd));
        if (!Objects.equals(service, tokenId.getService())) {
            throw new BlockTokenException("ID mismatch. Token for ID: " + tokenId.getService() + " can't be used to access: " + service + " by user: " + tokenUser);
        }
        this.verify(tokenId, cmd);
    }

    protected SecurityConfig getConf() {
        return this.conf;
    }

    private void verifyTokenPassword(ShortLivedTokenIdentifier tokenId, byte[] password) throws SCMSecurityException {
        ManagedSecretKey secretKey = this.secretKeyClient.getSecretKey(tokenId.getSecretKeyId());
        if (secretKey == null) {
            throw new BlockTokenException("Can't find the signing secret key " + tokenId.getSecretKeyId() + " of the token for user: " + tokenId.getUser());
        }
        if (secretKey.isExpired()) {
            throw new BlockTokenException("Token can't be verified due to expired secret key " + tokenId.getSecretKeyId());
        }
        if (!secretKey.isValidSignature((TokenIdentifier)tokenId, password)) {
            throw new BlockTokenException("Invalid token for user: " + tokenId.getUser());
        }
    }
}

