/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.BaseApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApprover
extends BaseApprover {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApprover.class);

    public DefaultApprover(PKIProfile pkiProfile, SecurityConfig config) {
        super(pkiProfile, config);
    }

    @Override
    public X509CertificateHolder sign(SecurityConfig config, PrivateKey caPrivate, X509CertificateHolder caCertificate, Date validFrom, Date validTill, PKCS10CertificationRequest certificationRequest, String scmId, String clusterId, String certSerialId) throws IOException, OperatorCreationException {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(config.getSignatureAlgo());
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter asymmetricKP = PrivateKeyFactory.createKey((byte[])caPrivate.getEncoded());
        SubjectPublicKeyInfo keyInfo = certificationRequest.getSubjectPublicKeyInfo();
        X500Name x500Name = certificationRequest.getSubject();
        String csrScmId = x500Name.getRDNs(BCStyle.OU)[0].getFirst().getValue().toASN1Primitive().toString();
        String csrClusterId = x500Name.getRDNs(BCStyle.O)[0].getFirst().getValue().toASN1Primitive().toString();
        String cn = x500Name.getRDNs(BCStyle.CN)[0].getFirst().getValue().toASN1Primitive().toString();
        if (!clusterId.equals(csrClusterId)) {
            if (csrScmId.equalsIgnoreCase("null") && csrClusterId.equalsIgnoreCase("null")) {
                csrClusterId = clusterId;
                csrScmId = scmId;
            } else {
                throw new SCMSecurityException("ScmId and ClusterId in CSR subject are incorrect.");
            }
        }
        x500Name = CertificateSignRequest.getDistinguishedNameWithSN((String)cn, (String)csrScmId, (String)csrClusterId, (String)certSerialId);
        RSAKeyParameters rsa = (RSAKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)keyInfo);
        if (rsa.getModulus().bitLength() < config.getSize()) {
            throw new SCMSecurityException("Key size is too small in certificate signing request");
        }
        X509v3CertificateBuilder certificateGenerator = new X509v3CertificateBuilder(caCertificate.getSubject(), new BigInteger(certSerialId), validFrom, validTill, x500Name, keyInfo);
        Extensions exts = CertificateSignRequest.getPkcs9Extensions((PKCS10CertificationRequest)certificationRequest);
        LOG.info("Extensions in CSR: {}", (Object)Arrays.stream(exts.getExtensionOIDs()).map(ASN1ObjectIdentifier::getId).collect(Collectors.joining(", ")));
        LOG.info("Extensions to add to the certificate if they present in CSR: {}", (Object)Arrays.stream(this.getProfile().getSupportedExtensions()).map(oid -> oid == null ? "null" : oid.getId()).collect(Collectors.joining(", ")));
        for (ASN1ObjectIdentifier extId : this.getProfile().getSupportedExtensions()) {
            Extension ext = exts.getExtension(extId);
            if (ext == null) continue;
            certificateGenerator.addExtension(ext);
        }
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(asymmetricKP);
        return certificateGenerator.build(sigGen);
    }

    @Override
    public CompletableFuture<X509CertificateHolder> inspectCSR(String csr) throws IOException {
        return super.inspectCSR(csr);
    }

    @Override
    public CompletableFuture<X509CertificateHolder> inspectCSR(PKCS10CertificationRequest csr) {
        return super.inspectCSR(csr);
    }
}

