/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TruncateCascadeStep;
import org.jooq.TruncateFinalStep;
import org.jooq.TruncateIdentityStep;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class TruncateImpl<R extends Record>
extends AbstractQuery
implements TruncateIdentityStep<R> {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TRUNCATE};
    private final Table<R> table;
    private Boolean cascade;
    private Boolean restartIdentity;

    public TruncateImpl(Configuration configuration, Table<R> table) {
        super(configuration);
        this.table = table;
    }

    @Override
    public final TruncateFinalStep<R> cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final TruncateFinalStep<R> restrict() {
        this.cascade = false;
        return this;
    }

    @Override
    public final TruncateCascadeStep<R> restartIdentity() {
        this.restartIdentity = true;
        return this;
    }

    @Override
    public final TruncateCascadeStep<R> continueIdentity() {
        this.restartIdentity = false;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: {
                ctx.visit(DSL.delete(this.table));
                break;
            }
            default: {
                ctx.start(Clause.TRUNCATE_TRUNCATE).visit(Keywords.K_TRUNCATE_TABLE).sql(' ').visit(this.table);
                if (this.restartIdentity != null) {
                    ctx.formatSeparator().visit(this.restartIdentity != false ? Keywords.K_RESTART_IDENTITY : Keywords.K_CONTINUE_IDENTITY);
                }
                if (this.cascade != null) {
                    ctx.formatSeparator().visit(this.cascade != false ? Keywords.K_CASCADE : Keywords.K_RESTRICT);
                }
                ctx.end(Clause.TRUNCATE_TRUNCATE);
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

