/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.ratis.util.function.CheckedSupplier;

public class OzoneKeyDetails
extends OzoneKey {
    private final List<OzoneKeyLocation> ozoneKeyLocations;
    private final FileEncryptionInfo feInfo;
    private final CheckedSupplier<OzoneInputStream, IOException> contentSupplier;

    public OzoneKeyDetails(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, List<OzoneKeyLocation> ozoneKeyLocations, ReplicationConfig replicationConfig, Map<String, String> metadata, FileEncryptionInfo feInfo, CheckedSupplier<OzoneInputStream, IOException> contentSupplier, boolean isFile) {
        super(volumeName, bucketName, keyName, size, creationTime, modificationTime, replicationConfig, metadata, isFile);
        this.ozoneKeyLocations = ozoneKeyLocations;
        this.feInfo = feInfo;
        this.contentSupplier = contentSupplier;
    }

    public List<OzoneKeyLocation> getOzoneKeyLocations() {
        return this.ozoneKeyLocations;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.feInfo;
    }

    @JsonIgnore
    public OzoneInputStream getContent() throws IOException {
        return (OzoneInputStream)this.contentSupplier.get();
    }
}

