/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.ozone.recon.schema;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hadoop.ozone.recon.codegen.SqlDbUtils;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Singleton
public class UtilizationSchemaDefinition
implements ReconSchemaDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(UtilizationSchemaDefinition.class);
    private final DataSource dataSource;
    private DSLContext dslContext;
    public static final String CLUSTER_GROWTH_DAILY_TABLE_NAME = "CLUSTER_GROWTH_DAILY";
    public static final String FILE_COUNT_BY_SIZE_TABLE_NAME = "FILE_COUNT_BY_SIZE";
    public static final String CONTAINER_COUNT_BY_SIZE_TABLE_NAME = "CONTAINER_COUNT_BY_SIZE";

    @Inject
    UtilizationSchemaDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    @Transactional
    public void initializeSchema() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        this.dslContext = DSL.using((Connection)conn);
        if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, FILE_COUNT_BY_SIZE_TABLE_NAME)) {
            this.createFileSizeCountTable();
        }
        if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, CLUSTER_GROWTH_DAILY_TABLE_NAME)) {
            this.createClusterGrowthTable();
        }
        if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, CONTAINER_COUNT_BY_SIZE_TABLE_NAME)) {
            this.createContainerSizeCountTable();
        }
    }

    private void createClusterGrowthTable() {
        this.dslContext.createTableIfNotExists(CLUSTER_GROWTH_DAILY_TABLE_NAME).column("timestamp", SQLDataType.TIMESTAMP.nullable(false)).column("datanode_id", SQLDataType.INTEGER.nullable(false)).column("datanode_host", SQLDataType.VARCHAR((int)1024)).column("rack_id", SQLDataType.VARCHAR((int)1024)).column("available_size", SQLDataType.BIGINT).column("used_size", SQLDataType.BIGINT).column("container_count", SQLDataType.INTEGER).column("block_count", SQLDataType.INTEGER).constraint((Constraint)DSL.constraint((String)"pk_timestamp_datanode_id").primaryKey(new String[]{"timestamp", "datanode_id"})).execute();
    }

    private void createFileSizeCountTable() {
        this.dslContext.createTableIfNotExists(FILE_COUNT_BY_SIZE_TABLE_NAME).column("volume", SQLDataType.VARCHAR((int)64).nullable(false)).column("bucket", SQLDataType.VARCHAR((int)64).nullable(false)).column("file_size", SQLDataType.BIGINT.nullable(false)).column("count", SQLDataType.BIGINT).constraint((Constraint)DSL.constraint((String)"pk_volume_bucket_file_size").primaryKey(new String[]{"volume", "bucket", "file_size"})).execute();
    }

    private void createContainerSizeCountTable() {
        this.dslContext.createTableIfNotExists(CONTAINER_COUNT_BY_SIZE_TABLE_NAME).column("container_size", SQLDataType.BIGINT.nullable(false)).column("count", SQLDataType.BIGINT).constraint((Constraint)DSL.constraint((String)"pk_container_size").primaryKey(new String[]{"container_size"})).execute();
    }

    public DSLContext getDSLContext() {
        return this.dslContext;
    }
}

