/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementStatusDefault;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCMCommonPlacementPolicy
implements PlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMCommonPlacementPolicy.class);
    private final NodeManager nodeManager;
    private final Random rand = new Random();
    private final ConfigurationSource conf;
    private final boolean shouldRemovePeers;
    private ContainerPlacementStatus validPlacement = new ContainerPlacementStatusDefault(1, 1, 1);
    private ContainerPlacementStatus invalidPlacement = new ContainerPlacementStatusDefault(0, 1, 1);
    private static final List<DatanodeDetails> UNSET_USED_NODES = Collections.unmodifiableList(new ArrayList());

    public SCMCommonPlacementPolicy(NodeManager nodeManager, ConfigurationSource conf) {
        this.nodeManager = nodeManager;
        this.conf = conf;
        this.shouldRemovePeers = ScmUtils.shouldRemovePeers(conf);
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Random getRand() {
        return this.rand;
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }

    @Override
    public final List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        return this.chooseDatanodes(UNSET_USED_NODES, excludedNodes, favoredNodes, nodesRequired, metadataSizeRequired, dataSizeRequired);
    }

    private List<DatanodeDetails> validateDatanodes(List<DatanodeDetails> dns) {
        if (Objects.isNull(dns)) {
            return Collections.emptyList();
        }
        for (int i = 0; i < dns.size(); ++i) {
            DatanodeDetails node = dns.get(i);
            DatanodeDetails datanodeDetails = this.nodeManager.getNodeByUuid(node.getUuid());
            if (datanodeDetails == null) continue;
            dns.set(i, datanodeDetails);
        }
        return dns;
    }

    @Override
    public final List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> usedNodes, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        return this.chooseDatanodesInternal(this.validateDatanodes(usedNodes), this.validateDatanodes(excludedNodes), favoredNodes, nodesRequired, metadataSizeRequired, dataSizeRequired);
    }

    protected List<DatanodeDetails> chooseDatanodesInternal(List<DatanodeDetails> usedNodes, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        List<DatanodeDetails> healthyNodes = this.nodeManager.getNodes(NodeStatus.inServiceHealthy());
        if (excludedNodes != null) {
            healthyNodes.removeAll(excludedNodes);
        }
        if (usedNodes != null) {
            healthyNodes.removeAll(usedNodes);
        }
        if (healthyNodes.size() == 0) {
            String msg = "No healthy node found to allocate container.";
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
        if (healthyNodes.size() < nodesRequired) {
            String msg = String.format("Not enough healthy nodes to allocate container. %d  datanodes required. Found %d", nodesRequired, healthyNodes.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return this.filterNodesWithSpace(healthyNodes, nodesRequired, metadataSizeRequired, dataSizeRequired);
    }

    protected boolean usedNodesPassed(List<DatanodeDetails> list) {
        if (list == null) {
            return true;
        }
        return list != UNSET_USED_NODES;
    }

    public List<DatanodeDetails> filterNodesWithSpace(List<DatanodeDetails> nodes, int nodesRequired, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        List<DatanodeDetails> nodesWithSpace = nodes.stream().filter(d -> SCMCommonPlacementPolicy.hasEnoughSpace(d, metadataSizeRequired, dataSizeRequired, this.conf)).collect(Collectors.toList());
        if (nodesWithSpace.size() < nodesRequired) {
            String msg = String.format("Unable to find enough nodes that meet the space requirement of %d bytes for metadata and %d bytes for data in healthy node set. Required %d. Found %d.", metadataSizeRequired, dataSizeRequired, nodesRequired, nodesWithSpace.size());
            LOG.warn(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_NODES_WITH_SPACE);
        }
        return nodesWithSpace;
    }

    public static boolean hasEnoughSpace(DatanodeDetails datanodeDetails, long metadataSizeRequired, long dataSizeRequired, ConfigurationSource conf) {
        Preconditions.checkArgument((boolean)(datanodeDetails instanceof DatanodeInfo));
        boolean enoughForData = false;
        boolean enoughForMeta = false;
        DatanodeInfo datanodeInfo = (DatanodeInfo)datanodeDetails;
        if (dataSizeRequired > 0L) {
            for (StorageContainerDatanodeProtocolProtos.StorageReportProto storageReportProto : datanodeInfo.getStorageReports()) {
                if (!VolumeUsage.hasVolumeEnoughSpace((long)storageReportProto.getRemaining(), (long)storageReportProto.getCommitted(), (long)dataSizeRequired, (long)storageReportProto.getFreeSpaceToSpare())) continue;
                enoughForData = true;
                break;
            }
        } else {
            enoughForData = true;
        }
        if (!enoughForData) {
            LOG.debug("Datanode {} has no volumes with enough space to allocate {} bytes for data.", (Object)datanodeDetails, (Object)dataSizeRequired);
            return false;
        }
        if (metadataSizeRequired > 0L) {
            for (StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto metadataStorageReportProto : datanodeInfo.getMetadataStorageReports()) {
                if (metadataStorageReportProto.getRemaining() <= metadataSizeRequired) continue;
                enoughForMeta = true;
                break;
            }
        } else {
            enoughForMeta = true;
        }
        if (!enoughForMeta) {
            LOG.debug("Datanode {} has no volumes with enough space to allocate {} bytes for metadata.", (Object)datanodeDetails, (Object)metadataSizeRequired);
        }
        return enoughForMeta;
    }

    public List<DatanodeDetails> getResultSet(int nodesRequired, List<DatanodeDetails> healthyNodes) throws SCMException {
        ArrayList<DatanodeDetails> results = new ArrayList<DatanodeDetails>();
        for (int x = 0; x < nodesRequired; ++x) {
            DatanodeDetails nodeId = this.chooseNode(healthyNodes);
            if (nodeId == null) continue;
            this.removePeers(nodeId, healthyNodes);
            results.add(nodeId);
            healthyNodes.remove(nodeId);
        }
        if (results.size() < nodesRequired) {
            LOG.error("Unable to find the required number of healthy nodes that meet the criteria. Required nodes: {}, Found nodes: {}", (Object)nodesRequired, (Object)results.size());
            throw new SCMException("Unable to find required number of nodes.", SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return results;
    }

    public abstract DatanodeDetails chooseNode(List<DatanodeDetails> var1);

    protected int getRequiredRackCount(int numReplicas, int excludedRackCount) {
        return 1;
    }

    protected int getMaxReplicasPerRack(int numReplicas, int numberOfRacks) {
        return numReplicas / numberOfRacks + Math.min(numReplicas % numberOfRacks, 1);
    }

    @Override
    public ContainerPlacementStatus validateContainerPlacement(List<DatanodeDetails> dns, int replicas) {
        NetworkTopology topology = this.nodeManager.getClusterNetworkTopologyMap();
        int requiredRacks = this.getRequiredRackCount(replicas, 0);
        if (topology == null || replicas == 1 || requiredRacks == 1) {
            if (dns.size() > 0) {
                return this.validPlacement;
            }
            return this.invalidPlacement;
        }
        ArrayList<Integer> currentRackCount = new ArrayList<Integer>(dns.stream().map(this::getPlacementGroup).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum))).values());
        int maxLevel = topology.getMaxLevel();
        int numRacks = topology.getNumOfNodes(maxLevel - 1);
        if (replicas < requiredRacks) {
            requiredRacks = replicas;
        }
        int maxReplicasPerRack = this.getMaxReplicasPerRack(replicas, Math.min(requiredRacks, numRacks));
        return new ContainerPlacementStatusDefault(currentRackCount.size(), requiredRacks, numRacks, maxReplicasPerRack += Math.max(0, dns.size() - replicas), currentRackCount);
    }

    public void removePeers(DatanodeDetails dn, List<DatanodeDetails> healthyList) {
        if (this.shouldRemovePeers) {
            healthyList.removeAll(this.nodeManager.getPeerList(dn));
        }
    }

    public boolean isValidNode(DatanodeDetails datanodeDetails, long metadataSizeRequired, long dataSizeRequired) {
        DatanodeInfo datanodeInfo = (DatanodeInfo)this.getNodeManager().getNodeByUuid(datanodeDetails.getUuid());
        if (datanodeInfo == null) {
            LOG.error("Failed to find the DatanodeInfo for datanode {}", (Object)datanodeDetails);
            return false;
        }
        NodeStatus nodeStatus = datanodeInfo.getNodeStatus();
        if (nodeStatus.isNodeWritable() && SCMCommonPlacementPolicy.hasEnoughSpace(datanodeInfo, metadataSizeRequired, dataSizeRequired, this.conf)) {
            LOG.debug("Datanode {} is chosen. Required metadata size is {} and required data size is {} and NodeStatus is {}", new Object[]{datanodeDetails, metadataSizeRequired, dataSizeRequired, nodeStatus});
            return true;
        }
        LOG.info("Datanode {} is not chosen. Required metadata size is {} and required data size is {} and NodeStatus is {}", new Object[]{datanodeDetails, metadataSizeRequired, dataSizeRequired, nodeStatus});
        return false;
    }

    @Override
    public Set<ContainerReplica> replicasToCopyToFixMisreplication(Map<ContainerReplica, Boolean> replicas) {
        Map<Node, List<ContainerReplica>> placementGroupReplicaIdMap = replicas.keySet().stream().collect(Collectors.groupingBy(replica -> this.getPlacementGroup(replica.getDatanodeDetails())));
        int totalNumberOfReplicas = replicas.size();
        int requiredNumberOfPlacementGroups = this.getRequiredRackCount(totalNumberOfReplicas, 0);
        HashSet copyReplicaSet = Sets.newHashSet();
        List replicaSet = placementGroupReplicaIdMap.values().stream().sorted((o1, o2) -> Integer.compare(o2.size(), o1.size())).limit(requiredNumberOfPlacementGroups).collect(Collectors.toList());
        for (List replicaList : replicaSet) {
            int maxReplicasPerPlacementGroup = this.getMaxReplicasPerRack(totalNumberOfReplicas, requiredNumberOfPlacementGroups);
            int numberOfReplicasToBeCopied = Math.max(0, replicaList.size() - maxReplicasPerPlacementGroup);
            totalNumberOfReplicas -= maxReplicasPerPlacementGroup;
            --requiredNumberOfPlacementGroups;
            if (numberOfReplicasToBeCopied <= 0) continue;
            List replicasToBeCopied = replicaList.stream().filter(replicas::get).limit(numberOfReplicasToBeCopied).collect(Collectors.toList());
            if (numberOfReplicasToBeCopied > replicasToBeCopied.size()) {
                Node rack = replicaList.size() > 0 ? this.getPlacementGroup(((ContainerReplica)replicaList.get(0)).getDatanodeDetails()) : null;
                LOG.warn("Not enough copyable replicas available in rack {}. Required number of Replicas to be copied: {}. Available Replicas to be copied: {}", new Object[]{rack, numberOfReplicasToBeCopied, replicasToBeCopied.size()});
            }
            copyReplicaSet.addAll(replicasToBeCopied);
        }
        return copyReplicaSet;
    }

    protected Node getPlacementGroup(DatanodeDetails dn) {
        return this.nodeManager.getClusterNetworkTopologyMap().getAncestor((Node)dn, 1);
    }

    @Override
    public Set<ContainerReplica> replicasToRemoveToFixOverreplication(Set<ContainerReplica> replicas, int expectedCountPerUniqueReplica) {
        Integer rid2;
        HashMap<Integer, Set> replicaIdMap = new HashMap<Integer, Set>();
        HashMap<Node, Map> placementGroupReplicaIdMap = new HashMap<Node, Map>();
        HashMap<Node, Integer> placementGroupCntMap = new HashMap<Node, Integer>();
        for (ContainerReplica replica : replicas) {
            Integer replicaId = replica.getReplicaIndex();
            Node placementGroup = this.getPlacementGroup(replica.getDatanodeDetails());
            replicaIdMap.computeIfAbsent(replicaId, rid -> Sets.newHashSet()).add(replica);
            placementGroupCntMap.compute(placementGroup, (group, cnt) -> (cnt == null ? 0 : cnt) + 1);
            placementGroupReplicaIdMap.computeIfAbsent(placementGroup, pg -> Maps.newHashMap()).computeIfAbsent(replicaId, rid -> Sets.newHashSet()).add(replica);
        }
        HashSet<ContainerReplica> replicasToRemove = new HashSet<ContainerReplica>();
        List sortedRIDList = replicaIdMap.keySet().stream().filter(rid -> ((Set)replicaIdMap.get(rid)).size() > expectedCountPerUniqueReplica).sorted((o1, o2) -> Integer.compare(((Set)replicaIdMap.get(o2)).size(), ((Set)replicaIdMap.get(o1)).size())).collect(Collectors.toList());
        Iterator iterator = sortedRIDList.iterator();
        while (iterator.hasNext() && ((Set)replicaIdMap.get(rid2 = (Integer)iterator.next())).size() > expectedCountPerUniqueReplica) {
            PriorityQueue<Node> pq = new PriorityQueue<Node>((o1, o2) -> Integer.compare((Integer)placementGroupCntMap.get(o2), (Integer)placementGroupCntMap.get(o1)));
            pq.addAll(placementGroupReplicaIdMap.entrySet().stream().filter(nodeMapEntry -> ((Map)nodeMapEntry.getValue()).containsKey(rid2)).map(Map.Entry::getKey).collect(Collectors.toList()));
            while (((Set)replicaIdMap.get(rid2)).size() > expectedCountPerUniqueReplica) {
                Node rack = (Node)pq.poll();
                Set replicaSet = (Set)((Map)placementGroupReplicaIdMap.get(rack)).get(rid2);
                if (replicaSet.size() <= 0) continue;
                ContainerReplica r = (ContainerReplica)replicaSet.stream().findFirst().get();
                replicasToRemove.add(r);
                replicaSet.remove(r);
                ((Set)replicaIdMap.get(rid2)).remove(r);
                placementGroupCntMap.compute(rack, (group, cnt) -> (cnt == null ? 0 : cnt) - 1);
                if (replicaSet.size() == 0) {
                    ((Map)placementGroupReplicaIdMap.get(rack)).remove(rid2);
                    continue;
                }
                pq.add(rack);
            }
        }
        return replicasToRemove;
    }
}

