/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.safemode.Precheck;
import org.apache.hadoop.hdds.scm.security.RootCARotationManager;
import org.apache.hadoop.hdds.scm.server.ContainerReportQueue;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ScmUtils.class);

    private ScmUtils() {
    }

    public static void preCheck(HddsProtos.ScmOps operation, Precheck ... preChecks) throws SCMException {
        for (Precheck preCheck : preChecks) {
            preCheck.check(operation);
        }
    }

    public static File createSCMDir(String dirPath) {
        File dirFile = new File(dirPath);
        if (!dirFile.mkdirs() && !dirFile.exists()) {
            throw new IllegalArgumentException("Unable to create path: " + dirFile);
        }
        return dirFile;
    }

    public static InetSocketAddress getScmBlockProtocolServerAddress(OzoneConfiguration conf, String localScmServiceId, String nodeId) {
        String bindHostKey = ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.bind.host", (String[])new String[]{localScmServiceId, nodeId});
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{bindHostKey});
        String addressKey = ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.address", (String[])new String[]{localScmServiceId, nodeId});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{addressKey});
        if (port.isPresent()) {
            ScmUtils.logWarn("ozone.scm.block.client.address", "ozone.scm.block.client.port");
        }
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(conf.getInt(ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.port", (String[])new String[]{localScmServiceId, nodeId}), conf.getInt("ozone.scm.block.client.port", 9863)))));
    }

    public static String getScmBlockProtocolServerAddressKey(String serviceId, String nodeId) {
        return ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.address", (String[])new String[]{serviceId, nodeId});
    }

    public static InetSocketAddress getClientProtocolServerAddress(OzoneConfiguration conf, String localScmServiceId, String nodeId) {
        String bindHostKey = ConfUtils.addKeySuffixes((String)"ozone.scm.client.bind.host", (String[])new String[]{localScmServiceId, nodeId});
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{bindHostKey}).orElse("0.0.0.0");
        String addressKey = ConfUtils.addKeySuffixes((String)"ozone.scm.client.address", (String[])new String[]{localScmServiceId, nodeId});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{addressKey});
        if (port.isPresent()) {
            ScmUtils.logWarn("ozone.scm.client.address", "ozone.scm.client.port");
        }
        return NetUtils.createSocketAddr((String)(host + ":" + port.orElse(conf.getInt(ConfUtils.addKeySuffixes((String)"ozone.scm.client.port", (String[])new String[]{localScmServiceId, nodeId}), conf.getInt("ozone.scm.client.port", 9860)))));
    }

    public static String getClientProtocolServerAddressKey(String serviceId, String nodeId) {
        return ConfUtils.addKeySuffixes((String)"ozone.scm.client.address", (String[])new String[]{serviceId, nodeId});
    }

    public static InetSocketAddress getScmDataNodeBindAddress(ConfigurationSource conf, String localScmServiceId, String nodeId) {
        String bindHostKey = ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.bind.host", (String[])new String[]{localScmServiceId, nodeId});
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{bindHostKey});
        String addressKey = ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.address", (String[])new String[]{localScmServiceId, nodeId});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{addressKey});
        if (port.isPresent()) {
            ScmUtils.logWarn("ozone.scm.datanode.address", "ozone.scm.datanode.port");
        }
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(conf.getInt(ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.port", (String[])new String[]{localScmServiceId, nodeId}), conf.getInt("ozone.scm.datanode.port", 9861)))));
    }

    public static String getScmDataNodeBindAddressKey(String serviceId, String nodeId) {
        return ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.address", (String[])new String[]{serviceId, nodeId});
    }

    private static void logWarn(String confKey, String portKey) {
        LOG.warn("ConfigKey {} is deprecated, For configuring different ports for each SCM use PortConfigKey {} appended with serviceId and nodeId. If want to configure same port configure {}", new Object[]{confKey, portKey, portKey});
    }

    public static boolean shouldRemovePeers(ConfigurationSource conf) {
        int pipelineLimitPerDn = conf.getInt("ozone.scm.datanode.pipeline.limit", 2);
        return 1 != pipelineLimitPerDn && conf.getBoolean("ozone.scm.datanode.disallow.same.peers", false);
    }

    @NotNull
    public static List<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> initContainerReportQueue(OzoneConfiguration configuration) {
        int threadPoolSize = configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".thread.pool.size", 10);
        int queueSize = configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".queue.size", 100000);
        ArrayList<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> queues = new ArrayList<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>>();
        for (int i = 0; i < threadPoolSize; ++i) {
            queues.add(new ContainerReportQueue(queueSize));
        }
        return queues;
    }

    public static String getContainerReportConfPrefix() {
        return "ozone.scm.event." + StringUtils.camelize((String)(SCMEvents.CONTAINER_REPORT.getName() + "_OR_" + SCMEvents.INCREMENTAL_CONTAINER_REPORT.getName()));
    }

    public static void checkIfCertSignRequestAllowed(RootCARotationManager rotationManager, boolean isScmCertRenew, OzoneConfiguration config, String operation) throws SCMException {
        if (rotationManager != null) {
            if (rotationManager.isRotationInProgress() && !isScmCertRenew) {
                throw new SCMException("Root CA and Sub CA rotation is in-progress. Please try the operation later again.", SCMException.ResultCodes.CA_ROTATION_IN_PROGRESS);
            }
            if (rotationManager.isPostRotationInProgress()) {
                SecurityConfig securityConfig = new SecurityConfig((ConfigurationSource)config);
                throw new SCMException("The operation " + operation + " is prohibited due to root CA and sub CA rotation have just finished. The prohibition state will last at most " + securityConfig.getRootCaCertificatePollingInterval() + ". Please try the operation later again.", SCMException.ResultCodes.CA_ROTATION_IN_POST_PROGRESS);
            }
        }
    }
}

