/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import java.util.Comparator;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.container.balancer.FindSourceStrategy;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerBalancerSelectionCriteria {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerBalancerSelectionCriteria.class);
    private ContainerBalancerConfiguration balancerConfiguration;
    private NodeManager nodeManager;
    private ReplicationManager replicationManager;
    private ContainerManager containerManager;
    private Set<ContainerID> selectedContainers;
    private Set<ContainerID> excludeContainers;
    private FindSourceStrategy findSourceStrategy;

    public ContainerBalancerSelectionCriteria(ContainerBalancerConfiguration balancerConfiguration, NodeManager nodeManager, ReplicationManager replicationManager, ContainerManager containerManager, FindSourceStrategy findSourceStrategy) {
        this.balancerConfiguration = balancerConfiguration;
        this.nodeManager = nodeManager;
        this.replicationManager = replicationManager;
        this.containerManager = containerManager;
        this.selectedContainers = new HashSet<ContainerID>();
        this.excludeContainers = balancerConfiguration.getExcludeContainers();
        this.findSourceStrategy = findSourceStrategy;
    }

    private boolean isContainerReplicatingOrDeleting(ContainerID containerID) {
        return this.replicationManager.isContainerReplicatingOrDeleting(containerID);
    }

    public NavigableSet<ContainerID> getCandidateContainers(DatanodeDetails node, long sizeMovedAlready) {
        TreeSet<ContainerID> containerIDSet = new TreeSet<ContainerID>(this.orderContainersByUsedBytes().reversed());
        try {
            containerIDSet.addAll(this.nodeManager.getContainers(node));
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Could not find Datanode {} while selecting candidate containers for Container Balancer.", (Object)node.toString(), (Object)e);
            return containerIDSet;
        }
        if (this.excludeContainers != null) {
            containerIDSet.removeAll(this.excludeContainers);
        }
        if (this.selectedContainers != null) {
            containerIDSet.removeAll(this.selectedContainers);
        }
        containerIDSet.removeIf(containerID -> this.shouldBeExcluded((ContainerID)containerID, node, sizeMovedAlready));
        return containerIDSet;
    }

    private int isContainerMoreUsed(ContainerID first, ContainerID second) {
        if (first.equals((Object)second)) {
            return 0;
        }
        try {
            ContainerInfo firstInfo = this.containerManager.getContainer(first);
            ContainerInfo secondInfo = this.containerManager.getContainer(second);
            if (firstInfo.getUsedBytes() > secondInfo.getUsedBytes()) {
                return 1;
            }
            if (firstInfo.getUsedBytes() < secondInfo.getUsedBytes()) {
                return -1;
            }
            return first.compareTo(second);
        }
        catch (ContainerNotFoundException e) {
            LOG.warn("Could not retrieve ContainerInfo from container manager for comparison.", (Throwable)e);
            return 0;
        }
    }

    private Comparator<ContainerID> orderContainersByUsedBytes() {
        return this::isContainerMoreUsed;
    }

    private boolean isECContainer(ContainerInfo container) {
        return container.getReplicationType().equals((Object)HddsProtos.ReplicationType.EC) && this.replicationManager.getConfig().isLegacyEnabled();
    }

    private boolean shouldBeExcluded(ContainerID containerID, DatanodeDetails node, long sizeMovedAlready) {
        ContainerInfo container;
        try {
            container = this.containerManager.getContainer(containerID);
        }
        catch (ContainerNotFoundException e) {
            LOG.warn("Could not find Container {} to check if it should be a candidate container. Excluding it.", (Object)containerID);
            return true;
        }
        return !this.isContainerClosed(container, node) || this.isECContainer(container) || this.isContainerReplicatingOrDeleting(containerID) || !this.findSourceStrategy.canSizeLeaveSource(node, container.getUsedBytes()) || this.breaksMaxSizeToMoveLimit(container.containerID(), container.getUsedBytes(), sizeMovedAlready);
    }

    private boolean isContainerClosed(ContainerInfo container, DatanodeDetails datanodeDetails) {
        Set<ContainerReplica> replicas;
        if (!container.getState().equals((Object)HddsProtos.LifeCycleState.CLOSED)) {
            return false;
        }
        try {
            replicas = this.containerManager.getContainerReplicas(container.containerID());
        }
        catch (ContainerNotFoundException e) {
            LOG.warn("Container {} does not exist in ContainerManager. Skipping this container.", (Object)container.getContainerID(), (Object)e);
            return false;
        }
        for (ContainerReplica replica : replicas) {
            if (!replica.getDatanodeDetails().equals((Object)datanodeDetails)) continue;
            return replica.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED);
        }
        return false;
    }

    private boolean breaksMaxSizeToMoveLimit(ContainerID containerID, long usedBytes, long sizeMovedAlready) {
        if (sizeMovedAlready + usedBytes > this.balancerConfiguration.getMaxSizeToMovePerIteration()) {
            LOG.debug("Removing container {} because it fails max size to move per iteration check.", (Object)containerID);
            return true;
        }
        return false;
    }

    public void setExcludeContainers(Set<ContainerID> excludeContainers) {
        this.excludeContainers = excludeContainers;
    }

    public void setSelectedContainers(Set<ContainerID> selectedContainers) {
        this.selectedContainers = selectedContainers;
    }
}

