/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.metrics;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="SCM ContainerManager metrics", context="ozone")
public final class SCMContainerManagerMetrics {
    private static final String SOURCE_NAME = SCMContainerManagerMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numSuccessfulCreateContainers;
    @Metric
    private MutableCounterLong numFailureCreateContainers;
    @Metric
    private MutableCounterLong numSuccessfulDeleteContainers;
    @Metric
    private MutableCounterLong numFailureDeleteContainers;
    @Metric
    private MutableCounterLong numListContainerOps;
    @Metric
    private MutableCounterLong numContainerReportsProcessedSuccessful;
    @Metric
    private MutableCounterLong numContainerReportsProcessedFailed;
    @Metric
    private MutableCounterLong numICRReportsProcessedSuccessful;
    @Metric
    private MutableCounterLong numICRReportsProcessedFailed;

    private SCMContainerManagerMetrics() {
    }

    public static SCMContainerManagerMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMContainerManagerMetrics)ms.register(SOURCE_NAME, "SCM ContainerManager Metrics", (Object)new SCMContainerManagerMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void incNumSuccessfulCreateContainers() {
        this.numSuccessfulCreateContainers.incr();
    }

    public void incNumFailureCreateContainers() {
        this.numFailureCreateContainers.incr();
    }

    public void incNumSuccessfulDeleteContainers() {
        this.numSuccessfulDeleteContainers.incr();
    }

    public void incNumFailureDeleteContainers() {
        this.numFailureDeleteContainers.incr();
    }

    public void incNumListContainersOps() {
        this.numListContainerOps.incr();
    }

    public void incNumContainerReportsProcessedSuccessful() {
        this.numContainerReportsProcessedSuccessful.incr();
    }

    public void incNumContainerReportsProcessedFailed() {
        this.numContainerReportsProcessedFailed.incr();
    }

    public void incNumICRReportsProcessedSuccessful() {
        this.numICRReportsProcessedSuccessful.incr();
    }

    public void incNumICRReportsProcessedFailed() {
        this.numICRReportsProcessedFailed.incr();
    }

    public long getNumContainerReportsProcessedSuccessful() {
        return this.numContainerReportsProcessedSuccessful.value();
    }

    public long getNumContainerReportsProcessedFailed() {
        return this.numContainerReportsProcessedFailed.value();
    }

    public long getNumICRReportsProcessedSuccessful() {
        return this.numICRReportsProcessedSuccessful.value();
    }

    public long getNumICRReportsProcessedFailed() {
        return this.numICRReportsProcessedFailed.value();
    }

    public long getNumSuccessfulCreateContainers() {
        return this.numSuccessfulCreateContainers.value();
    }

    public long getNumFailureCreateContainers() {
        return this.numFailureCreateContainers.value();
    }

    public long getNumSuccessfulDeleteContainers() {
        return this.numSuccessfulDeleteContainers.value();
    }

    public long getNumFailureDeleteContainers() {
        return this.numFailureDeleteContainers.value();
    }

    public long getNumListContainersOps() {
        return this.numListContainerOps.value();
    }
}

